/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics.source;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.ResettableSlidingWindowReservoir;
import org.apache.celeborn.common.metrics.RssHistogram;
import org.apache.celeborn.common.metrics.RssTimer;
import org.apache.celeborn.common.metrics.source.AbstractSource$;
import org.apache.celeborn.common.metrics.source.GaugeSupplier;
import org.apache.celeborn.common.metrics.source.NamedCounter;
import org.apache.celeborn.common.metrics.source.NamedGauge;
import org.apache.celeborn.common.metrics.source.NamedHistogram;
import org.apache.celeborn.common.metrics.source.NamedTimer;
import org.apache.celeborn.common.metrics.source.Source;
import org.apache.celeborn.common.metrics.source.TimerSupplier;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tEg!\u0002\u001c8\u0003\u0003!\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!\u0011!Q\u0001\nmCQA\u001a\u0001\u0005\u0002\u001dDqa\u001b\u0001C\u0002\u0013\u0005C\u000e\u0003\u0004w\u0001\u0001\u0006I!\u001c\u0005\bo\u0002\u0011\r\u0011\"\u0001y\u0011\u0019a\b\u0001)A\u0005s\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u0003\u0001\u0001\u0006Ia \u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"!\u0005\u0001A\u0003%\u00111\u0002\u0005\t\u0003'\u0001!\u0019!C\u0003q\"9\u0011Q\u0003\u0001!\u0002\u001bI\b\"CA\f\u0001\t\u0007I\u0011AA\r\u0011!\ty\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0019\u0001\t\u0007I\u0011AA\u001a\u0011!\tY\u0004\u0001Q\u0001\n\u0005U\u0002\"CA\u001f\u0001\t\u0007I\u0011AA \u0011!\t9\u0005\u0001Q\u0001\n\u0005\u0005\u0003\"CA%\u0001\t\u0007I\u0011CA&\u0011!\t)\u0007\u0001Q\u0001\n\u00055\u0003bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003k\u0002A\u0011AAK\u0011%\tI\u000b\u0001b\u0001\n#\tY\u000b\u0003\u0005\u0002H\u0002\u0001\u000b\u0011BAW\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017D\u0011\"a4\u0001\u0005\u0004%\t\"!5\t\u0011\u0005m\u0007\u0001)A\u0005\u0003'Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002d\u0002!\t\"!:\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9!q\u0001\u0001\u0005\u0012\t%\u0001b\u0002B\n\u0001\u0011E!Q\u0003\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011i\u0002\u0001C!\u0005?AqA!\u000f\u0001\t\u0003\u0012Y\u0004C\u0004\u0003B\u0001!\tEa\u0011\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!\u0011\u000b\u0001\u0005\u0012\tM\u0003b\u0002B-\u0001\u0011\u0005#1\f\u0005\n\u0005G\u0002\u0011\u0013!C\u0001\u0005KBqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\u0004\u0002!\tB!\"\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!q\u0012\u0001\u0005\u0002\tE\u0005b\u0002BL\u0001\u0011\u0005!\u0011\u0014\u0005\b\u0005S\u0003A\u0011\u0001BV\u0011\u001d\u0011\t\f\u0001C\u0001\u0005gCqA!/\u0001\t\u0003\u0012Y\fC\u0004\u0003>\u0002!\tBa0\t\u000f\t\r\u0007\u0001\"\u0005\u0003F\"I!1\u001a\u0001C\u0002\u0013\u0005!Q\u001a\u0005\b\u0005\u001f\u0004\u0001\u0015!\u0003\\\u00059\t%m\u001d;sC\u000e$8k\\;sG\u0016T!\u0001O\u001d\u0002\rM|WO]2f\u0015\tQ4(A\u0004nKR\u0014\u0018nY:\u000b\u0005qj\u0014AB2p[6|gN\u0003\u0002?\u007f\u0005A1-\u001a7fE>\u0014hN\u0003\u0002A\u0003\u00061\u0011\r]1dQ\u0016T\u0011AQ\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0015[u\n\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u00196k\u0011aN\u0005\u0003\u001d^\u0012aaU8ve\u000e,\u0007C\u0001)T\u001b\u0005\t&B\u0001*<\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001+R\u0005\u001daunZ4j]\u001e\fAaY8oMB\u0011q\u000bW\u0007\u0002w%\u0011\u0011l\u000f\u0002\r\u0007\u0016dWMY8s]\u000e{gNZ\u0001\u0005e>dW\r\u0005\u0002]G:\u0011Q,\u0019\t\u0003=\u001ek\u0011a\u0018\u0006\u0003A\u000e\u000ba\u0001\u0010:p_Rt\u0014B\u00012H\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t<\u0015A\u0002\u001fj]&$h\bF\u0002iS*\u0004\"\u0001\u0014\u0001\t\u000bU\u001b\u0001\u0019\u0001,\t\u000bi\u001b\u0001\u0019A.\u0002\u001d5,GO]5d%\u0016<\u0017n\u001d;ssV\tQ\u000e\u0005\u0002oi6\tqN\u0003\u0002;a*\u0011\u0011O]\u0001\tG>$\u0017\r[1mK*\t1/A\u0002d_6L!!^8\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss\u0006yQ.\u001a;sS\u000e\u0014VmZ5tiJL\b%\u0001\rnKR\u0014\u0018nY:TY&$\u0017N\\4XS:$wn^*ju\u0016,\u0012!\u001f\t\u0003\rjL!a_$\u0003\u0007%sG/A\rnKR\u0014\u0018nY:TY&$\u0017N\\4XS:$wn^*ju\u0016\u0004\u0013!E7fiJL7m]*b[BdWMU1uKV\tq\u0010E\u0002G\u0003\u0003I1!a\u0001H\u0005\u0019!u.\u001e2mK\u0006\u0011R.\u001a;sS\u000e\u001c8+Y7qY\u0016\u0014\u0016\r^3!\u0003uiW\r\u001e:jGN\u001cu\u000e\u001c7fGR\u001c%/\u001b;jG\u0006dWI\\1cY\u0016$WCAA\u0006!\r1\u0015QB\u0005\u0004\u0003\u001f9%a\u0002\"p_2,\u0017M\\\u0001\u001f[\u0016$(/[2t\u0007>dG.Z2u\u0007JLG/[2bY\u0016s\u0017M\u00197fI\u0002\nq\"\\3ue&\u001c7oQ1qC\u000eLG/_\u0001\u0011[\u0016$(/[2t\u0007\u0006\u0004\u0018mY5us\u0002\nA\"\u001b8oKJlU\r\u001e:jGN,\"!a\u0007\u0011\u000b\u0005u\u00111F.\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)#a\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0010\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\fQ\"\u001b8oKJlU\r\u001e:jGN\u0004\u0013!\u0004;j[\u0016\u00148+\u001e9qY&,'/\u0006\u0002\u00026A\u0019A*a\u000e\n\u0007\u0005erGA\u0007US6,'oU;qa2LWM]\u0001\u000fi&lWM]*vaBd\u0017.\u001a:!\u00039iW\r\u001e:jGN\u001cE.Z1oKJ,\"!!\u0011\u0011\t\u0005u\u00111I\u0005\u0005\u0003\u000b\nyB\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fq\"\\3ue&\u001c7o\u00117fC:,'\u000fI\u0001\f]\u0006lW\rZ$bk\u001e,7/\u0006\u0002\u0002NA1\u0011qJA)\u0003+j!!a\t\n\t\u0005M\u00131\u0005\u0002\u0005\u0019&\u001cH\u000f\r\u0003\u0002X\u0005\u0005\u0004#\u0002'\u0002Z\u0005u\u0013bAA.o\tQa*Y7fI\u001e\u000bWoZ3\u0011\t\u0005}\u0013\u0011\r\u0007\u0001\t-\t\u0019'FA\u0001\u0002\u0003\u0015\t!a\u001a\u0003\u0007}#\u0013'\u0001\u0007oC6,GmR1vO\u0016\u001c\b%\u0005\u0003\u0002j\u0005=\u0004c\u0001$\u0002l%\u0019\u0011QN$\u0003\u000f9{G\u000f[5oOB\u0019a)!\u001d\n\u0007\u0005MtIA\u0002B]f\f\u0001\"\u00193e\u000f\u0006,x-Z\u000b\u0005\u0003s\n\t\n\u0006\u0004\u0002|\u0005\u0005\u0015Q\u0011\t\u0004\r\u0006u\u0014bAA@\u000f\n!QK\\5u\u0011\u0019\t\u0019I\u0006a\u00017\u0006!a.Y7f\u0011\u001d\t9I\u0006a\u0001\u0003\u0013\u000b\u0011A\u001a\t\b\r\u0006-\u00151PAH\u0013\r\tii\u0012\u0002\n\rVt7\r^5p]F\u0002B!a\u0018\u0002\u0012\u00129\u00111\u0013\fC\u0002\u0005\u001d$!\u0001+\u0016\t\u0005]\u0015q\u0015\u000b\u0007\u0003w\nI*a'\t\r\u0005\ru\u00031\u0001\\\u0011\u001d\tij\u0006a\u0001\u0003?\u000bQaZ;bO\u0016\u0004RA\\AQ\u0003KK1!a)p\u0005\u00159\u0015-^4f!\u0011\ty&a*\u0005\u000f\u0005MuC1\u0001\u0002h\u0005Ya.Y7fIRKW.\u001a:t+\t\ti\u000bE\u0004\u0002\u001e\u0005=6,a-\n\t\u0005E\u0016q\u0004\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bc\u0002$\u00026\u0006e\u0016qX\u0005\u0004\u0003o;%A\u0002+va2,'\u0007E\u0002M\u0003wK1!!08\u0005)q\u0015-\\3e)&lWM\u001d\t\b\u0003;\tykWAa!\r1\u00151Y\u0005\u0004\u0003\u000b<%\u0001\u0002'p]\u001e\fAB\\1nK\u0012$\u0016.\\3sg\u0002\n\u0001\"\u00193e)&lWM\u001d\u000b\u0005\u0003w\ni\r\u0003\u0004\u0002\u0004j\u0001\raW\u0001\u000e]\u0006lW\rZ\"pk:$XM]:\u0016\u0005\u0005M\u0007cBA\u000f\u0003_[\u0016Q\u001b\t\u0004\u0019\u0006]\u0017bAAmo\taa*Y7fI\u000e{WO\u001c;fe\u0006qa.Y7fI\u000e{WO\u001c;feN\u0004\u0013AC1eI\u000e{WO\u001c;feR!\u00111PAq\u0011\u0019\t\u0019)\ba\u00017\u0006A1m\\;oi\u0016\u00148\u000f\u0006\u0002\u0002hB1\u0011\u0011^Az\u0003+tA!a;\u0002p:\u0019a,!<\n\u0003!K1!!=H\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0015\u0002v*\u0019\u0011\u0011_$\u0002\r\u001d\fWoZ3t)\t\tY\u0010\u0005\u0004\u0002j\u0006M\u0018Q \u0019\u0005\u0003\u007f\u0014\u0019\u0001E\u0003M\u00033\u0012\t\u0001\u0005\u0003\u0002`\t\rAa\u0003B\u0003?\u0005\u0005\t\u0011!B\u0001\u0003O\u00121a\u0018\u00135\u0003)A\u0017n\u001d;pOJ\fWn\u001d\u000b\u0003\u0005\u0017\u0001b!!;\u0002t\n5\u0001c\u0001'\u0003\u0010%\u0019!\u0011C\u001c\u0003\u001d9\u000bW.\u001a3ISN$xn\u001a:b[\u00061A/[7feN$\"Aa\u0006\u0011\r\u0005%\u00181_A]\u0003)qW-\u001a3TC6\u0004H.\u001a\u000b\u0003\u0003\u0017\taa]1na2,W\u0003\u0002B\u0011\u0005O!bAa\t\u00032\tUB\u0003\u0002B\u0013\u0005S\u0001B!a\u0018\u0003(\u00119\u00111S\u0012C\u0002\u0005\u001d\u0004\u0002CADG\u0011\u0005\rAa\u000b\u0011\u000b\u0019\u0013iC!\n\n\u0007\t=rI\u0001\u0005=Eft\u0017-\\3?\u0011\u0019\u0011\u0019d\ta\u00017\u0006YQ.\u001a;sS\u000e\u001ch*Y7f\u0011\u0019\u00119d\ta\u00017\u0006\u00191.Z=\u0002\u0015M$\u0018M\u001d;US6,'\u000f\u0006\u0004\u0002|\tu\"q\b\u0005\u0007\u0005g!\u0003\u0019A.\t\r\t]B\u00051\u0001\\\u0003%\u0019Ho\u001c9US6,'\u000f\u0006\u0004\u0002|\t\u0015#q\t\u0005\u0007\u0005g)\u0003\u0019A.\t\r\t]R\u00051\u0001\\\u00031!wn\u0015;beR$\u0016.\\3s)\u0019\tYH!\u0014\u0003P!1!1\u0007\u0014A\u0002mCaAa\u000e'\u0001\u0004Y\u0016a\u00033p'R|\u0007\u000fV5nKJ$b!a\u001f\u0003V\t]\u0003B\u0002B\u001aO\u0001\u00071\f\u0003\u0004\u00038\u001d\u0002\raW\u0001\u000bS:\u001c7i\\;oi\u0016\u0014HCBA>\u0005;\u0012y\u0006\u0003\u0004\u00034!\u0002\ra\u0017\u0005\n\u0005CB\u0003\u0013!a\u0001\u0003\u0003\fA!\u001b8d-\u0006!\u0012N\\2D_VtG/\u001a:%I\u00164\u0017-\u001e7uII*\"Aa\u001a+\t\u0005\u0005'\u0011N\u0016\u0003\u0005W\u0002BA!\u001c\u0003x5\u0011!q\u000e\u0006\u0005\u0005c\u0012\u0019(A\u0005v]\u000eDWmY6fI*\u0019!QO$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003z\t=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1\r\\3be>cGMV1mk\u0016\u001cH\u0003BA>\u0005\u007fBqA!!+\u0001\u0004\ty,A\u0002nCB\fAb\u001d;beR\u001cE.Z1oKJ$\"!a\u001f\u0002%U\u0004H-\u0019;f\u0013:tWM]'fiJL7m\u001d\u000b\u0005\u0003w\u0012Y\t\u0003\u0004\u0003\u000e2\u0002\raW\u0001\u0004gR\u0014\u0018!\u0004:fG>\u0014HmQ8v]R,'\u000f\u0006\u0003\u0002|\tM\u0005b\u0002BK[\u0001\u0007\u0011Q[\u0001\u0003]\u000e\f1B]3d_J$w)Y;hKR!\u00111\u0010BN\u0011\u001d\u0011iJ\fa\u0001\u0005?\u000b!A\\41\t\t\u0005&Q\u0015\t\u0006\u0019\u0006e#1\u0015\t\u0005\u0003?\u0012)\u000b\u0002\u0007\u0003(\nm\u0015\u0011!A\u0001\u0006\u0003\t9GA\u0002`IU\nqB]3d_J$\u0007*[:u_\u001e\u0014\u0018-\u001c\u000b\u0005\u0003w\u0012i\u000bC\u0004\u00030>\u0002\rA!\u0004\u0002\u00059D\u0017a\u0003:fG>\u0014H\rV5nKJ$B!a\u001f\u00036\"9!q\u0017\u0019A\u0002\u0005e\u0016A\u00018u\u0003)9W\r^'fiJL7m\u001d\u000b\u00027\u0006aan\u001c:nC2L'0Z&fsR\u00191L!1\t\r\t]\"\u00071\u0001\\\u0003I\u0011X\r]8si:\u000bgn\\:Bg6KG\u000e\\:\u0015\u0007}\u00149\r\u0003\u0004\u0003JN\u0002\ra`\u0001\u0006m\u0006dW/Z\u0001\u0006Y\u0006\u0014W\r\\\u000b\u00027\u00061A.\u00192fY\u0002\u0002")
public abstract class AbstractSource
implements Source,
Logging {
    private final MetricRegistry metricRegistry;
    private final int metricsSlidingWindowSize;
    private final double metricsSampleRate;
    private final boolean metricsCollectCriticalEnabled;
    private final int metricsCapacity;
    private final ConcurrentLinkedQueue<String> innerMetrics;
    private final TimerSupplier timerSupplier;
    private final ScheduledExecutorService metricsCleaner;
    private final java.util.List<NamedGauge<?>> namedGauges;
    private final ConcurrentHashMap<String, Tuple2<NamedTimer, ConcurrentHashMap<String, Object>>> namedTimers;
    private final ConcurrentHashMap<String, NamedCounter> namedCounters;
    private final String label;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        AbstractSource abstractSource = this;
        synchronized (abstractSource) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    public int metricsSlidingWindowSize() {
        return this.metricsSlidingWindowSize;
    }

    public double metricsSampleRate() {
        return this.metricsSampleRate;
    }

    public boolean metricsCollectCriticalEnabled() {
        return this.metricsCollectCriticalEnabled;
    }

    public final int metricsCapacity() {
        return this.metricsCapacity;
    }

    public ConcurrentLinkedQueue<String> innerMetrics() {
        return this.innerMetrics;
    }

    public TimerSupplier timerSupplier() {
        return this.timerSupplier;
    }

    public ScheduledExecutorService metricsCleaner() {
        return this.metricsCleaner;
    }

    public java.util.List<NamedGauge<?>> namedGauges() {
        return this.namedGauges;
    }

    public <T> void addGauge(String name, Function1<BoxedUnit, T> f) {
        GaugeSupplier<T> supplier = new GaugeSupplier<T>(f);
        Gauge gauge = this.metricRegistry().gauge(name, supplier);
        this.namedGauges().add(new NamedGauge(name, gauge));
    }

    public <T> void addGauge(String name, Gauge<T> guage) {
        this.namedGauges().add(new NamedGauge<T>(name, guage));
    }

    public ConcurrentHashMap<String, Tuple2<NamedTimer, ConcurrentHashMap<String, Object>>> namedTimers() {
        return this.namedTimers;
    }

    public void addTimer(String name) {
        NamedTimer namedTimer = new NamedTimer(name, this.metricRegistry().timer(name, (MetricRegistry.MetricSupplier)this.timerSupplier()));
        this.namedTimers().putIfAbsent(name, (Tuple2<NamedTimer, ConcurrentHashMap<String, Object>>)new Tuple2((Object)namedTimer, new ConcurrentHashMap()));
    }

    public ConcurrentHashMap<String, NamedCounter> namedCounters() {
        return this.namedCounters;
    }

    public void addCounter(String name) {
        this.namedCounters().put(name, new NamedCounter(name, this.metricRegistry().counter(name)));
    }

    public List<NamedCounter> counters() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.namedCounters().values()).asScala()).toList();
    }

    public List<NamedGauge<?>> gauges() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.namedGauges()).asScala()).toList();
    }

    public List<NamedHistogram> histograms() {
        return List$.MODULE$.empty();
    }

    public List<NamedTimer> timers() {
        return (List)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.namedTimers().values()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> (NamedTimer)x$1._1(), List$.MODULE$.canBuildFrom());
    }

    public boolean needSample() {
        return this.metricsSampleRate() >= 1.0 ? true : (this.metricsSampleRate() <= 0.0 ? false : Random$.MODULE$.nextDouble() <= this.metricsSampleRate());
    }

    @Override
    public <T> T sample(String metricsName, String key, Function0<T> f) {
        boolean sample = this.needSample();
        Object r = null;
        try {
            if (sample) {
                this.doStartTimer(metricsName, key);
            }
            r = f.apply();
        }
        finally {
            if (sample) {
                this.doStopTimer(metricsName, key);
            }
        }
        return (T)r;
    }

    @Override
    public void startTimer(String metricsName, String key) {
        block0: {
            if (!this.needSample()) break block0;
            this.doStartTimer(metricsName, key);
        }
    }

    @Override
    public void stopTimer(String metricsName, String key) {
        this.doStopTimer(metricsName, key);
    }

    public void doStartTimer(String metricsName, String key) {
        Tuple2<NamedTimer, ConcurrentHashMap<String, Object>> pair = this.namedTimers().get(metricsName);
        if (pair != null) {
            ((ConcurrentHashMap)pair._2()).put(key, BoxesRunTime.boxToLong((long)System.nanoTime()));
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Metric ").append(metricsName).append(" not found!").toString());
        }
    }

    public void doStopTimer(String metricsName, String key) {
        block7: {
            try {
                Option startTime;
                Tuple2<NamedTimer, ConcurrentHashMap<String, Object>> tuple2 = this.namedTimers().get(metricsName);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                NamedTimer namedTimer = (NamedTimer)tuple2._1();
                ConcurrentHashMap map = (ConcurrentHashMap)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)namedTimer, (Object)map);
                Tuple2 tuple23 = tuple22;
                NamedTimer namedTimer2 = (NamedTimer)tuple23._1();
                ConcurrentHashMap map2 = (ConcurrentHashMap)tuple23._2();
                Option option = startTime = Option$.MODULE$.apply(map2.remove(key));
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    long t = BoxesRunTime.unboxToLong((Object)some.value());
                    namedTimer2.timer().update(System.nanoTime() - t, TimeUnit.NANOSECONDS);
                    if (namedTimer2.timer().getCount() % (long)this.metricsSlidingWindowSize() == 0L) {
                        this.recordTimer(namedTimer2);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block7;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered in Metrics StopTimer", e);
            }
        }
    }

    @Override
    public void incCounter(String metricsName, long incV) {
        NamedCounter counter = this.namedCounters().get(metricsName);
        if (counter != null) {
            counter.counter().inc(incV);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Metric ").append(metricsName).append(" not found!").toString());
        }
    }

    public long incCounter$default$2() {
        return 1L;
    }

    public void org$apache$celeborn$common$metrics$source$AbstractSource$$clearOldValues(ConcurrentHashMap<String, Object> map) {
        if (map.size() > 5000) {
            long threshTime = System.nanoTime() - 900000000000L;
            Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (BoxesRunTime.unboxToLong((Object)entry.getValue()) >= threshTime) continue;
                it.remove();
            }
        }
    }

    public void startCleaner() {
        Runnable cleanTask = new Runnable(this){
            private final /* synthetic */ AbstractSource $outer;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter($this.$outer.namedTimers().values()).asScala()).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1 & Serializable & scala.Serializable)x$3 -> (ConcurrentHashMap)x$3._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConcurrentHashMap.class))))).foreach((Function1 & Serializable & scala.Serializable)map -> {
                    $anon$1.$anonfun$run$3(this, map);
                    return BoxedUnit.UNIT;
                }));
            }

            public static final /* synthetic */ void $anonfun$run$3($anon$1 $this, ConcurrentHashMap map) {
                $this.$outer.org$apache$celeborn$common$metrics$source$AbstractSource$$clearOldValues(map);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.celeborn.common.metrics.source.AbstractSource$$anon$1 ), $anonfun$run$2(scala.Tuple2 ), $anonfun$run$3$adapted(org.apache.celeborn.common.metrics.source.AbstractSource$$anon$1 java.util.concurrent.ConcurrentHashMap )}, serializedLambda);
            }
        };
        this.metricsCleaner().scheduleWithFixedDelay(cleanTask, 10L, 10L, TimeUnit.MINUTES);
    }

    private void updateInnerMetrics(String str) {
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.innerMetrics();
        synchronized (concurrentLinkedQueue) {
            Object object = this.innerMetrics().size() >= this.metricsCapacity() ? this.innerMetrics().remove() : BoxedUnit.UNIT;
            this.innerMetrics().offer(str);
        }
    }

    public void recordCounter(NamedCounter nc) {
        long timestamp = System.currentTimeMillis();
        this.updateInnerMetrics(new java.lang.StringBuilder(8).append(this.normalizeKey(nc.name())).append("Count").append(this.label()).append(" ").append(nc.counter().getCount()).append(" ").append(timestamp).append("\n").toString());
    }

    public void recordGauge(NamedGauge<?> ng) {
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append(new java.lang.StringBuilder(8).append(this.normalizeKey(ng.name())).append("Value").append(this.label()).append(" ").append(ng.gauge().getValue()).append(" ").append(timestamp).append("\n").toString());
        this.updateInnerMetrics(sb.toString());
    }

    public void recordHistogram(NamedHistogram nh) {
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Snapshot snapshot = nh.histogram().getSnapshot();
        String prefix = this.normalizeKey(nh.name());
        sb.append(new java.lang.StringBuilder(8).append(prefix).append("Count").append(this.label()).append(" ").append(nh.histogram().getCount()).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Max").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMax())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(7).append(prefix).append("Mean").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMean())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Min").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMin())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("50thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMedian())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("75thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get75thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("95thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get95thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("98thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get98thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("99thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get99thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(18).append(prefix).append("999thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get999thPercentile())).append(" ").append(timestamp).append("\n").toString());
        this.updateInnerMetrics(sb.toString());
    }

    public void recordTimer(NamedTimer nt) {
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Snapshot snapshot = nt.timer().getSnapshot();
        String prefix = this.normalizeKey(nt.name());
        sb.append(new java.lang.StringBuilder(8).append(prefix).append("Count").append(this.label()).append(" ").append(nt.timer().getCount()).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Max").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMax())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(7).append(prefix).append("Mean").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMean())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Min").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMin())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("50thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.getMedian())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("75thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get75thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("95thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get95thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("98thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get98thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("99thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get99thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(18).append(prefix).append("999thPercentile").append(this.label()).append(" ").append(this.reportNanosAsMills(snapshot.get999thPercentile())).append(" ").append(timestamp).append("\n").toString());
        this.updateInnerMetrics(sb.toString());
    }

    @Override
    public String getMetrics() {
        this.counters().foreach((Function1 & Serializable & scala.Serializable)c -> {
            this.recordCounter(c);
            return BoxedUnit.UNIT;
        });
        this.gauges().foreach((Function1 & Serializable & scala.Serializable)g -> {
            this.recordGauge(g);
            return BoxedUnit.UNIT;
        });
        this.histograms().foreach((Function1 & Serializable & scala.Serializable)h -> {
            AbstractSource.$anonfun$getMetrics$3(this, h);
            return BoxedUnit.UNIT;
        });
        this.timers().foreach((Function1 & Serializable & scala.Serializable)t -> {
            AbstractSource.$anonfun$getMetrics$4(this, t);
            return BoxedUnit.UNIT;
        });
        StringBuilder sb = new StringBuilder();
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.innerMetrics();
        synchronized (concurrentLinkedQueue) {
            while (!this.innerMetrics().isEmpty()) {
                sb.append(this.innerMetrics().poll());
            }
            this.innerMetrics().clear();
        }
        return sb.toString();
    }

    public String normalizeKey(String key) {
        return new java.lang.StringBuilder(9).append("metrics_").append(key.replaceAll("[^a-zA-Z0-9]", "_")).append("_").toString();
    }

    public double reportNanosAsMills(double value) {
        return package$.MODULE$.BigDecimal().apply(value / (double)1000000).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
    }

    public String label() {
        return this.label;
    }

    public static final /* synthetic */ void $anonfun$getMetrics$3(AbstractSource $this, NamedHistogram h) {
        $this.recordHistogram(h);
        ((ResettableSlidingWindowReservoir)((RssHistogram)((Object)h)).reservoir()).reset();
    }

    public static final /* synthetic */ void $anonfun$getMetrics$4(AbstractSource $this, NamedTimer t) {
        $this.recordTimer(t);
        ((ResettableSlidingWindowReservoir)((RssTimer)t.timer()).reservoir()).reset();
    }

    public AbstractSource(CelebornConf conf, String role) {
        Logging.$init$(this);
        this.metricRegistry = new MetricRegistry();
        this.metricsSlidingWindowSize = conf.metricsSlidingWindowSize();
        this.metricsSampleRate = conf.metricsSampleRate();
        this.metricsCollectCriticalEnabled = conf.metricsCollectCriticalEnabled();
        this.metricsCapacity = conf.metricsCapacity();
        this.innerMetrics = new ConcurrentLinkedQueue();
        this.timerSupplier = new TimerSupplier(this.metricsSlidingWindowSize());
        this.metricsCleaner = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("worker-metrics-cleaner");
        this.namedGauges = new ArrayList();
        this.namedTimers = new ConcurrentHashMap();
        this.namedCounters = new ConcurrentHashMap();
        this.label = new java.lang.StringBuilder(9).append("{role=\"").append(role).append("\"}").toString();
    }
}

