/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.util.Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileInfo {
    private final String filePath;
    private final List<Long> chunkOffsets;
    private final UserIdentifier userIdentifier;
    private final PartitionType partitionType;

    public FileInfo(String filePath, List<Long> chunkOffsets, UserIdentifier userIdentifier) {
        this(filePath, chunkOffsets, userIdentifier, PartitionType.REDUCE);
    }

    public FileInfo(String filePath, List<Long> chunkOffsets, UserIdentifier userIdentifier, PartitionType partitionType) {
        this.filePath = filePath;
        this.chunkOffsets = chunkOffsets;
        this.userIdentifier = userIdentifier;
        this.partitionType = partitionType;
    }

    public FileInfo(String filePath, UserIdentifier userIdentifier, PartitionType partitionType) {
        this(filePath, new ArrayList<Long>(Arrays.asList(0L)), userIdentifier, partitionType);
    }

    @VisibleForTesting
    public FileInfo(File file, UserIdentifier userIdentifier) {
        this(file.getAbsolutePath(), new ArrayList<Long>(Arrays.asList(0L)), userIdentifier, PartitionType.REDUCE);
    }

    public synchronized void addChunkOffset(long bytesFlushed) {
        this.chunkOffsets.add(bytesFlushed);
    }

    public synchronized int numChunks() {
        if (!this.chunkOffsets.isEmpty()) {
            return this.chunkOffsets.size() - 1;
        }
        return 0;
    }

    public synchronized long getLastChunkOffset() {
        return this.chunkOffsets.get(this.chunkOffsets.size() - 1);
    }

    public synchronized long getFileLength() {
        return this.chunkOffsets.get(this.chunkOffsets.size() - 1);
    }

    public File getFile() {
        return new File(this.filePath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getSortedPath() {
        return Utils.getSortedFilePath(this.filePath);
    }

    public String getIndexPath() {
        return Utils.getIndexFilePath(this.filePath);
    }

    public Path getHdfsPath() {
        return new Path(this.filePath);
    }

    public Path getHdfsIndexPath() {
        return new Path(Utils.getIndexFilePath(this.filePath));
    }

    public Path getHdfsSortedPath() {
        return new Path(Utils.getSortedFilePath(this.filePath));
    }

    public Path getHdfsWriterSuccessPath() {
        return new Path(Utils.getWriteSuccessFilePath(this.filePath));
    }

    public Path getHdfsPeerWriterSuccessPath() {
        return new Path(Utils.getWriteSuccessFilePath(Utils.getPeerPath(this.filePath)));
    }

    public UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public void deleteAllFiles(FileSystem hdfsFs) throws IOException {
        if (this.isHdfs()) {
            hdfsFs.delete(this.getHdfsPath(), false);
            hdfsFs.delete(this.getHdfsWriterSuccessPath(), false);
            hdfsFs.delete(this.getHdfsIndexPath(), false);
            hdfsFs.delete(this.getHdfsSortedPath(), false);
        } else {
            this.getFile().delete();
            new File(this.getIndexPath()).delete();
            new File(this.getSortedPath()).delete();
        }
    }

    public boolean isHdfs() {
        return Utils.isHdfsPath(this.filePath);
    }

    public synchronized List<Long> getChunkOffsets() {
        return this.chunkOffsets;
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    public String toString() {
        return "FileInfo{file=" + this.filePath + ", chunkOffsets=" + StringUtils.join(this.chunkOffsets, (String)",") + ", userIdentifier=" + this.userIdentifier.toString() + ", partitionType=" + (Object)((Object)this.partitionType) + '}';
    }
}

