/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.source.RPCSource;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointAddress$;
import org.apache.celeborn.common.rpc.RpcEndpointNotFoundException;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv$;
import org.apache.celeborn.common.rpc.netty.NettyRpcHandler;
import org.apache.celeborn.common.rpc.netty.OneWayOutboxMessage;
import org.apache.celeborn.common.rpc.netty.Outbox;
import org.apache.celeborn.common.rpc.netty.OutboxMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcFailure;
import org.apache.celeborn.common.rpc.netty.RpcOutboxMessage;
import org.apache.celeborn.common.serializer.JavaSerializerInstance;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rEc\u0001B\u001e=\u0001%C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t5\u0002\u0011\t\u0011)A\u0005-\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011!\u0001\bA!A!\u0002\u0013\t\b\"B;\u0001\t\u00031\b\u0002C?\u0001\u0005\u0004%\tA\u0011@\t\u000f\u0005=\u0001\u0001)A\u0005\u007f\"I\u0011\u0011\u0003\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0016!I\u0011Q\u0004\u0001A\u0002\u0013%\u0011q\u0004\u0005\n\u0003O\u0001\u0001\u0019!C\u0005\u0003SA\u0001\"!\u000e\u0001A\u0003&\u0011\u0011\u0005\u0005\n\u0003o\u0001\u0001\u0019!C\u0001\u0003sA\u0011\"a\u0014\u0001\u0001\u0004%\t!!\u0015\t\u0011\u0005U\u0003\u0001)Q\u0005\u0003wA\u0011\"a\u0016\u0001\u0005\u0004%I!!\u0017\t\u0011\u0005\r\u0004\u0001)A\u0005\u00037B\u0011\"!\u001a\u0001\u0005\u0004%\t!a\u001a\t\u0011\u0005U\u0004\u0001)A\u0005\u0003SB\u0011\"a\u001e\u0001\u0005\u0004%I!!\u001f\t\u0011\u00055\u0005\u0001)A\u0005\u0003wB!\"a$\u0001\u0005\u0004%\tAQAI\u0011!\tI\n\u0001Q\u0001\n\u0005M\u0005bCAN\u0001\u0001\u0007\t\u0019!C\u0005\u0003;C1\"!+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\"Y\u0011q\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BAP\u0011%\tI\f\u0001b\u0001\n\u0013\tY\f\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BA_\u0011%\tY\r\u0001b\u0001\n\u0013\ti\r\u0003\u0005\u0002b\u0002\u0001\u000b\u0011BAh\u0011!\t\u0019\u000f\u0001C\u0001\u0005\u0006\u0015\bbBAv\u0001\u0011\u0005\u0011Q\u001e\u0005\u000b\u0003S\u0004\u0001R1A\u0005B\u0005]\bb\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0005\n\u0005C\u0001\u0011\u0013!C\u0001\u0005GAqAa\u000e\u0001\t\u0003\u0011I\u0004C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\tM\u0003\u0001\"\u0011\u0003V!9!1\f\u0001\u0005\n\tu\u0003\u0002\u0003B:\u0001\u0011\u0005!I!\u001e\t\u0011\t}\u0004\u0001\"\u0001C\u0005\u0003C\u0001Ba#\u0001\t\u0003\u0011%Q\u0012\u0005\t\u0005\u000f\u0004A\u0011\u0001\"\u0003J\"A!1\u001c\u0001\u0005\u0002\t\u0013i\u000e\u0003\u0005\u0003v\u0002!\tA\u0011B|\u0011\u001d\u0011I\u0006\u0001C!\u0007\u001bAqa!\u0005\u0001\t\u0003\u001a\u0019\u0002C\u0004\u0004\u0016\u0001!\tea\u0005\t\u000f\r]\u0001\u0001\"\u0003\u0004\u0014!9!Q\u001f\u0001\u0005B\req\u0001CB\u0016y!\u0005!i!\f\u0007\u000fmb\u0004\u0012\u0001\"\u00040!1Q/\u000eC\u0001\u0007oA!b!\u000f6\u0005\u0004%\tAQB\u001e\u0011!\u00199%\u000eQ\u0001\n\ru\u0002BCB%k\t\u0007I\u0011\u0001\"\u0004L!A1qJ\u001b!\u0002\u0013\u0019iEA\u0006OKR$\u0018P\u00159d\u000b:4(BA\u001f?\u0003\u0015qW\r\u001e;z\u0015\ty\u0004)A\u0002sa\u000eT!!\u0011\"\u0002\r\r|W.\\8o\u0015\t\u0019E)\u0001\u0005dK2,'m\u001c:o\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\u0004\u0001M\u0019\u0001A\u0013(\u0011\u0005-cU\"\u0001 \n\u00055s$A\u0002*qG\u0016sg\u000f\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0001\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002T!\n9Aj\\4hS:<\u0017\u0001B2p]\u001a,\u0012A\u0016\t\u0003/bk\u0011\u0001Q\u0005\u00033\u0002\u0013AbQ3mK\n|'O\\\"p]\u001a\fQaY8oM\u0002\naC[1wCN+'/[1mSj,'/\u00138ti\u0006t7-\u001a\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0002\u000b!b]3sS\u0006d\u0017N_3s\u0013\t\tgL\u0001\fKCZ\f7+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0003\u0011Awn\u001d;\u0011\u0005\u0011lgBA3l!\t1\u0017.D\u0001h\u0015\tA\u0007*\u0001\u0004=e>|GO\u0010\u0006\u0002U\u0006)1oY1mC&\u0011A.[\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002mS\u0006qa.^7Vg\u0006\u0014G.Z\"pe\u0016\u001c\bC\u0001:t\u001b\u0005I\u0017B\u0001;j\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b]L(p\u001f?\u0011\u0005a\u0004Q\"\u0001\u001f\t\u000bQ3\u0001\u0019\u0001,\t\u000bm3\u0001\u0019\u0001/\t\u000b\t4\u0001\u0019A2\t\u000bA4\u0001\u0019A9\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005kRLGNC\u0002\u0002\n\u0001\u000bqA\\3uo>\u00148.\u0003\u0003\u0002\u000e\u0005\r!!\u0004+sC:\u001c\bo\u001c:u\u0007>tg-\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\u0002\u0015\u0011L7\u000f]1uG\",'/\u0006\u0002\u0002\u0016A\u0019\u00010a\u0006\n\u0007\u0005eAH\u0001\u0006ESN\u0004\u0018\r^2iKJ\f1\u0002Z5ta\u0006$8\r[3sA\u00051qo\u001c:lKJ,\"!!\t\u0011\u0007-\u000b\u0019#C\u0002\u0002&y\u00121B\u00159d\u000b:$\u0007o\\5oi\u0006Qqo\u001c:lKJ|F%Z9\u0015\t\u0005-\u0012\u0011\u0007\t\u0004e\u00065\u0012bAA\u0018S\n!QK\\5u\u0011%\t\u0019\u0004DA\u0001\u0002\u0004\t\t#A\u0002yIE\nqa^8sW\u0016\u0014\b%\u0001\u0004t_V\u00148-Z\u000b\u0003\u0003w\u0001RA]A\u001f\u0003\u0003J1!a\u0010j\u0005\u0019y\u0005\u000f^5p]B!\u00111IA&\u001b\t\t)E\u0003\u0003\u00028\u0005\u001d#bAA%\u0001\u00069Q.\u001a;sS\u000e\u001c\u0018\u0002BA'\u0003\u000b\u0012\u0011B\u0015)D'>,(oY3\u0002\u0015M|WO]2f?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005M\u0003\"CA\u001a\u001f\u0005\u0005\t\u0019AA\u001e\u0003\u001d\u0019x.\u001e:dK\u0002\n\u0001\u0003\u001e:b]N\u0004xN\u001d;D_:$X\r\u001f;\u0016\u0005\u0005m\u0003\u0003BA/\u0003?j!!a\u0002\n\t\u0005\u0005\u0014q\u0001\u0002\u0011)J\fgn\u001d9peR\u001cuN\u001c;fqR\f\u0011\u0003\u001e:b]N\u0004xN\u001d;D_:$X\r\u001f;!\u00035\u0019G.[3oi\u001a\u000b7\r^8ssV\u0011\u0011\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)!\u0011qNA\u0004\u0003\u0019\u0019G.[3oi&!\u00111OA7\u0005Y!&/\u00198ta>\u0014Ho\u00117jK:$h)Y2u_JL\u0018AD2mS\u0016tGOR1di>\u0014\u0018\u0010I\u0001\u0011i&lWm\\;u'\u000eDW\rZ;mKJ,\"!a\u001f\u0011\t\u0005u\u0014\u0011R\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u0015\u0011Q\u0011\u0006\u0003\u0003\u000f\u000bAA[1wC&!\u00111RA@\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0012i&lWm\\;u'\u000eDW\rZ;mKJ\u0004\u0013\u0001G2mS\u0016tGoQ8o]\u0016\u001cG/[8o\u000bb,7-\u001e;peV\u0011\u00111\u0013\t\u0005\u0003{\n)*\u0003\u0003\u0002\u0018\u0006}$A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\f\u0011d\u00197jK:$8i\u001c8oK\u000e$\u0018n\u001c8Fq\u0016\u001cW\u000f^8sA\u000511/\u001a:wKJ,\"!a(\u0011\t\u0005\u0005\u0016QU\u0007\u0003\u0003GSA!a'\u0002\b%!\u0011qUAR\u0005=!&/\u00198ta>\u0014HoU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR!\u00111FAW\u0011%\t\u0019DGA\u0001\u0002\u0004\ty*A\u0004tKJ4XM\u001d\u0011)\u0007m\t\u0019\fE\u0002s\u0003kK1!a.j\u0005!1x\u000e\\1uS2,\u0017aB:u_B\u0004X\rZ\u000b\u0003\u0003{\u0003B!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\fy(\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003\u000f\f\tMA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\tgR|\u0007\u000f]3eA\u0005Aq.\u001e;c_b,7/\u0006\u0002\u0002PBA\u0011QPAi\u0003+\fY.\u0003\u0003\u0002T\u0006}$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u00191*a6\n\u0007\u0005egH\u0001\u0006Sa\u000e\fE\r\u001a:fgN\u00042\u0001_Ao\u0013\r\ty\u000e\u0010\u0002\u0007\u001fV$(m\u001c=\u0002\u0013=,HOY8yKN\u0004\u0013\u0001\u0004:f[>4XmT;uE>DH\u0003BA\u0016\u0003ODq!!;!\u0001\u0004\t).A\u0004bI\u0012\u0014Xm]:\u0002\u0017M$\u0018M\u001d;TKJ4XM\u001d\u000b\u0007\u0003W\ty/a=\t\r\u0005E\u0018\u00051\u0001d\u0003-\u0011\u0017N\u001c3BI\u0012\u0014Xm]:\t\r\u0005U\u0018\u00051\u0001r\u0003\u0011\u0001xN\u001d;\u0016\u0005\u0005U\u0007f\u0001\u0012\u0002|B!\u0011Q B\u0004\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011AC1o]>$\u0018\r^5p]*\u0011!QA\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0005\u0013\tyP\u0001\u0005Ok2d\u0017M\u00197f\u00035\u0019X\r^;q\u000b:$\u0007o\\5oiRA!q\u0002B\u000b\u00053\u0011i\u0002E\u0002L\u0005#I1Aa\u0005?\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001aDaAa\u0006$\u0001\u0004\u0019\u0017\u0001\u00028b[\u0016DqAa\u0007$\u0001\u0004\t\t#\u0001\u0005f]\u0012\u0004x.\u001b8u\u0011%\u0011yb\tI\u0001\u0002\u0004\tY$\u0001\bbEN$(/Y2u'>,(oY3\u0002/M,G/\u001e9F]\u0012\u0004x.\u001b8uI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0013U\u0011\tYDa\n,\u0005\t%\u0002\u0003\u0002B\u0016\u0005gi!A!\f\u000b\t\t=\"\u0011G\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0001j\u0013\u0011\u0011)D!\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bdQ\u0016\u001c7NU3hSN$XM]3e)\t\u0011Y\u0004E\u0002s\u0005{I1Aa\u0010j\u0005\u001d\u0011un\u001c7fC:\f!$Y:z]\u000e\u001cV\r^;q\u000b:$\u0007o\\5oiJ+gMQ=V%&#BA!\u0012\u0003PA1!q\tB&\u0005\u001fi!A!\u0013\u000b\u0007\u0005\u0005\u0015.\u0003\u0003\u0003N\t%#A\u0002$viV\u0014X\r\u0003\u0004\u0003R\u0019\u0002\raY\u0001\u0004kJL\u0017\u0001B:u_B$B!a\u000b\u0003X!9!\u0011L\u0014A\u0002\t=\u0011aC3oIB|\u0017N\u001c;SK\u001a\fA\u0002]8tiR{w*\u001e;c_b$b!a\u000b\u0003`\t%\u0004b\u0002B1Q\u0001\u0007!1M\u0001\te\u0016\u001cW-\u001b<feB\u0019\u0001P!\u001a\n\u0007\t\u001dDHA\nOKR$\u0018P\u00159d\u000b:$\u0007o\\5oiJ+g\rC\u0004\u0003l!\u0002\rA!\u001c\u0002\u000f5,7o]1hKB\u0019\u0001Pa\u001c\n\u0007\tEDHA\u0007PkR\u0014w\u000e_'fgN\fw-Z\u0001\u0005g\u0016tG\r\u0006\u0003\u0002,\t]\u0004b\u0002B6S\u0001\u0007!\u0011\u0010\t\u0004q\nm\u0014b\u0001B?y\tq!+Z9vKN$X*Z:tC\u001e,\u0017\u0001D2sK\u0006$Xm\u00117jK:$H\u0003\u0002BB\u0005\u0013\u0003B!a\u001b\u0003\u0006&!!qQA7\u0005=!&/\u00198ta>\u0014Ho\u00117jK:$\bbBAuU\u0001\u0007\u0011Q[\u0001\u0004CN\\W\u0003\u0002BH\u00053#bA!%\u0003<\nuF\u0003\u0002BJ\u0005W\u0003bAa\u0012\u0003L\tU\u0005\u0003\u0002BL\u00053c\u0001\u0001B\u0004\u0003\u001c.\u0012\rA!(\u0003\u0003Q\u000bBAa(\u0003&B\u0019!O!)\n\u0007\t\r\u0016NA\u0004O_RD\u0017N\\4\u0011\u0007I\u00149+C\u0002\u0003*&\u00141!\u00118z\u0011%\u0011ikKA\u0001\u0002\b\u0011y+\u0001\u0006fm&$WM\\2fIE\u0002bA!-\u00038\nUUB\u0001BZ\u0015\r\u0011),[\u0001\be\u00164G.Z2u\u0013\u0011\u0011ILa-\u0003\u0011\rc\u0017m]:UC\u001eDqAa\u001b,\u0001\u0004\u0011I\bC\u0004\u0003@.\u0002\rA!1\u0002\u000fQLW.Z8viB\u00191Ja1\n\u0007\t\u0015gH\u0001\u0006Sa\u000e$\u0016.\\3pkR\f\u0011b]3sS\u0006d\u0017N_3\u0015\t\t-'q\u001b\t\u0005\u0005\u001b\u0014\u0019.\u0004\u0002\u0003P*!!\u0011[AC\u0003\rq\u0017n\\\u0005\u0005\u0005+\u0014yM\u0001\u0006CsR,')\u001e4gKJDqA!7-\u0001\u0004\u0011)+A\u0004d_:$XM\u001c;\u0002\u001fM,'/[1mSj,7\u000b\u001e:fC6$BAa8\u0003fB\u0019QL!9\n\u0007\t\rhLA\nTKJL\u0017\r\\5{CRLwN\\*ue\u0016\fW\u000eC\u0004\u0003h6\u0002\rA!;\u0002\u0007=,H\u000f\u0005\u0003\u0003l\nEXB\u0001Bw\u0015\u0011\u0011y/!\"\u0002\u0005%|\u0017\u0002\u0002Bz\u0005[\u0014AbT;uaV$8\u000b\u001e:fC6\f1\u0002Z3tKJL\u0017\r\\5{KV!!\u0011 B\u0000)\u0019\u0011Ypa\u0002\u0004\nQ!!Q`B\u0001!\u0011\u00119Ja@\u0005\u000f\tmeF1\u0001\u0003\u001e\"I11\u0001\u0018\u0002\u0002\u0003\u000f1QA\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004C\u0002BY\u0005o\u0013i\u0010C\u0004\u0002p9\u0002\rAa!\t\u000f\r-a\u00061\u0001\u0003L\u0006)!-\u001f;fgR!!qBB\b\u0011\u001d\u0011Yb\fa\u0001\u0003C\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003W\t\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\u0002\u000f\rdW-\u00198vaV!11DB\u0010)\u0011\u0019ib!\t\u0011\t\t]5q\u0004\u0003\b\u00057\u001b$\u0019\u0001BO\u0011\u001d\u0019\u0019c\ra\u0001\u0007K\tQ\u0003Z3tKJL\u0017\r\\5{CRLwN\\!di&|g\u000eE\u0003s\u0007O\u0019i\"C\u0002\u0004*%\u0014\u0011BR;oGRLwN\u001c\u0019\u0002\u00179+G\u000f^=Sa\u000e,eN\u001e\t\u0003qV\u001aB!NB\u0019\u001dB\u0019!oa\r\n\u0007\rU\u0012N\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007[\t!bY;se\u0016tG/\u00128w+\t\u0019i\u0004E\u0003\u0004@\r\rs/\u0004\u0002\u0004B)\u0019\u0011QA5\n\t\r\u00153\u0011\t\u0002\u0010\tft\u0017-\\5d-\u0006\u0014\u0018.\u00192mK\u0006Y1-\u001e:sK:$XI\u001c<!\u00035\u0019WO\u001d:f]R\u001cE.[3oiV\u00111Q\n\t\u0007\u0007\u007f\u0019\u0019Ea!\u0002\u001d\r,(O]3oi\u000ec\u0017.\u001a8uA\u0001")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    @Nullable
    private RpcAddress address;
    private final CelebornConf conf;
    private final JavaSerializerInstance javaSerializerInstance;
    private String host;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private RpcEndpoint worker;
    private Option<RPCSource> source;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private RpcEndpoint worker() {
        return this.worker;
    }

    private void worker_$eq(RpcEndpoint x$1) {
        this.worker = x$1;
    }

    public Option<RPCSource> source() {
        return this.source;
    }

    public void source_$eq(Option<RPCSource> x$1) {
        this.source = x$1;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    public TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        block0: {
            Outbox outbox = this.outboxes().remove(address);
            if (outbox == null) break block0;
            outbox.stop();
        }
    }

    public void startServer(String bindAddress, int port) {
        this.server_$eq(this.transportContext().createServer(bindAddress, port));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() != null ? new RpcAddress(this.host, this.server().getPort()) : null;
                this.bitmap$0 = true;
            }
        }
        this.host = null;
        return this.address;
    }

    @Override
    public RpcAddress address() {
        return !this.bitmap$0 ? this.address$lzycompute() : this.address;
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint, Option<RPCSource> abstractSource) {
        String string = name;
        String string2 = RpcNameConstants.WORKER_EP;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.worker_$eq(endpoint);
        }
        this.source_$eq(abstractSource);
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Option<RPCSource> setupEndpoint$default$3() {
        return None$.MODULE$;
    }

    public boolean checkRegistered() {
        return this.worker() == null ? true : this.worker().checkRegistered();
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1 & Serializable & scala.Serializable)find -> NettyRpcEnv.$anonfun$asyncSetupEndpointRefByURI$1(endpointRef, uri, BoxesRunTime.unboxToBoolean((Object)find)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() != null && receiver.client().isActive()) {
            message.sendWith(receiver.client());
        } else {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0 & Serializable & scala.Serializable)() -> "Cannot send message to client endpoint with no listen address.");
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        }
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
            }
            catch (RpcEnvStoppedException e) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    NettyRpcEnv.$anonfun$ask$4(this, promise, x0$1);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                    this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
                    return BoxedUnit.UNIT;
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(client, response) -> {
                    this.onSuccess$1(this.deserialize(client, response, ClassTag$.MODULE$.Any()), promise);
                    return BoxedUnit.UNIT;
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    NettyRpcEnv.$anonfun$ask$7(rpcMessage, x0$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, remoteAddr, timeout, promise){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcAddress remoteAddr$1;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;

                public void run() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder(34).append("Cannot receive any reply from ").append(this.remoteAddr$1).append(" ").append("in ").append(this.timeout$1.duration()).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.remoteAddr$1 = remoteAddr$1;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)timeoutCancelable.cancel(true)), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e2, promise);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0 & Serializable & scala.Serializable)() -> this.deserialize((Function0 & Serializable & scala.Serializable)() -> $this.javaSerializerInstance.deserialize(bytes, evidence$2)));
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        block5: {
            if (!this.stopped().compareAndSet(false, true)) {
                return;
            }
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() != null ? this.timeoutScheduler().shutdownNow() : BoxedUnit.UNIT;
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            if (this.clientConnectionExecutor() == null) break block5;
            this.clientConnectionExecutor().shutdownNow();
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    public static final /* synthetic */ Future $anonfun$asyncSetupEndpointRefByURI$1(NettyRpcEndpointRef endpointRef$1, String uri$1, boolean find) {
        return find ? Future$.MODULE$.successful((Object)endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(uri$1));
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        block2: {
            if (promise$1.tryFailure(e)) break block2;
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(rpcEnvStoppedException).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(e).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private final void onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (!promise$1.trySuccess(object)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored message: ").append(reply).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$ask$4(NettyRpcEnv $this, Promise promise$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object response = success.value();
            $this.onSuccess$1(response, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$ask$7(RpcOutboxMessage rpcMessage$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof TimeoutException) {
            rpcMessage$1.onTimeout();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public NettyRpcEnv(CelebornConf conf, JavaSerializerInstance javaSerializerInstance, String host, int numUsableCores) {
        this.conf = conf;
        this.javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        super(conf);
        Logging.$init$(this);
        this.transportConf = Utils$.MODULE$.fromCelebornConf(conf.clone(), "rpc", conf.getInt("celeborn.rpc.io.threads", numUsableCores));
        this.dispatcher = new Dispatcher(this, numUsableCores);
        this.worker = null;
        this.source = None$.MODULE$;
        this.transportContext = new TransportContext(this.transportConf(), new NettyRpcHandler(this.dispatcher(), this));
        this.clientFactory = this.transportContext().createClientFactory();
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.rpcConnectThreads(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }
}

