/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.MetricsConfig;
import org.apache.celeborn.common.metrics.MetricsSystem$;
import org.apache.celeborn.common.metrics.sink.PrometheusHttpRequestHandler;
import org.apache.celeborn.common.metrics.sink.PrometheusServlet;
import org.apache.celeborn.common.metrics.sink.Sink;
import org.apache.celeborn.common.metrics.source.Source;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001\u0002\u00180\u0001iB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t)\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005[\u0001\t\u0015\r\u0011\"\u0001I\u0011!Y\u0006A!A!\u0002\u0013I\u0005\"\u0002/\u0001\t\u0003i\u0006BB2\u0001A\u0003%A\rC\u0004h\u0001\t\u0007I\u0011\u00025\t\r]\u0004\u0001\u0015!\u0003j\u0011\u001dA\bA1A\u0005\neDq!a\u0001\u0001A\u0003%!\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u00111\u0004\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0003\u0002 !I\u0011Q\u0006\u0001A\u0002\u0013%\u0011q\u0006\u0005\t\u0003w\u0001\u0001\u0015)\u0003\u0002\"!I\u0011Q\b\u0001A\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u000f\u0002\u0001\u0019!C\u0001\u0003\u0013B\u0001\"!\u0014\u0001A\u0003&\u0011\u0011\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\tI\u0006\u0001C\u0001\u00037B\u0011\"!\u0019\u0001#\u0003%\t!a\u0019\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011Q\u0010\u0001\u0005\u0002\u0005m\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!!*\u0001\t\u0003\t9\u000bC\u0004\u0002,\u0002!I!a\u001f\t\u000f\u00055\u0006\u0001\"\u0003\u0002|\u001d9\u0011qV\u0018\t\u0002\u0005EfA\u0002\u00180\u0011\u0003\t\u0019\f\u0003\u0004]A\u0011\u0005\u0011Q\u0017\u0005\n\u0003o\u0003#\u0019!C\u0001\u0003sC\u0001\"a3!A\u0003%\u00111\u0018\u0005\n\u0003\u001b\u0004#\u0019!C\u0001\u0003sC\u0001\"a4!A\u0003%\u00111\u0018\u0005\n\u0003#\u0004#\u0019!C\u0001\u0003'D\u0001\"a9!A\u0003%\u0011Q\u001b\u0005\n\u0003K\u0004#\u0019!C\u0001\u0003'D\u0001\"a:!A\u0003%\u0011Q\u001b\u0005\t\u0003S\u0004\u0003\u0015!\u0003\u0002l\"A\u0011\u0011 \u0011!\u0002\u0013\tY\u0010C\u0004\u0003\u0002\u0001\"\tAa\u0001\t\u000f\t5\u0001\u0005\"\u0001\u0003\u0010\tiQ*\u001a;sS\u000e\u001c8+_:uK6T!\u0001M\u0019\u0002\u000f5,GO]5dg*\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005Q*\u0014\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'\r\u00011(\u0011\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t+U\"A\"\u000b\u0005\u0011\u000b\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0019\u001b%a\u0002'pO\u001eLgnZ\u0001\tS:\u001cH/\u00198dKV\t\u0011\n\u0005\u0002K#:\u00111j\u0014\t\u0003\u0019vj\u0011!\u0014\u0006\u0003\u001df\na\u0001\u0010:p_Rt\u0014B\u0001)>\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ak\u0014!C5ogR\fgnY3!\u0003\u0011\u0019wN\u001c4\u0011\u0005]CV\"A\u0019\n\u0005e\u000b$\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017aC:feZdW\r\u001e)bi\"\fAb]3sm2,G\u000fU1uQ\u0002\na\u0001P5oSRtD\u0003\u00020aC\n\u0004\"a\u0018\u0001\u000e\u0003=BQa\u0012\u0004A\u0002%CQ!\u0016\u0004A\u0002YCQA\u0017\u0004A\u0002%\u000bQ\"\\3ue&\u001c7oQ8oM&<\u0007CA0f\u0013\t1wFA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u0006g&t7n]\u000b\u0002SB\u0019!n\\9\u000e\u0003-T!\u0001\\7\u0002\u000f5,H/\u00192mK*\u0011a.P\u0001\u000bG>dG.Z2uS>t\u0017B\u00019l\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005I,X\"A:\u000b\u0005Q|\u0013\u0001B:j].L!A^:\u0003\tMKgn[\u0001\u0007g&t7n\u001d\u0011\u0002\u000fM|WO]2fgV\t!\u0010E\u0002k_n\u0004\"\u0001`@\u000e\u0003uT!A`\u0018\u0002\rM|WO]2f\u0013\r\t\t! \u0002\u0007'>,(oY3\u0002\u0011M|WO]2fg\u0002\n\u0001B]3hSN$(/_\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00185\u0011\u0011Q\u0002\u0006\u0004a\u0005=!\u0002BA\t\u0003'\t\u0001bY8eC\"\fG.\u001a\u0006\u0003\u0003+\t1aY8n\u0013\u0011\tI\"!\u0004\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss\u0006I!/Z4jgR\u0014\u0018\u0010I\u0001\u0012aJ|W.\u001a;iKV\u001c8+\u001a:wY\u0016$XCAA\u0011!\u0015a\u00141EA\u0014\u0013\r\t)#\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007I\fI#C\u0002\u0002,M\u0014\u0011\u0003\u0015:p[\u0016$\b.Z;t'\u0016\u0014h\u000f\\3u\u0003U\u0001(o\\7fi\",Wo]*feZdW\r^0%KF$B!!\r\u00028A\u0019A(a\r\n\u0007\u0005URH\u0001\u0003V]&$\b\"CA\u001d\u001f\u0005\u0005\t\u0019AA\u0011\u0003\rAH%M\u0001\u0013aJ|W.\u001a;iKV\u001c8+\u001a:wY\u0016$\b%A\u0004sk:t\u0017N\\4\u0016\u0005\u0005\u0005\u0003c\u0001\u001f\u0002D%\u0019\u0011QI\u001f\u0003\u000f\t{w\u000e\\3b]\u0006Y!/\u001e8oS:<w\fJ3r)\u0011\t\t$a\u0013\t\u0013\u0005e\"#!AA\u0002\u0005\u0005\u0013\u0001\u0003:v]:Lgn\u001a\u0011\u0002)\u001d,G\u000f\u0015:p[\u0016$\b.Z;t\u0011\u0006tG\r\\3s+\t\t\u0019\u0006E\u0002s\u0003+J1!a\u0016t\u0005q\u0001&o\\7fi\",Wo\u001d%uiB\u0014V-];fgRD\u0015M\u001c3mKJ\fQa\u001d;beR$B!!\r\u0002^!I\u0011qL\u000b\u0011\u0002\u0003\u0007\u0011\u0011I\u0001\u0016e\u0016<\u0017n\u001d;feN#\u0018\r^5d'>,(oY3t\u0003=\u0019H/\u0019:uI\u0011,g-Y;mi\u0012\nTCAA3U\u0011\t\t%a\u001a,\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001d>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\niGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAa\u001d;paR\u0011\u0011\u0011G\u0001\u0007e\u0016\u0004xN\u001d;\u0002#\t,\u0018\u000e\u001c3SK\u001eL7\u000f\u001e:z\u001d\u0006lW\rF\u0002J\u0003\u0007CQA`\rA\u0002m\f\u0001cZ3u'>,(oY3t\u0005ft\u0015-\\3\u0015\t\u0005%\u00151\u0014\t\u0006\u0003\u0017\u000b)j\u001f\b\u0005\u0003\u001b\u000b\tJD\u0002M\u0003\u001fK\u0011AP\u0005\u0004\u0003'k\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003/\u000bIJA\u0002TKFT1!a%>\u0011\u0019\tiJ\u0007a\u0001\u0013\u0006Q1o\\;sG\u0016t\u0015-\\3\u0002\u001dI,w-[:uKJ\u001cv.\u001e:dKR!\u0011\u0011GAR\u0011\u0015q8\u00041\u0001|\u00031\u0011X-\\8wKN{WO]2f)\u0011\t\t$!+\t\u000byd\u0002\u0019A>\u0002\u001fI,w-[:uKJ\u001cv.\u001e:dKN\fQB]3hSN$XM]*j].\u001c\u0018!D'fiJL7m]*zgR,W\u000e\u0005\u0002`AM\u0011\u0001e\u000f\u000b\u0003\u0003c\u000b!bU%O\u0017~\u0013ViR#Y+\t\tY\f\u0005\u0003\u0002>\u0006\u001dWBAA`\u0015\u0011\t\t-a1\u0002\u00115\fGo\u00195j]\u001eT1!!2>\u0003\u0011)H/\u001b7\n\t\u0005%\u0017q\u0018\u0002\u0006%\u0016<W\r_\u0001\f'&s5j\u0018*F\u000f\u0016C\u0006%\u0001\u0007T\u001fV\u00136)R0S\u000b\u001e+\u0005,A\u0007T\u001fV\u00136)R0S\u000b\u001e+\u0005\fI\u0001\f%>cUiX,P%.+%+\u0006\u0002\u0002VB!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017\u0001\u00027b]\u001eT!!a8\u0002\t)\fg/Y\u0005\u0004%\u0006e\u0017\u0001\u0004*P\u0019\u0016{vk\u0014*L\u000bJ\u0003\u0013a\u0003*P\u0019\u0016{V*Q*U\u000bJ\u000bABU(M\u000b~k\u0015i\u0015+F%\u0002\n\u0011#T%O\u00136\u000bEj\u0018)P\u00192{VKT%U!\u0011\ti/!>\u000e\u0005\u0005=(\u0002BAy\u0003g\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)-!8\n\t\u0005]\u0018q\u001e\u0002\t)&lW-\u00168ji\u0006\u0019R*\u0013(J\u001b\u0006cu\fU(M\u0019~\u0003VIU%P\tB\u0019A(!@\n\u0007\u0005}XHA\u0002J]R\f\u0011d\u00195fG.l\u0015N\\5nC2\u0004v\u000e\u001c7j]\u001e\u0004VM]5pIR1\u0011\u0011\u0007B\u0003\u0005\u0013AqAa\u0002-\u0001\u0004\tY/\u0001\u0005q_2dWK\\5u\u0011\u001d\u0011Y\u0001\fa\u0001\u0003w\f!\u0002]8mYB+'/[8e\u0003M\u0019'/Z1uK6+GO]5dgNK8\u000f^3n)\u001dq&\u0011\u0003B\n\u0005+AQaR\u0017A\u0002%CQ!V\u0017A\u0002YCQAW\u0017A\u0002%\u0003")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final CelebornConf conf;
    private final String servletPath;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry registry;
    private Option<PrometheusServlet> prometheusServlet;
    private boolean running;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static MetricsSystem createMetricsSystem(String string, CelebornConf celebornConf, String string2) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, celebornConf, string2);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static String ROLE_MASTER() {
        return MetricsSystem$.MODULE$.ROLE_MASTER();
    }

    public static String ROLE_WORKER() {
        return MetricsSystem$.MODULE$.ROLE_WORKER();
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        MetricsSystem metricsSystem = this;
        synchronized (metricsSystem) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public String instance() {
        return this.instance;
    }

    public String servletPath() {
        return this.servletPath;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public PrometheusHttpRequestHandler getPrometheusHandler() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (PrometheusHttpRequestHandler)this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandler($this.conf)).orNull(Predef$.MODULE$.$conforms());
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.stop();
                return BoxedUnit.UNIT;
            });
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.report();
            return BoxedUnit.UNIT;
        });
    }

    private String buildRegistryName(Source source) {
        return MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return (Seq)this.sources().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$5)));
    }

    public void registerSource(Source source) {
        this.sources().$plus$eq((Object)source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().$minus$eq((Object)source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching(new MetricFilter(null, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            BoxedUnit boxedUnit;
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                try {
                    Object object = kv._1();
                    String string = "prometheusServlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        Object servlet = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, ArrayBuffer.class, String.class).newInstance(kv._2(), this.registry(), this.sources(), this.servletPath());
                        this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)((PrometheusServlet)servlet)));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                    boxedUnit = this.sinks().$plus$eq((Object)((Sink)sink));
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$5) {
        String string = x$5.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Object source = Utils$.MODULE$.classForName(classPath).newInstance();
            $this.registerSource((Source)source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, CelebornConf conf, String servletPath) {
        this.instance = instance;
        this.conf = conf;
        this.servletPath = servletPath;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.registry = new MetricRegistry();
        this.prometheusServlet = None$.MODULE$;
        this.running = false;
        this.metricsConfig.initialize();
    }
}

