/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.Utils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.sql.execution.UnsafeRowSerializer;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkUtils {
    private static final Logger logger = LoggerFactory.getLogger(SparkUtils.class);

    public static MapStatus createMapStatus(BlockManagerId loc, long[] uncompressedSizes, long[] uncompressedRecords) throws IOException {
        MapStatus$ status = MapStatus$.MODULE$;
        Class<?> clz = status.getClass();
        Method applyMethod = null;
        for (Method method : clz.getDeclaredMethods()) {
            if (!"apply".equals(method.getName())) continue;
            applyMethod = method;
            break;
        }
        if (applyMethod == null) {
            throw new IOException("Could not find apply method in MapStatus object.");
        }
        try {
            switch (applyMethod.getParameterCount()) {
                case 2: {
                    return (MapStatus)applyMethod.invoke((Object)status, loc, uncompressedSizes);
                }
                case 3: {
                    return (MapStatus)applyMethod.invoke((Object)status, loc, uncompressedSizes, uncompressedRecords);
                }
            }
            throw new IllegalStateException("Could not find apply method with correct parameter number in MapStatus object.");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static SQLMetric getUnsafeRowSerializerDataSizeMetric(UnsafeRowSerializer serializer) {
        try {
            Field field = serializer.getClass().getDeclaredField("dataSize");
            field.setAccessible(true);
            return (SQLMetric)field.get(serializer);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warn("Failed to get dataSize metric, aqe won`t work properly.");
            return null;
        }
    }

    public static long[] unwrap(LongAdder[] adders) {
        int adderCounter = adders.length;
        long[] res = new long[adderCounter];
        for (int i = 0; i < adderCounter; ++i) {
            res[i] = adders[i].longValue();
        }
        return res;
    }

    public static CelebornConf fromSparkConf(SparkConf conf) {
        CelebornConf tmpCelebornConf = new CelebornConf();
        for (Tuple2 kv : conf.getAll()) {
            if (!((String)kv._1).startsWith("spark.celeborn.") && !((String)kv._1).startsWith("spark.rss.")) continue;
            tmpCelebornConf.set(((String)kv._1).substring("spark.".length()), (String)kv._2);
        }
        return tmpCelebornConf;
    }

    public static String genNewAppId(SparkContext context) {
        if (context.applicationAttemptId().isDefined()) {
            return context.applicationId() + "_" + (String)context.applicationAttemptId().get();
        }
        return context.applicationId();
    }

    public static <T> T instantiateClass(String className, SparkConf conf, Boolean isDriver) {
        Class<?> cls = Utils.classForName(className);
        try {
            return (T)cls.getConstructor(SparkConf.class, Boolean.TYPE).newInstance(conf, isDriver);
        }
        catch (ReflectiveOperationException roe1) {
            try {
                return (T)cls.getConstructor(SparkConf.class).newInstance(conf);
            }
            catch (ReflectiveOperationException roe2) {
                try {
                    return (T)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException roe3) {
                    throw new RuntimeException(roe3);
                }
            }
        }
    }
}

