/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DeviceInfo$;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.FileWriter;
import org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t%e\u0001\u0002\"D\u0001IC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0006\u0002\u0006\u0001\u0011\t\u0011)A\u0005\u0003\u000fAq!a\u0004\u0001\t\u0003\t\t\u0002C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001\u0002 !A\u0011Q\u0006\u0001!\u0002\u0013\t\tC\u0002\u0004\u00020\u0001\u0001\u0011\u0011\u0007\u0005\u000b\u0003gA!Q1A\u0005\u0002\u0005U\u0002\"CA\u001c\u0011\t\u0005\t\u0015!\u0003}\u0011\u001d\ty\u0001\u0003C\u0001\u0003sA\u0011\"!\u0002\t\u0005\u0004%\t!!\u0011\t\u0011\u0005=\u0003\u0002)A\u0005\u0003\u0007B\u0011\"!\u0015\t\u0005\u0004%\t!a\u0015\t\u0011\u0005m\u0003\u0002)A\u0005\u0003+B\u0011\"!\u0018\t\u0005\u0004%\t!a\u0018\t\u000f\u0005\u0005\u0004\u0002)A\u0005c\"I\u00111\r\u0005C\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003gB\u0001\u0015!\u0003\u0002h!I\u0011Q\u000f\u0005C\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003oB\u0001\u0015!\u0003\u0002h!I\u0011\u0011\u0010\u0005A\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u0007C\u0001\u0019!C\u0001\u0003\u000bC\u0001\"!%\tA\u0003&\u0011Q\u0010\u0005\n\u0003'C\u0001\u0019!C\u0001\u0003wB\u0011\"!&\t\u0001\u0004%\t!a&\t\u0011\u0005m\u0005\u0002)Q\u0005\u0003{B\u0011\"!(\t\u0001\u0004%\t!a\u001f\t\u0013\u0005}\u0005\u00021A\u0005\u0002\u0005\u0005\u0006\u0002CAS\u0011\u0001\u0006K!! \t\u0013\u0005\u001d\u0006\u00021A\u0005\u0002\u0005m\u0004\"CAU\u0011\u0001\u0007I\u0011AAV\u0011!\ty\u000b\u0003Q!\n\u0005u\u0004bBAY\u0011\u0011\u0005\u00111\u0017\u0005\b\u0003oCA\u0011AA]\u0011\u001d\ti\f\u0003C\u0001\u0003\u007fCq!!9\t\t\u0003\t\u0019\u000fC\u0004\u0002j\"!\t!a;\t\u000f\u0005E\b\u0002\"\u0001\u0002t\"9\u0011q\u001f\u0005\u0005\u0002\u0005e\bb\u0002B\u0001\u0011\u0011\u0005#1\u0001\u0005\f\u0005\u000b\u0001\u0001\u0019!a\u0001\n\u0003\u00119\u0001C\u0006\u0003\f\u0001\u0001\r\u00111A\u0005\u0002\t5\u0001b\u0003B\t\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0013A\u0011Ba\u0005\u0001\u0005\u0004%\t!a\u001f\t\u0011\tU\u0001\u0001)A\u0005\u0003{B\u0011Ba\u0006\u0001\u0005\u0004%\tA!\u0007\t\u0011\t\u0005\u0002\u0001)A\u0005\u00057A\u0011Ba\t\u0001\u0005\u0004%\tA!\n\t\u0011\t\u001d\u0002\u0001)A\u0005\u0003wD\u0011B!\u000b\u0001\u0005\u0004%\tA!\n\t\u0011\t-\u0002\u0001)A\u0005\u0003wD\u0011B!\f\u0001\u0005\u0004%\tA!\n\t\u0011\t=\u0002\u0001)A\u0005\u0003wD\u0011B!\r\u0001\u0005\u0004%IAa\r\t\u0011\tm\u0002\u0001)A\u0005\u0005kAqA!\u0010\u0001\t\u0003\u0011y\u0004C\u0004\u0003B\u0001!\tEa\u0010\t\u000f\t\r\u0003\u0001\"\u0011\u0003F!9!\u0011\u000b\u0001\u0005B\tM\u0003b\u0002B,\u0001\u0011\u0005#\u0011\f\u0005\b\u0005K\u0002A\u0011\tB4\u0011\u001d\u0011Y\u0007\u0001C!\u0005[BqA! \u0001\t\u0003\u0012y\bC\u0004\u0003\b\u0002!\tEa\u0010\u0003%1{7-\u00197EKZL7-Z'p]&$xN\u001d\u0006\u0003\t\u0016\u000bqa\u001d;pe\u0006<WM\u0003\u0002G\u000f\u00061qo\u001c:lKJT!\u0001S%\u0002\r\u0011,\u0007\u000f\\8z\u0015\tQ5*A\u0004tKJ4\u0018nY3\u000b\u00051k\u0015\u0001C2fY\u0016\u0014wN\u001d8\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\u0002\u0001'\r\u00011+\u0017\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\u0005i[V\"A\"\n\u0005q\u001b%!\u0004#fm&\u001cW-T8oSR|'/\u0001\u0003d_:4\u0007CA0c\u001b\u0005\u0001'BA1L\u0003\u0019\u0019w.\\7p]&\u00111\r\u0019\u0002\r\u0007\u0016dWMY8s]\u000e{gNZ\u0001\t_\n\u001cXM\u001d<feB\u0011!LZ\u0005\u0003O\u000e\u0013a\u0002R3wS\u000e,wJY:feZ,'/A\u0006eKZL7-Z%oM>\u001c\b\u0003\u00026pcrl\u0011a\u001b\u0006\u0003Y6\fA!\u001e;jY*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\ri\u0015\r\u001d\t\u0003eft!a]<\u0011\u0005Q,V\"A;\u000b\u0005Y\f\u0016A\u0002\u001fs_>$h(\u0003\u0002y+\u00061\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tAX\u000bE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\u0002\fA!\\3uC&\u0019\u00111\u0001@\u0003\u0015\u0011+g/[2f\u0013:4w.A\u0005eSN\\\u0017J\u001c4pgB)!n\\9\u0002\nA\u0019Q0a\u0003\n\u0007\u00055aP\u0001\u0005ESN\\\u0017J\u001c4p\u0003\u0019a\u0014N\\5u}QQ\u00111CA\u000b\u0003/\tI\"a\u0007\u0011\u0005i\u0003\u0001\"B/\u0006\u0001\u0004q\u0006\"\u00023\u0006\u0001\u0004)\u0007\"\u00025\u0006\u0001\u0004I\u0007bBA\u0003\u000b\u0001\u0007\u0011qA\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dr*A\u0003tY\u001a$$.\u0003\u0003\u0002,\u0005\u0015\"A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0003\u001d=\u00137/\u001a:wK\u0012$UM^5dKN\u0011\u0001bU\u0001\u000bI\u00164\u0018nY3J]\u001a|W#\u0001?\u0002\u0017\u0011,g/[2f\u0013:4w\u000e\t\u000b\u0005\u0003w\ty\u0004E\u0002\u0002>!i\u0011\u0001\u0001\u0005\u0007\u0003gY\u0001\u0019\u0001?\u0016\u0005\u0005\r\u0003cBA#\u0003\u0017\n\u0018\u0011B\u0007\u0003\u0003\u000fR1!!\u0013l\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u001b\n9EA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\f!\u0002Z5tW&sgm\\:!\u0003%y'm]3sm\u0016\u00148/\u0006\u0002\u0002VA!!.a\u0016f\u0013\r\tIf\u001b\u0002\u0004'\u0016$\u0018AC8cg\u0016\u0014h/\u001a:tA\u0005Y1/_:CY>\u001c7\u000eR5s+\u0005\t\u0018\u0001D:zg\ncwnY6ESJ\u0004\u0013\u0001C:uCR4\u0015\u000e\\3\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055T.\u0001\u0002j_&!\u0011\u0011OA6\u0005\u00111\u0015\u000e\\3\u0002\u0013M$\u0018\r\u001e$jY\u0016\u0004\u0013\u0001D5o\r2Lw\r\u001b;GS2,\u0017!D5o\r2Lw\r\u001b;GS2,\u0007%\u0001\tmCN$(+Z1e\u0007>l\u0007\u000f\\3uKV\u0011\u0011Q\u0010\t\u0004)\u0006}\u0014bAAA+\n!Aj\u001c8h\u0003Qa\u0017m\u001d;SK\u0006$7i\\7qY\u0016$Xm\u0018\u0013fcR!\u0011qQAG!\r!\u0016\u0011R\u0005\u0004\u0003\u0017+&\u0001B+oSRD\u0011\"a$\u0018\u0003\u0003\u0005\r!! \u0002\u0007a$\u0013'A\tmCN$(+Z1e\u0007>l\u0007\u000f\\3uK\u0002\n\u0011\u0003\\1ti^\u0013\u0018\u000e^3D_6\u0004H.\u001a;f\u0003Ua\u0017m\u001d;Xe&$XmQ8na2,G/Z0%KF$B!a\"\u0002\u001a\"I\u0011q\u0012\u000e\u0002\u0002\u0003\u0007\u0011QP\u0001\u0013Y\u0006\u001cHo\u0016:ji\u0016\u001cu.\u001c9mKR,\u0007%\u0001\tmCN$(+Z1e\u0013:4G.[4ii\u0006!B.Y:u%\u0016\fG-\u00138gY&<\u0007\u000e^0%KF$B!a\"\u0002$\"I\u0011qR\u000f\u0002\u0002\u0003\u0007\u0011QP\u0001\u0012Y\u0006\u001cHOU3bI&sg\r\\5hQR\u0004\u0013!\u00057bgR<&/\u001b;f\u0013:4G.[4ii\u0006)B.Y:u/JLG/Z%oM2Lw\r\u001b;`I\u0015\fH\u0003BAD\u0003[C\u0011\"a$!\u0003\u0003\u0005\r!! \u0002%1\f7\u000f^,sSR,\u0017J\u001c4mS\u001eDG\u000fI\u0001\fC\u0012$wJY:feZ,'\u000f\u0006\u0003\u0002\b\u0006U\u0006\"\u00023#\u0001\u0004)\u0017A\u0004:f[>4Xm\u00142tKJ4XM\u001d\u000b\u0005\u0003\u000f\u000bY\fC\u0003eG\u0001\u0007Q-\u0001\fo_RLg-_(cg\u0016\u0014h/\u001a:t\u001f:,%O]8s)\u0019\t9)!1\u0002X\"9\u00111\u0019\u0013A\u0002\u0005\u0015\u0017aC7pk:$\bk\\5oiN\u0004R!a2\u0002RFtA!!3\u0002N:\u0019A/a3\n\u0003YK1!a4V\u0003\u001d\u0001\u0018mY6bO\u0016LA!a5\u0002V\n!A*[:u\u0015\r\ty-\u0016\u0005\b\u00033$\u0003\u0019AAn\u0003)!\u0017n]6Ti\u0006$Xo\u001d\t\u0004{\u0006u\u0017bAAp}\nQA)[:l'R\fG/^:\u0002C9|G/\u001b4z\u001f\n\u001cXM\u001d<feN|eNT8o\u0007JLG/[2bY\u0016\u0013(o\u001c:\u0015\r\u0005\u001d\u0015Q]At\u0011\u001d\t\u0019-\na\u0001\u0003\u000bDq!!7&\u0001\u0004\tY.\u0001\ro_RLg-_(cg\u0016\u0014h/\u001a:t\u001f:DU-\u00197uQf$B!a\"\u0002n\"1\u0011q\u001e\u0014A\u0002E\f!\"\\8v]R\u0004v.\u001b8u\u0003yqw\u000e^5gs>\u00137/\u001a:wKJ\u001cxJ\u001c%jO\"$\u0015n]6Vg\u0006<W\r\u0006\u0003\u0002\b\u0006U\bBBAxO\u0001\u0007\u0011/\u0001\u0004j_\"\u000bgn\u001a\u000b\u0003\u0003w\u00042\u0001VA\u007f\u0013\r\ty0\u0016\u0002\b\u0005>|G.Z1o\u0003!!xn\u0015;sS:<G#A9\u0002\u001f=\u00147/\u001a:wK\u0012$UM^5dKN,\"A!\u0003\u0011\u000b)|G0a\u000f\u0002'=\u00147/\u001a:wK\u0012$UM^5dKN|F%Z9\u0015\t\u0005\u001d%q\u0002\u0005\n\u0003\u001f[\u0013\u0011!a\u0001\u0005\u0013\t\u0001c\u001c2tKJ4X\r\u001a#fm&\u001cWm\u001d\u0011\u0002#\u0011L7o[\"iK\u000e\\\u0017J\u001c;feZ\fG.\u0001\neSN\\7\t[3dW&sG/\u001a:wC2\u0004\u0013A\u00063fm&\u001cW-T8oSR|'o\u00115fG.d\u0015n\u001d;\u0016\u0005\tm\u0001#BAd\u0005;\t\u0018\u0002\u0002B\u0010\u0003+\u00141aU3r\u0003]!WM^5dK6{g.\u001b;pe\u000eCWmY6MSN$\b%A\u0006dQ\u0016\u001c7.S8IC:<WCAA~\u00031\u0019\u0007.Z2l\u0013>D\u0015M\\4!\u00039\u0019\u0007.Z2l%\u0016\fGm\u0016:ji\u0016\fqb\u00195fG.\u0014V-\u00193Xe&$X\rI\u0001\u000fG\",7m\u001b#jg.,6/Y4f\u0003=\u0019\u0007.Z2l\t&\u001c8.V:bO\u0016\u0004\u0013a\u00033jg.\u001c\u0005.Z2lKJ,\"A!\u000e\u0011\t\u0005\u0015#qG\u0005\u0005\u0005s\t9E\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fA\u0002Z5tW\u000eCWmY6fe\u0002\nA!\u001b8jiR\u0011\u0011qQ\u0001\u000bgR\f'\u000f^\"iK\u000e\\\u0017A\u0005:fO&\u001cH/\u001a:GS2,wK]5uKJ$B!a\"\u0003H!9!\u0011J\u001eA\u0002\t-\u0013A\u00034jY\u0016<&/\u001b;feB\u0019!L!\u0014\n\u0007\t=3I\u0001\u0006GS2,wK]5uKJ\fA#\u001e8sK\u001eL7\u000f^3s\r&dWm\u0016:ji\u0016\u0014H\u0003BAD\u0005+BqA!\u0013=\u0001\u0004\u0011Y%A\bsK\u001eL7\u000f^3s\r2,8\u000f[3s)\u0011\t9Ia\u0017\t\u000f\tuS\b1\u0001\u0003`\u00059a\r\\;tQ\u0016\u0014\bc\u0001.\u0003b%\u0019!1M\"\u0003\u00191{7-\u00197GYV\u001c\b.\u001a:\u0002#Ut'/Z4jgR,'O\u00127vg\",'\u000f\u0006\u0003\u0002\b\n%\u0004b\u0002B/}\u0001\u0007!qL\u0001\u0012e\u0016\u0004xN\u001d;EKZL7-Z#se>\u0014H\u0003CAD\u0005_\u0012\tHa\u001f\t\r\u0005=x\b1\u0001r\u0011\u001d\u0011\u0019h\u0010a\u0001\u0005k\n\u0011!\u001a\t\u0005\u0003S\u00129(\u0003\u0003\u0003z\u0005-$aC%P\u000bb\u001cW\r\u001d;j_:Dq!!7@\u0001\u0004\tY.\u0001\fsKB|'\u000f\u001e(p]\u000e\u0013\u0018\u000e^5dC2,%O]8s)!\t9I!!\u0003\u0004\n\u0015\u0005BBAx\u0001\u0002\u0007\u0011\u000fC\u0004\u0003t\u0001\u0003\rA!\u001e\t\u000f\u0005e\u0007\t1\u0001\u0002\\\u0006)1\r\\8tK\u0002")
public class LocalDeviceMonitor
implements DeviceMonitor {
    public final CelebornConf org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf;
    private final DeviceObserver observer;
    private final Map<String, DeviceInfo> deviceInfos;
    private final Map<String, DiskInfo> diskInfos;
    private final Logger logger;
    private Map<DeviceInfo, ObservedDevice> observedDevices;
    private final long diskCheckInterval;
    private final Seq<String> deviceMonitorCheckList;
    private final boolean checkIoHang;
    private final boolean checkReadWrite;
    private final boolean checkDiskUsage;
    private final ScheduledExecutorService diskChecker;

    @Override
    public Logger logger() {
        return this.logger;
    }

    public Map<DeviceInfo, ObservedDevice> observedDevices() {
        return this.observedDevices;
    }

    public void observedDevices_$eq(Map<DeviceInfo, ObservedDevice> x$1) {
        this.observedDevices = x$1;
    }

    public long diskCheckInterval() {
        return this.diskCheckInterval;
    }

    public Seq<String> deviceMonitorCheckList() {
        return this.deviceMonitorCheckList;
    }

    public boolean checkIoHang() {
        return this.checkIoHang;
    }

    public boolean checkReadWrite() {
        return this.checkReadWrite;
    }

    public boolean checkDiskUsage() {
        return this.checkDiskUsage;
    }

    private ScheduledExecutorService diskChecker() {
        return this.diskChecker;
    }

    public void init() {
        this.observedDevices_$eq(new HashMap<DeviceInfo, ObservedDevice>());
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.deviceInfos).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalDeviceMonitor.$anonfun$init$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LocalDeviceMonitor.$anonfun$init$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.deviceInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ObservedDevice observedDevice = new ObservedDevice(this, (DeviceInfo)entry._2());
            observedDevice.addObserver($this.observer);
            return this.observedDevices().put((DeviceInfo)entry._2(), observedDevice);
        });
    }

    @Override
    public void startCheck() {
        this.diskChecker().scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ LocalDeviceMonitor $outer;

            public void run() {
                this.$outer.logger().debug("Device check start");
                try {
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.observedDevices().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)device -> {
                        $anon$1.$anonfun$run$1(this, device);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.$outer.logger().error("Device check failed.", t);
                }
            }

            public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, ObservedDevice device$1, DiskInfo x0$1) {
                BoxedUnit boxedUnit;
                DiskInfo diskInfo = x0$1;
                if ($this.$outer.checkDiskUsage() && DeviceMonitor$.MODULE$.highDiskUsage($this.$outer.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf, diskInfo)) {
                    $this.$outer.logger().error(new StringBuilder(40).append(diskInfo.mountPoint()).append(" high_disk_usage error, notify observers").toString());
                    device$1.notifyObserversOnHighDiskUsage(diskInfo.mountPoint());
                    boxedUnit = BoxedUnit.UNIT;
                } else if ($this.$outer.checkReadWrite() && DeviceMonitor$.MODULE$.readWriteError($this.$outer.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf, (File)diskInfo.dirs().head())) {
                    $this.$outer.logger().error(new StringBuilder(35).append(diskInfo.mountPoint()).append(" read-write error, notify observers").toString());
                    device$1.notifyObserversOnNonCriticalError((List<String>)new .colon.colon((Object)diskInfo.mountPoint(), (List)Nil$.MODULE$), DiskStatus.READ_OR_WRITE_FAILURE);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    device$1.notifyObserversOnHealthy(diskInfo.mountPoint());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, ObservedDevice device) {
                List mountPoints = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(device.diskInfos().keySet()).asScala()).toList();
                if ($this.$outer.checkIoHang() && device.ioHang()) {
                    $this.$outer.logger().error(new StringBuilder(49).append("Encounter device io hang error!").append(device.deviceInfo().name()).append(", notify observers").toString());
                    device.notifyObserversOnNonCriticalError((List<String>)mountPoints, DiskStatus.IO_HANG);
                } else {
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(device.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        $anon$1.$anonfun$run$2($this, device, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$$anon$1 org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$ObservedDevice ), $anonfun$run$2$adapted(org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$$anon$1 org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$ObservedDevice org.apache.celeborn.common.meta.DiskInfo )}, serializedLambda);
            }
        }, this.diskCheckInterval(), this.diskCheckInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void registerFileWriter(FileWriter fileWriter) {
        String mountPoint = DeviceInfo$.MODULE$.getMountPoint(fileWriter.getFile().getAbsolutePath(), this.diskInfos);
        this.observedDevices().get(this.diskInfos.get(mountPoint).deviceInfo()).addObserver(fileWriter);
    }

    @Override
    public void unregisterFileWriter(FileWriter fileWriter) {
        String mountPoint = DeviceInfo$.MODULE$.getMountPoint(fileWriter.getFile().getAbsolutePath(), this.diskInfos);
        this.observedDevices().get(this.diskInfos.get(mountPoint).deviceInfo()).removeObserver(fileWriter);
    }

    @Override
    public void registerFlusher(LocalFlusher flusher) {
        this.observedDevices().get(this.diskInfos.get(flusher.mountPoint()).deviceInfo()).addObserver(flusher);
    }

    @Override
    public void unregisterFlusher(LocalFlusher flusher) {
        this.observedDevices().get(this.diskInfos.get(flusher.mountPoint()).deviceInfo()).removeObserver(flusher);
    }

    @Override
    public void reportDeviceError(String mountPoint, IOException e, DiskStatus diskStatus) {
        block0: {
            this.logger().error(new StringBuilder(33).append("Receive report exception, disk ").append(mountPoint).append(", ").append(e).toString());
            if (!this.diskInfos.containsKey(mountPoint)) break block0;
            this.observedDevices().get(this.diskInfos.get(mountPoint).deviceInfo()).notifyObserversOnError((List<String>)new .colon.colon((Object)mountPoint, (List)Nil$.MODULE$), diskStatus);
        }
    }

    @Override
    public void reportNonCriticalError(String mountPoint, IOException e, DiskStatus diskStatus) {
        this.logger().error(new StringBuilder(40).append("Receive non-critical exception, disk: ").append(mountPoint).append(", ").append(e).toString());
        this.observedDevices().get(this.diskInfos.get(mountPoint).deviceInfo()).notifyObserversOnNonCriticalError((List<String>)new .colon.colon((Object)mountPoint, (List)Nil$.MODULE$), diskStatus);
    }

    @Override
    public void close() {
        block0: {
            if (DeviceMonitor$.MODULE$.deviceCheckThreadPool() == null) break block0;
            DeviceMonitor$.MODULE$.deviceCheckThreadPool().shutdownNow();
        }
    }

    public static final /* synthetic */ boolean $anonfun$init$1(Tuple2 x$1) {
        return ((DeviceInfo)x$1._2()).deviceStatAvailable();
    }

    public static final /* synthetic */ void $anonfun$init$2(LocalDeviceMonitor $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String deviceName = (String)tuple2._1();
        $this.logger().warn(new StringBuilder(71).append("device monitor may not worker properly ").append("because noDevice device ").append(deviceName).append(" exists.").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalDeviceMonitor(CelebornConf conf, DeviceObserver observer, Map<String, DeviceInfo> deviceInfos, Map<String, DiskInfo> diskInfos) {
        this.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf = conf;
        this.observer = observer;
        this.deviceInfos = deviceInfos;
        this.diskInfos = diskInfos;
        DeviceMonitor.$init$(this);
        this.logger = LoggerFactory.getLogger(LocalDeviceMonitor.class);
        this.diskCheckInterval = conf.diskMonitorCheckInterval();
        this.deviceMonitorCheckList = conf.diskMonitorCheckList();
        this.checkIoHang = this.deviceMonitorCheckList().contains((Object)"iohang");
        this.checkReadWrite = this.deviceMonitorCheckList().contains((Object)"readwrite");
        this.checkDiskUsage = this.deviceMonitorCheckList().contains((Object)"diskusage");
        this.diskChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("worker-disk-checker");
    }

    public class ObservedDevice {
        private final DeviceInfo deviceInfo;
        private final ConcurrentHashMap<String, DiskInfo> diskInfos;
        private final Set<DeviceObserver> observers;
        private final String sysBlockDir;
        private final File statFile;
        private final File inFlightFile;
        private long lastReadComplete;
        private long lastWriteComplete;
        private long lastReadInflight;
        private long lastWriteInflight;
        public final /* synthetic */ LocalDeviceMonitor $outer;

        public DeviceInfo deviceInfo() {
            return this.deviceInfo;
        }

        public ConcurrentHashMap<String, DiskInfo> diskInfos() {
            return this.diskInfos;
        }

        public Set<DeviceObserver> observers() {
            return this.observers;
        }

        public String sysBlockDir() {
            return this.sysBlockDir;
        }

        public File statFile() {
            return this.statFile;
        }

        public File inFlightFile() {
            return this.inFlightFile;
        }

        public long lastReadComplete() {
            return this.lastReadComplete;
        }

        public void lastReadComplete_$eq(long x$1) {
            this.lastReadComplete = x$1;
        }

        public long lastWriteComplete() {
            return this.lastWriteComplete;
        }

        public void lastWriteComplete_$eq(long x$1) {
            this.lastWriteComplete = x$1;
        }

        public long lastReadInflight() {
            return this.lastReadInflight;
        }

        public void lastReadInflight_$eq(long x$1) {
            this.lastReadInflight = x$1;
        }

        public long lastWriteInflight() {
            return this.lastWriteInflight;
        }

        public void lastWriteInflight_$eq(long x$1) {
            this.lastWriteInflight = x$1;
        }

        public void addObserver(DeviceObserver observer) {
            this.observers().add(observer);
        }

        public void removeObserver(DeviceObserver observer) {
            this.observers().remove(observer);
        }

        public synchronized void notifyObserversOnError(List<String> mountPoints, DiskStatus diskStatus) {
            mountPoints.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string = x0$1;
                DiskInfo diskInfo = this.diskInfos().get(string).setStatus(diskStatus);
                return diskInfo;
            });
            HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tmpObservers).asScala()).foreach((Function1 & Serializable & scala.Serializable)ob -> {
                mountPoints.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ObservedDevice.$anonfun$notifyObserversOnError$3(ob, diskStatus$1, x0$2);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }

        public synchronized void notifyObserversOnNonCriticalError(List<String> mountPoints, DiskStatus diskStatus) {
            mountPoints.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string = x0$1;
                DiskInfo diskInfo = this.diskInfos().get(string).setStatus(diskStatus);
                return diskInfo;
            });
            HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tmpObservers).asScala()).foreach((Function1 & Serializable & scala.Serializable)ob -> {
                mountPoints.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ObservedDevice.$anonfun$notifyObserversOnNonCriticalError$3(ob, diskStatus$2, x0$2);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }

        public synchronized void notifyObserversOnHealthy(String mountPoint) {
            this.diskInfos().get(mountPoint).setStatus(DiskStatus.HEALTHY);
            HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tmpObservers).asScala()).foreach((Function1 & Serializable & scala.Serializable)ob -> {
                ob.notifyHealthy(mountPoint);
                return BoxedUnit.UNIT;
            });
        }

        public synchronized void notifyObserversOnHighDiskUsage(String mountPoint) {
            this.diskInfos().get(mountPoint).setStatus(DiskStatus.HIGH_DISK_USAGE);
            HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tmpObservers).asScala()).foreach((Function1 & Serializable & scala.Serializable)ob -> {
                ob.notifyHighDiskUsage(mountPoint);
                return BoxedUnit.UNIT;
            });
        }

        public boolean ioHang() {
            boolean bl;
            block12: {
                if (this.deviceInfo().deviceStatAvailable()) {
                    bl = false;
                } else {
                    BufferedSource statsSource = null;
                    BufferedSource infligtSource = null;
                    try {
                        try {
                            boolean isWriteHang;
                            statsSource = Source$.MODULE$.fromFile(this.statFile(), Codec$.MODULE$.fallbackSystemCodec());
                            infligtSource = Source$.MODULE$.fromFile(this.inFlightFile(), Codec$.MODULE$.fallbackSystemCodec());
                            String[] stats = ((String)statsSource.getLines().next()).trim().split("[ \t]+", -1);
                            String[] inflight = ((String)infligtSource.getLines().next()).trim().split("[ \t]+", -1);
                            long readComplete = new StringOps(Predef$.MODULE$.augmentString(stats[0])).toLong();
                            long writeComplete = new StringOps(Predef$.MODULE$.augmentString(stats[4])).toLong();
                            long readInflight = new StringOps(Predef$.MODULE$.augmentString(inflight[0])).toLong();
                            long writeInflight = new StringOps(Predef$.MODULE$.augmentString(inflight[1])).toLong();
                            if (this.lastReadComplete() == -1L) {
                                this.lastReadComplete_$eq(readComplete);
                                this.lastWriteComplete_$eq(writeComplete);
                                this.lastReadInflight_$eq(readInflight);
                                this.lastWriteInflight_$eq(writeInflight);
                                bl = false;
                                break block12;
                            }
                            boolean isReadHang = this.lastReadComplete() == readComplete && readInflight >= this.lastReadInflight() && this.lastReadInflight() > 0L;
                            boolean bl2 = isWriteHang = this.lastWriteComplete() == writeComplete && writeInflight >= this.lastWriteInflight() && this.lastWriteInflight() > 0L;
                            if (isReadHang || isWriteHang) {
                                this.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$ObservedDevice$$$outer().logger().info(new StringBuilder(72).append("Result of DeviceInfo.checkIoHang, DeviceName: ").append(this.deviceInfo().name()).append("(").append(readComplete).append(",").append(writeComplete).append(",").append(readInflight).append(",").append(writeInflight).append(")\t").append("(").append(this.lastReadComplete()).append(",").append(this.lastWriteComplete()).append(",").append(this.lastReadInflight()).append(",").append(this.lastWriteInflight()).append(")\t").append("Observer cnt: ").append(this.observers().size()).toString());
                                this.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$ObservedDevice$$$outer().logger().error(new StringBuilder(32).append("IO Hang! ReadHang: ").append(isReadHang).append(", WriteHang: ").append(isWriteHang).toString());
                            }
                            this.lastReadComplete_$eq(readComplete);
                            this.lastWriteComplete_$eq(writeComplete);
                            this.lastReadInflight_$eq(readInflight);
                            this.lastWriteInflight_$eq(writeInflight);
                            if (isReadHang || isWriteHang) {
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                        catch (Exception e) {
                            this.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$ObservedDevice$$$outer().logger().warn(new StringBuilder(50).append("Encounter Exception when check IO hang for device ").append(this.deviceInfo().name()).toString(), (Throwable)e);
                            bl = false;
                        }
                    }
                    finally {
                        if (statsSource != null) {
                            statsSource.close();
                        }
                        if (infligtSource != null) {
                            infligtSource.close();
                        }
                    }
                }
            }
            return bl;
        }

        public String toString() {
            return new StringBuilder(26).append("DeviceName: ").append(this.deviceInfo().name()).append("\tMount Infos: ").append(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).mkString("\n")).toString();
        }

        public /* synthetic */ LocalDeviceMonitor org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$ObservedDevice$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$notifyObserversOnError$3(DeviceObserver ob$1, DiskStatus diskStatus$1, String x0$2) {
            String string = x0$2;
            ob$1.notifyError(string, diskStatus$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$notifyObserversOnNonCriticalError$3(DeviceObserver ob$2, DiskStatus diskStatus$2, String x0$2) {
            String string = x0$2;
            ob$2.notifyNonCriticalError(string, diskStatus$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public ObservedDevice(LocalDeviceMonitor $outer, DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.diskInfos = new ConcurrentHashMap();
            deviceInfo.diskInfos().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DiskInfo diskInfo = x0$1;
                DiskInfo diskInfo2 = this.diskInfos().put(diskInfo.mountPoint(), diskInfo);
                return diskInfo2;
            });
            this.observers = ConcurrentHashMap.newKeySet();
            this.sysBlockDir = $outer.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf.diskMonitorSysBlockDir();
            this.statFile = new File(new StringBuilder(6).append(this.sysBlockDir()).append("/").append(deviceInfo.name()).append("/stat").toString());
            this.inFlightFile = new File(new StringBuilder(10).append(this.sysBlockDir()).append("/").append(deviceInfo.name()).append("/inflight").toString());
            this.lastReadComplete = -1L;
            this.lastWriteComplete = -1L;
            this.lastReadInflight = -1L;
            this.lastWriteInflight = -1L;
        }
    }
}

