/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.server.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005]fAB\u0010!\u0003\u0003\u0011c\u0006\u0003\u0005>\u0001\t\u0015\r\u0011\"\u0001@\u0011!A\u0005A!A!\u0002\u0013\u0001\u0005\u0002C%\u0001\u0005\u000b\u0007I\u0011\u0001&\t\u00119\u0003!\u0011!Q\u0001\n-C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\t;\u0002A)\u0019!C\t\u0015\"9a\f\u0001b\u0001\n#y\u0006B\u00029\u0001A\u0003%\u0001\rC\u0004r\u0001\t\u0007I\u0011\u0003:\t\ry\u0004\u0001\u0015!\u0003t\u0011!y\bA1A\u0005\u0012\u0005\u0005\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0001\t\u0011\u0005M\u0001\u00011A\u0005\u0012)C\u0011\"!\u0006\u0001\u0001\u0004%\t\"a\u0006\t\u000f\u0005\r\u0002\u0001)Q\u0005\u0017\"I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u0011q\u0005\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002*!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u0011\u0011\b\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002<!I\u00111\t\u0001C\u0002\u0013\u0005\u0011Q\t\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002H!9\u00111\u000b\u0001\u0005\n\u0005U\u0003BBA,\u0001\u0011\u0005!\nC\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u00033\u0003A\u0011AA+\u0011\u001d\tY\n\u0001D\u0001\u0003;\u0013qA\u00127vg\",'O\u0003\u0002\"E\u000591\u000f^8sC\u001e,'BA\u0012%\u0003\u00199xN]6fe*\u0011QEJ\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u001dB\u0013aB:feZL7-\u001a\u0006\u0003S)\n\u0001bY3mK\n|'O\u001c\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xmE\u0002\u0001_U\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0007C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001e)\u0003\u0019\u0019w.\\7p]&\u0011Ah\u000e\u0002\b\u0019><w-\u001b8h\u000319xN]6feN{WO]2f\u0007\u0001)\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000baa]8ve\u000e,'BA#:\u0003\u001diW\r\u001e:jGNL!a\u0012\"\u0003\u001d\u0005\u00137\u000f\u001e:bGR\u001cv.\u001e:dK\u0006iqo\u001c:lKJ\u001cv.\u001e:dK\u0002\n1\u0002\u001e5sK\u0006$7i\\;oiV\t1\n\u0005\u00021\u0019&\u0011Q*\r\u0002\u0004\u0013:$\u0018\u0001\u0004;ie\u0016\fGmQ8v]R\u0004\u0013a\u00044mkNDG+[7f\u001b\u0016$(/[2\u0011\u0005E#V\"\u0001*\u000b\u0005MK\u0014\u0001B7fi\u0006L!!\u0016*\u0003\u0015QKW.Z,j]\u0012|w/\u0001\u0004=S:LGO\u0010\u000b\u00051j[F\f\u0005\u0002Z\u00015\t\u0001\u0005C\u0003>\r\u0001\u0007\u0001\tC\u0003J\r\u0001\u00071\nC\u0003P\r\u0001\u0007\u0001+A\u0005gYV\u001c\b.\u001a:JI\u0006iqo\u001c:lS:<\u0017+^3vKN,\u0012\u0001\u0019\t\u0004a\u0005\u001c\u0017B\u000122\u0005\u0015\t%O]1z!\r!7.\\\u0007\u0002K*\u0011amZ\u0001\u000bG>t7-\u001e:sK:$(B\u00015j\u0003\u0011)H/\u001b7\u000b\u0003)\fAA[1wC&\u0011A.\u001a\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h#V,W/\u001a\t\u00033:L!a\u001c\u0011\u0003\u0013\u0019cWo\u001d5UCN\\\u0017AD<pe.LgnZ)vKV,7\u000fI\u0001\fEV4g-\u001a:Rk\u0016,X-F\u0001t!\r!7\u000e\u001e\t\u0003krl\u0011A\u001e\u0006\u0003ob\faAY;gM\u0016\u0014(BA={\u0003\u0015qW\r\u001e;z\u0015\u0005Y\u0018AA5p\u0013\tihO\u0001\tD_6\u0004xn]5uK\nKH/\u001a\"vM\u0006a!-\u001e4gKJ\fV/Z;fA\u00059qo\u001c:lKJ\u001cXCAA\u0002!\u0011\u0001\u0014-!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003j\u0003\u0011a\u0017M\\4\n\t\u0005=\u0011\u0011\u0002\u0002\u0007)\"\u0014X-\u00193\u0002\u0011]|'o[3sg\u0002\nqB\\3yi^{'o[3s\u0013:$W\r_\u0001\u0014]\u0016DHoV8sW\u0016\u0014\u0018J\u001c3fq~#S-\u001d\u000b\u0005\u00033\ty\u0002E\u00021\u00037I1!!\b2\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005r\"!AA\u0002-\u000b1\u0001\u001f\u00132\u0003AqW\r\u001f;X_J\\WM]%oI\u0016D\b%\u0001\nmCN$()Z4j]\u001acWo\u001d5US6,WCAA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018K\u00061\u0011\r^8nS\u000eLA!a\r\u0002.\ty\u0011\t^8nS\u000eduN\\4BeJ\f\u00170A\nmCN$()Z4j]\u001acWo\u001d5US6,\u0007%\u0001\u0005ti>\u0004h\t\\1h+\t\tY\u0004\u0005\u0003\u0002,\u0005u\u0012\u0002BA \u0003[\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!C:u_B4E.Y4!\u0003\u0011\u0011\u0018M\u001c3\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001bj!!a\u0013\u000b\u0005!\f\u0014\u0002BA(\u0003\u0017\u0012aAU1oI>l\u0017!\u0002:b]\u0012\u0004\u0013\u0001B5oSR$\"!!\u0007\u0002\u001d\u001d,GoV8sW\u0016\u0014\u0018J\u001c3fq\u0006QA/Y6f\u0005V4g-\u001a:\u0015\u0003Q\fAB]3ukJt')\u001e4gKJ$B!!\u0007\u0002b!)qO\u0007a\u0001i\u00069\u0011\r\u001a3UCN\\G\u0003CA4\u0003[\n\t(a\u001f\u0011\u0007A\nI'C\u0002\u0002lE\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002pm\u0001\r!\\\u0001\u0005i\u0006\u001c8\u000eC\u0004\u0002tm\u0001\r!!\u001e\u0002\u0013QLW.Z8vi6\u001b\bc\u0001\u0019\u0002x%\u0019\u0011\u0011P\u0019\u0003\t1{gn\u001a\u0005\u0007\u0003{Z\u0002\u0019A&\u0002\u0017]|'o[3s\u0013:$W\r_\u0001\u0010EV4g-\u001a:Rk\u0016,X-\u00138g_R\u0011\u00111\u0011\t\u0005\u0003\u000b\u000b\u0019J\u0004\u0003\u0002\b\u0006=\u0005cAAEc5\u0011\u00111\u0012\u0006\u0004\u0003\u001bs\u0014A\u0002\u001fs_>$h(C\u0002\u0002\u0012F\na\u0001\u0015:fI\u00164\u0017\u0002BAK\u0003/\u0013aa\u0015;sS:<'bAAIc\u0005\u00192\u000f^8q\u0003:$7\t\\3b]\u001acWo\u001d5fe\u0006\u0011\u0002O]8dKN\u001c\u0018jT#yG\u0016\u0004H/[8o)\u0019\tI\"a(\u0002.\"9\u0011\u0011\u0015\u0010A\u0002\u0005\r\u0016!A3\u0011\t\u0005\u0015\u0016\u0011V\u0007\u0003\u0003OS!a_5\n\t\u0005-\u0016q\u0015\u0002\f\u0013>+\u0005pY3qi&|g\u000eC\u0004\u00020z\u0001\r!!-\u0002\u001f\u0011,g/[2f\u000bJ\u0014xN\u001d+za\u0016\u00042!UAZ\u0013\r\t)L\u0015\u0002\u000b\t&\u001c8n\u0015;biV\u001c\b")
public abstract class Flusher
implements Logging {
    private int flusherId;
    private final AbstractSource workerSource;
    private final int threadCount;
    public final TimeWindow org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric;
    private final LinkedBlockingQueue<FlushTask>[] workingQueues;
    private final LinkedBlockingQueue<CompositeByteBuf> bufferQueue;
    private final Thread[] workers;
    private int nextWorkerIndex;
    private final AtomicLongArray lastBeginFlushTime;
    private final AtomicBoolean stopFlag;
    private final Random rand;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public AbstractSource workerSource() {
        return this.workerSource;
    }

    public int threadCount() {
        return this.threadCount;
    }

    private int flusherId$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$0) {
                this.flusherId = System.identityHashCode(this);
                this.bitmap$0 = true;
            }
        }
        return this.flusherId;
    }

    public int flusherId() {
        return !this.bitmap$0 ? this.flusherId$lzycompute() : this.flusherId;
    }

    public LinkedBlockingQueue<FlushTask>[] workingQueues() {
        return this.workingQueues;
    }

    public LinkedBlockingQueue<CompositeByteBuf> bufferQueue() {
        return this.bufferQueue;
    }

    public Thread[] workers() {
        return this.workers;
    }

    public int nextWorkerIndex() {
        return this.nextWorkerIndex;
    }

    public void nextWorkerIndex_$eq(int x$1) {
        this.nextWorkerIndex = x$1;
    }

    public AtomicLongArray lastBeginFlushTime() {
        return this.lastBeginFlushTime;
    }

    public AtomicBoolean stopFlag() {
        return this.stopFlag;
    }

    public Random rand() {
        return this.rand;
    }

    private void init() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.lastBeginFlushTime().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.lastBeginFlushTime().set(i, -1L));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.threadCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            $this.workingQueues()[index] = new LinkedBlockingQueue();
            $this.workers()[index] = new Thread(this, index){
                private final /* synthetic */ Flusher $outer;
                private final int index$1;

                public void run() {
                    while (!this.$outer.stopFlag().get()) {
                        FlushTask task = this.$outer.workingQueues()[this.index$1].take();
                        String key = new StringBuilder(9).append("Flusher-").append(this).append("-").append(this.$outer.rand().nextInt()).toString();
                        this.$outer.workerSource().sample(WorkerSource$.MODULE$.FlushDataTime(), key, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                            if (!task.notifier().hasException()) {
                                try {
                                    long flushBeginTime = System.nanoTime();
                                    $this.$outer.lastBeginFlushTime().set($this.index$1, flushBeginTime);
                                    task.flush();
                                    if ($this.$outer.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric != null) {
                                        long delta = System.nanoTime() - flushBeginTime;
                                        $this.$outer.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric.update(delta);
                                    }
                                }
                                catch (ClosedByInterruptException closedByInterruptException) {
                                }
                                catch (IOException e) {
                                    task.notifier().setException(e);
                                    $this.$outer.processIOException(e, DiskStatus.READ_OR_WRITE_FAILURE);
                                }
                                $this.$outer.lastBeginFlushTime().set($this.index$1, -1L);
                            }
                            $this.$outer.returnBuffer(task.buffer());
                            return task$1.notifier().numPendingFlushes.decrementAndGet();
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.index$1 = index$1;
                    super(new StringBuilder(1).append($outer).append("-").append(index$1).toString());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$1 org.apache.celeborn.service.deploy.worker.storage.FlushTask )}, serializedLambda);
                }
            };
            this.workers()[index].setDaemon(true);
            this.workers()[index].setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
                private final /* synthetic */ Flusher $outer;

                public void uncaughtException(Thread t, Throwable e) {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(this).append(" thread terminated.").toString(), e);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$uncaughtException$1(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$2 )}, serializedLambda);
                }
            });
            this.workers()[index].start();
        });
    }

    public synchronized int getWorkerIndex() {
        this.nextWorkerIndex_$eq((this.nextWorkerIndex() + 1) % this.threadCount());
        return this.nextWorkerIndex();
    }

    /*
     * WARNING - void declaration
     */
    public CompositeByteBuf takeBuffer() {
        void var1_1;
        block0: {
            CompositeByteBuf buffer = this.bufferQueue().poll();
            if (buffer != null) break block0;
            buffer = Unpooled.compositeBuffer((int)256);
        }
        return var1_1;
    }

    public void returnBuffer(CompositeByteBuf buffer) {
        MemoryManager.instance().releaseDiskBuffer(buffer.readableBytes());
        buffer.removeComponents(0, buffer.numComponents());
        buffer.clear();
        this.bufferQueue().put(buffer);
    }

    public boolean addTask(FlushTask task, long timeoutMs, int workerIndex) {
        return this.workingQueues()[workerIndex].offer(task, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public String bufferQueueInfo() {
        return new StringBuilder(15).append(this).append(" used buffers: ").append(this.bufferQueue().size()).toString();
    }

    public void stopAndCleanFlusher() {
        this.stopFlag().set(true);
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workers())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.interrupt();
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Exception when interrupt worker: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workers())).mkString(",")).append(", ").append(e).toString());
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.workingQueues())).foreach((Function1 & Serializable & scala.Serializable)queue -> {
            Flusher.$anonfun$stopAndCleanFlusher$3(this, queue);
            return BoxedUnit.UNIT;
        });
    }

    public abstract void processIOException(IOException var1, DiskStatus var2);

    public static final /* synthetic */ void $anonfun$stopAndCleanFlusher$3(Flusher $this, LinkedBlockingQueue queue) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)queue).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            $this.returnBuffer(task.buffer());
            return BoxedUnit.UNIT;
        });
    }

    public Flusher(AbstractSource workerSource, int threadCount, TimeWindow flushTimeMetric) {
        this.workerSource = workerSource;
        this.threadCount = threadCount;
        this.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric = flushTimeMetric;
        Logging.$init$((Logging)this);
        this.workingQueues = new LinkedBlockingQueue[threadCount];
        this.bufferQueue = new LinkedBlockingQueue();
        this.workers = new Thread[threadCount];
        this.nextWorkerIndex = 0;
        this.lastBeginFlushTime = new AtomicLongArray(threadCount);
        this.stopFlag = new AtomicBoolean(false);
        this.rand = new Random();
        this.init();
    }
}

