/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.has.client;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.hadoop.shaded.org.apache.kerby.has.client.HasClient;
import org.apache.hadoop.shaded.org.apache.kerby.has.common.HasException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.ccache.Credential;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;

public class HasLoginModule
implements LoginModule {
    public static final Logger LOG = LoggerFactory.getLogger(HasLoginModule.class);
    Krb5LoginModule krb5LoginModule;
    private Subject subject;
    private boolean debug = false;
    private boolean doNotPrompt = false;
    private boolean useTgtTicket = false;
    private String hadoopSecurityHas = null;
    private String princName = null;
    private boolean refreshKrb5Config = false;
    private boolean isInitiator = true;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private Credential credential = null;
    private PrincipalName principal = null;
    private KerberosPrincipal kerbClientPrinc = null;
    private KerberosTicket kerbTicket = null;
    private StringBuilder krb5PrincName = null;
    private boolean unboundServer = false;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.useTgtTicket = "true".equalsIgnoreCase((String)options.get("useTgtTicket"));
        if (this.useTgtTicket) {
            this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
            this.doNotPrompt = "true".equalsIgnoreCase((String)options.get("doNotPrompt"));
            this.useTgtTicket = "true".equalsIgnoreCase((String)options.get("useTgtTicket"));
            this.hadoopSecurityHas = (String)options.get("hadoopSecurityHas");
            this.princName = (String)options.get("principal");
            this.refreshKrb5Config = "true".equalsIgnoreCase((String)options.get("refreshKrb5Config"));
            String isInitiatorValue = (String)options.get("isInitiator");
            if (isInitiatorValue != null) {
                this.isInitiator = "true".equalsIgnoreCase(isInitiatorValue);
            }
            if (this.debug) {
                System.out.print("Debug is  " + this.debug + " doNotPrompt " + this.doNotPrompt + " isInitiator " + this.isInitiator + " refreshKrb5Config is " + this.refreshKrb5Config + " principal is " + this.princName + "\n");
            }
        } else {
            this.krb5LoginModule = new Krb5LoginModule();
            this.krb5LoginModule.initialize(subject, callbackHandler, sharedState, options);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.useTgtTicket) {
            String principalProperty;
            if (this.refreshKrb5Config) {
                try {
                    if (this.debug) {
                        System.out.println("Refreshing Kerberos configuration");
                    }
                    Config.refresh();
                }
                catch (KrbException ke) {
                    LoginException le = new LoginException(ke.getMessage());
                    le.initCause(ke);
                    throw le;
                }
            }
            if ((principalProperty = System.getProperty("sun.security.krb5.principal")) != null) {
                this.krb5PrincName = new StringBuilder(principalProperty);
            } else if (this.princName != null) {
                this.krb5PrincName = new StringBuilder(this.princName);
            }
            this.validateConfiguration();
            if (this.krb5PrincName != null && this.krb5PrincName.toString().equals("*")) {
                this.unboundServer = true;
            }
            try {
                this.attemptAuthentication();
                this.succeeded = true;
                this.cleanState();
                return true;
            }
            catch (LoginException e) {
                if (this.debug) {
                    System.out.println("\t\t[HasLoginModule] authentication failed \n" + e.getMessage());
                }
                this.succeeded = false;
                this.cleanState();
                throw e;
            }
        }
        this.succeeded = this.krb5LoginModule.login();
        return this.succeeded;
    }

    private void attemptAuthentication() throws LoginException {
        block10: {
            if (this.krb5PrincName != null) {
                try {
                    this.principal = new PrincipalName(this.krb5PrincName.toString(), 1);
                }
                catch (KrbException e) {
                    LoginException le = new LoginException(e.getMessage());
                    le.initCause(e);
                    throw le;
                }
            }
            try {
                TgtTicket tgtTicket;
                if (!this.useTgtTicket) break block10;
                if (this.debug) {
                    System.out.println("use tgt ticket to login, acquire TGT TICKET...");
                }
                HasClient hasClient = new HasClient(this.hadoopSecurityHas);
                try {
                    tgtTicket = hasClient.requestTgt();
                }
                catch (HasException e) {
                    LoginException le = new LoginException(e.getMessage());
                    le.initCause(e);
                    throw le;
                }
                this.credential = new Credential(tgtTicket);
                if (this.principal == null) {
                    this.principal = new PrincipalName(this.credential.getClientName().getName(), 1);
                }
                if (this.debug) {
                    System.out.println("Principal is " + this.principal);
                }
            }
            catch (RealmException ee) {
                LoginException ie = new LoginException(ee.getMessage());
                ie.initCause(ee);
                throw ie;
            }
        }
    }

    private void validateConfiguration() throws LoginException {
        if (this.doNotPrompt && !this.useTgtTicket) {
            throw new LoginException("Configuration Error - either doNotPrompt should be  false or useTgtTicket should be true");
        }
        if (this.krb5PrincName != null && this.krb5PrincName.toString().equals("*") && this.isInitiator) {
            throw new LoginException("Configuration Error - principal cannot be * when isInitiator is true");
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.debug) {
            System.out.println("Login success? " + this.succeeded);
        }
        if (this.useTgtTicket) {
            if (!this.succeeded) {
                this.cleanKerberosCred();
                return false;
            }
            if (this.isInitiator && this.credential == null) {
                this.succeeded = false;
                throw new LoginException("Null Client Credential");
            }
            if (this.subject.isReadOnly()) {
                this.cleanKerberosCred();
                throw new LoginException("Subject is Readonly");
            }
            Set<Object> privCredSet = this.subject.getPrivateCredentials();
            Set<Principal> princSet = this.subject.getPrincipals();
            this.kerbClientPrinc = new KerberosPrincipal(this.principal.getName());
            if (this.isInitiator) {
                boolean[] flags = new boolean[7];
                int flag = this.credential.getTicketFlags().getFlags();
                for (int i = 6; i >= 0; --i) {
                    flags[i] = (flag & 1 << i) != 0;
                }
                Date startTime = null;
                if (this.credential.getStartTime() != null) {
                    startTime = (Date)this.credential.getStartTime().getValue();
                }
                try {
                    this.kerbTicket = new KerberosTicket(this.credential.getTicket().encode(), new KerberosPrincipal(this.credential.getClientName().getName(), 1), new KerberosPrincipal(this.credential.getServerName().getName(), 2), this.credential.getKey().getKeyData(), this.credential.getKey().getKeyType().getValue(), flags, (Date)this.credential.getAuthTime().getValue(), startTime, (Date)this.credential.getEndTime().getValue(), (Date)this.credential.getRenewTill().getValue(), null);
                }
                catch (IOException e) {
                    LoginException ie = new LoginException(e.getMessage());
                    ie.initCause(e);
                    throw ie;
                }
            }
            if (!this.unboundServer && !princSet.contains(this.kerbClientPrinc)) {
                princSet.add(this.kerbClientPrinc);
            }
            if (this.kerbTicket != null && !privCredSet.contains(this.kerbTicket)) {
                privCredSet.add(this.kerbTicket);
            }
            this.commitSucceeded = true;
            if (this.debug) {
                System.out.println("Commit Succeeded \n");
            }
            return true;
        }
        return this.krb5LoginModule.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.useTgtTicket) {
            if (!this.succeeded) {
                return false;
            }
            if (this.succeeded && this.commitSucceeded) {
                this.logout();
            } else {
                this.succeeded = false;
            }
            return true;
        }
        return this.krb5LoginModule.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.useTgtTicket) {
            if (this.debug) {
                System.out.println("\t\t[Krb5LoginModule]: Entering logout");
            }
            if (this.subject.isReadOnly()) {
                this.cleanKerberosCred();
                throw new LoginException("Subject is Readonly");
            }
            this.subject.getPrincipals().remove(this.kerbClientPrinc);
            Iterator<Object> it = this.subject.getPrivateCredentials().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof KerberosTicket)) continue;
                it.remove();
            }
            this.cleanKerberosCred();
            this.succeeded = false;
            this.commitSucceeded = false;
            if (this.debug) {
                System.out.println("\t\t[HasLoginModule]: logged out Subject");
            }
            return true;
        }
        return this.krb5LoginModule.logout();
    }

    private void cleanKerberosCred() throws LoginException {
        try {
            if (this.kerbTicket != null) {
                this.kerbTicket.destroy();
            }
        }
        catch (DestroyFailedException e) {
            throw new LoginException("Destroy Failed on Kerberos Private Credentials");
        }
        this.kerbTicket = null;
        this.kerbClientPrinc = null;
    }

    private void cleanState() {
        if (!this.succeeded) {
            this.principal = null;
        }
        if (this.krb5PrincName != null && this.krb5PrincName.length() != 0) {
            this.krb5PrincName.delete(0, this.krb5PrincName.length());
        }
        this.krb5PrincName = null;
    }
}

