/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.has.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.kerby.KOptions;
import org.apache.hadoop.shaded.org.apache.kerby.has.client.HasClientUtil;
import org.apache.hadoop.shaded.org.apache.kerby.has.common.HasConfig;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.admin.kadmin.Kadmin;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONArray;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasAuthAdminClient
implements Kadmin {
    public static final Logger LOG = LoggerFactory.getLogger(HasAuthAdminClient.class);
    private HasConfig hasConfig;

    public HasAuthAdminClient(HasConfig hasConfig) {
        this.hasConfig = hasConfig;
    }

    private String getKadminBaseURL() throws KrbException {
        return HasClientUtil.getBaseUrl(this.hasConfig, "kadmin");
    }

    private String getHadminBaseURL() throws KrbException {
        return HasClientUtil.getBaseUrl(this.hasConfig, "hadmin");
    }

    @Override
    public void addPrincipal(String principal) throws KrbException {
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "addprincipal?principal=" + principal);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "POST", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            LOG.info(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
    }

    @Override
    public void addPrincipal(String principal, String password) throws KrbException {
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "addprincipal?principal=" + principal + "&password=" + password);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "POST", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            LOG.info(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
    }

    @Override
    public void addPrincipal(String principal, String password, KOptions kOptions) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public void deletePrincipal(String principal) throws KrbException {
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "deleteprincipal?principal=" + principal);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "DELETE", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException("Connection deined.");
            }
            LOG.info(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
    }

    @Override
    public void modifyPrincipal(String principal, KOptions kOptions) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public void renamePrincipal(String oldPrincipal, String newPrincipal) throws KrbException {
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "renameprincipal?oldprincipal=" + oldPrincipal + "&newprincipal=" + newPrincipal);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "POST", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            LOG.info(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
    }

    @Override
    public List<String> getPrincipals() throws KrbException {
        String response;
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "listprincipals");
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        LOG.info("Remote Admin Url: " + url);
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", true);
        try {
            httpConn.setDoInput(true);
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            response = HasClientUtil.getResponse(httpConn);
        }
        catch (IOException e) {
            LOG.error("IO error occurred." + e.getMessage());
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
        return this.convertJsonStringToList(response);
    }

    @Override
    public List<String> getPrincipals(String exp) throws KrbException {
        String response;
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "listprincipals?exp=" + exp);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object. ", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            response = HasClientUtil.getResponse(httpConn);
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
        if (response == null) {
            throw new KrbException("Please initial KDC first.");
        }
        return this.convertJsonStringToList(response);
    }

    private List<String> convertJsonStringToList(String result) throws KrbException {
        ArrayList<String> principalLists = new ArrayList<String>();
        try {
            JSONArray jsonArray = new JSONArray(result);
            for (int i = 0; i < jsonArray.length(); ++i) {
                principalLists.add("\t" + jsonArray.getString(i));
            }
        }
        catch (JSONException e) {
            throw new KrbException("JSON Exception occurred. ", (Throwable)e);
        }
        return principalLists;
    }

    @Override
    public void exportKeytab(File keytabFile, String principal) throws KrbException {
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "exportkeytab?principal=" + principal);
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to create a URL object." + e.getMessage());
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            try {
                if (!keytabFile.exists() && !keytabFile.createNewFile()) {
                    throw new KrbException("Failed to create keytab file " + keytabFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new KrbException("Failed to load or create keytab " + keytabFile.getAbsolutePath(), (Throwable)e);
            }
            try (FileOutputStream fos = new FileOutputStream(keytabFile);
                 InputStream in = httpConn.getInputStream();){
                int read;
                byte[] buffer = new byte[3072];
                while ((read = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
        LOG.info("Receive keytab file \"" + keytabFile.getName() + "\" from server successfully.");
    }

    public void exportKeytabWithGlob(File keytabFile, String principal) throws KrbException {
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "exportkeytab?principal=" + principal + "&global=true");
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to create a URL object.", (Throwable)e);
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            try {
                if (!keytabFile.exists() && !keytabFile.createNewFile()) {
                    throw new KrbException("Failed to create keytab file " + keytabFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new KrbException("Failed to load or create keytab " + keytabFile.getAbsolutePath(), (Throwable)e);
            }
            try (FileOutputStream fos = new FileOutputStream(keytabFile);
                 InputStream in = httpConn.getInputStream();){
                int read;
                byte[] buffer = new byte[3072];
                while ((read = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            LOG.error("IO error occurred.", (Throwable)e);
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
        LOG.info("Receive keytab file " + keytabFile.getName() + " from server successfully.");
    }

    @Override
    public void exportKeytab(File keytabFile, List<String> principals) throws KrbException {
        for (String principal : principals) {
            URL url;
            String request = this.getKadminBaseURL() + "exportkeytab?principal=" + principal;
            try {
                url = new URL(request);
            }
            catch (MalformedURLException e) {
                throw new KrbException("Failed to create a URL object.");
            }
            HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", true);
            try {
                httpConn.connect();
                if (httpConn.getResponseCode() != 200) {
                    throw new KrbException(HasClientUtil.getResponse(httpConn));
                }
                FileOutputStream fos = new FileOutputStream(keytabFile);
                Throwable throwable = null;
                try {
                    InputStream in = httpConn.getInputStream();
                    Throwable throwable2 = null;
                    try {
                        int read;
                        byte[] buffer = new byte[4096];
                        while ((read = in.read(buffer)) > 0) {
                            fos.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new KrbException("IO error occurred.", (Throwable)e);
            }
        }
        LOG.info("Accept keytab file \"" + keytabFile.getName() + "\" from server.");
    }

    @Override
    public void addPrincipal(String principal, KOptions kOptions) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public String getKadminPrincipal() {
        return KrbUtil.makeKadminPrincipal(this.hasConfig.getRealm()).getName();
    }

    @Override
    public void exportKeytab(File keytabFile) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public void removeKeytabEntriesOf(File keytabFile, String principal, int kvno) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public void removeOldKeytabEntriesOf(File keytabFile, String principal) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public void changePassword(String principal, String newPassword) throws KrbException {
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "changepassword?principal=" + principal + "&password=" + newPassword);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "POST", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            LOG.info(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
    }

    @Override
    public void updateKeys(String principal) throws KrbException {
        throw new KrbException("Unsupported feature");
    }

    @Override
    public void release() throws KrbException {
    }

    public List<String> addPrincipalsByRole(String hostRoles) throws KrbException {
        String response;
        URL url;
        try {
            url = new URL(this.getHadminBaseURL() + "addprincipalsbyrole");
        }
        catch (MalformedURLException e) {
            throw new KrbException(e.getMessage());
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", true);
        try {
            httpConn.connect();
            OutputStream out = httpConn.getOutputStream();
            out.write(hostRoles.toString().getBytes());
            out.flush();
            out.close();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            response = HasClientUtil.getResponse(httpConn);
        }
        catch (Exception e) {
            throw new KrbException(e.getMessage());
        }
        return this.convertJsonStringToList(response);
    }

    public void setEnableOfConf(String isEnable) throws KrbException {
        URL url;
        try {
            url = new URL(this.getHadminBaseURL() + "setconf?isEnable=" + isEnable);
        }
        catch (MalformedURLException e) {
            throw new KrbException(e.getMessage());
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", true);
        try {
            String s2;
            httpConn.connect();
            InputStream inputStream = httpConn.getResponseCode() == 200 ? httpConn.getInputStream() : httpConn.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder result = new StringBuilder();
            while ((s2 = reader.readLine()) != null) {
                result.append(s2);
            }
            if (httpConn.getResponseCode() == 200) {
                System.out.println(result);
            } else {
                System.err.println(result);
            }
        }
        catch (Exception e) {
            LOG.error("Fail to connect to server. " + e);
            throw new KrbException(e.getMessage());
        }
    }

    public File getKeytabByHostAndRole(String host, String role) throws KrbException {
        URL url;
        String keytabName = host + ".zip";
        String request = this.getHadminBaseURL() + "exportKeytabsbyrole?host=" + host;
        if (!role.equals("")) {
            request = request + "&role=" + role;
            keytabName = role + "-" + host + ".keytab";
        }
        try {
            url = new URL(request);
        }
        catch (MalformedURLException e) {
            throw new KrbException(e.getMessage());
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", true);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            try (FileOutputStream fos = new FileOutputStream(new File(keytabName));
                 InputStream in = httpConn.getInputStream();){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new KrbException(e.getMessage());
        }
        System.out.println("Accept keytab file \"" + keytabName + "\" from server.");
        return new File(keytabName);
    }

    public String getHostRoles() throws KrbException {
        String response;
        URL url;
        try {
            url = new URL(this.getHadminBaseURL() + "hostroles");
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", true);
        try {
            httpConn.setDoInput(true);
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            response = HasClientUtil.getResponse(httpConn);
        }
        catch (IOException e) {
            LOG.error("IO error occurred." + e.getMessage());
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
        return response;
    }

    public String getPrincipal(String principalName) throws KrbException {
        String response;
        URL url;
        try {
            url = new URL(this.getKadminBaseURL() + "getprincipal?principal=" + principalName);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "POST", true);
        try {
            httpConn.setDoInput(true);
            httpConn.connect();
            OutputStream out = httpConn.getOutputStream();
            out.write(principalName.getBytes());
            out.flush();
            out.close();
            if (httpConn.getResponseCode() != 200) {
                LOG.info(HasClientUtil.getResponse(httpConn));
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            response = HasClientUtil.getResponse(httpConn);
            LOG.info(response);
        }
        catch (IOException e) {
            LOG.error("IO error occurred.", (Throwable)e);
            throw new KrbException("IO error occurred.", (Throwable)e);
        }
        return response;
    }
}

