/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.util;

import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class Serialize {
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;

    private Serialize() {
    }

    public static int serialize(int value, byte[] buffer, int pos) {
        if (buffer.length - pos < 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        buffer[pos++] = (byte)(value >>> 24 & 0xFF);
        buffer[pos++] = (byte)(value >>> 16 & 0xFF);
        buffer[pos++] = (byte)(value >>> 8 & 0xFF);
        buffer[pos++] = (byte)(value >>> 0 & 0xFF);
        return pos;
    }

    public static int serialize(byte[] value, byte[] buffer, int pos) {
        if (buffer.length - pos < 4 + value.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        buffer[pos++] = (byte)(value.length >>> 24 & 0xFF);
        buffer[pos++] = (byte)(value.length >>> 16 & 0xFF);
        buffer[pos++] = (byte)(value.length >>> 8 & 0xFF);
        buffer[pos++] = (byte)(value.length >>> 0 & 0xFF);
        System.arraycopy(value, 0, buffer, pos, value.length);
        return pos + value.length;
    }

    public static int deserializeInt(byte[] buffer, int pos) {
        if (buffer.length - pos < 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (buffer[pos] << 24) + (buffer[pos + 1] << 16) + (buffer[pos + 2] << 8) + buffer[pos + 3];
    }

    public static byte[] deserializeBytes(byte[] buffer, int pos) {
        if (buffer.length - pos < 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int len = Serialize.deserializeInt(buffer, pos);
        pos += 4;
        if (len > 0) {
            if (buffer.length - pos < len) {
                throw new ArrayIndexOutOfBoundsException();
            }
            byte[] result = new byte[len];
            System.arraycopy(buffer, pos, result, 0, len);
            return result;
        }
        return Strings.EMPTY_BYTES;
    }

    public static boolean deserializeBoolean(byte[] buffer, int pos) {
        if (buffer.length - pos < 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte value = buffer[pos];
        return value != 0;
    }
}

