/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.util.ComponentsMonitor;

public abstract class AbstractSimpleComponentsMonitor
implements ComponentsMonitor {
    private List<String> components;

    public AbstractSimpleComponentsMonitor(String[] components) {
        this.components = new LinkedList<String>(Arrays.asList(components));
    }

    @Override
    public ComponentsMonitor useComponent(String component) {
        if (!this.components.remove(component)) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_17026_UNREGISTRED_COMPONENT, component));
        }
        return this;
    }

    @Override
    public boolean allComponentsUsed() {
        return this.components.isEmpty();
    }

    @Override
    public List<String> getRemainingComponents() {
        return Collections.unmodifiableList(this.components);
    }
}

