/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;

public final class CsnSidSyntaxChecker
extends SyntaxChecker {
    public static final CsnSidSyntaxChecker INSTANCE = new CsnSidSyntaxChecker("1.3.6.1.4.1.4203.666.11.2.4");

    private CsnSidSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        if (!(value instanceof String)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        String sidStr = (String)value;
        if (sidStr.length() > 3) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        try {
            int sid = Integer.parseInt(sidStr, 16);
            if (sid < 0 || sid > 4095) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
                }
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
        }
        return true;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<CsnSidSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.4203.666.11.2.4");
        }

        @Override
        public CsnSidSyntaxChecker build() {
            return new CsnSidSyntaxChecker(this.oid);
        }
    }
}

