/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper;

import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers.OctetStringSyntaxChecker;

public final class LdapSyntaxHelper {
    private LdapSyntaxHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(LdapSyntax ldapSyntax, SchemaErrorHandler errorHandler, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                ldapSyntax.unlock();
                SyntaxChecker syntaxChecker = null;
                try {
                    syntaxChecker = (SyntaxChecker)registries.getSyntaxCheckerRegistry().lookup(ldapSyntax.getOid());
                }
                catch (LdapException ne) {
                    syntaxChecker = (SyntaxChecker)OctetStringSyntaxChecker.builder().setOid(ldapSyntax.getOid()).build();
                }
                if (syntaxChecker != null) {
                    registries.addReference(ldapSyntax, syntaxChecker);
                    ldapSyntax.setSyntaxChecker(syntaxChecker);
                }
            }
            finally {
                ldapSyntax.lock();
            }
        }
    }

    public static void removeFromRegistries(LdapSyntax ldapSyntax, SchemaErrorHandler errorHandler, Registries registries) {
        if (registries != null && ldapSyntax.getSyntaxChecker() != null) {
            registries.delReference(ldapSyntax, ldapSyntax.getSyntaxChecker());
        }
    }
}

