/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapProtocolErrorException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaObjectWrapper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultAttributeTypeRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultComparatorRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultDitContentRuleRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultDitStructureRuleRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultLdapSyntaxRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultMatchingRuleRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultMatchingRuleUseRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultNameFormRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultNormalizerRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultObjectClassRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DefaultSyntaxCheckerRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DitContentRuleRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.DitStructureRuleRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.LdapSyntaxRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.MatchingRuleRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.MatchingRuleUseRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.NameFormRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.SchemaLoaderListener;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.SyntaxCheckerRegistry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.AttributeTypeHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.DitContentRuleHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.DitStructureRuleHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.LdapSyntaxHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.MatchingRuleHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.MatchingRuleUseHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.NameFormHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper.ObjectClassHelper;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registries
implements SchemaLoaderListener,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Registries.class);
    protected Map<String, Schema> loadedSchemas = new HashMap<String, Schema>();
    protected DefaultAttributeTypeRegistry attributeTypeRegistry;
    protected DefaultObjectClassRegistry objectClassRegistry;
    protected DefaultComparatorRegistry comparatorRegistry;
    protected DefaultDitContentRuleRegistry ditContentRuleRegistry;
    protected DefaultDitStructureRuleRegistry ditStructureRuleRegistry;
    protected DefaultMatchingRuleRegistry matchingRuleRegistry;
    protected DefaultMatchingRuleUseRegistry matchingRuleUseRegistry;
    protected DefaultNameFormRegistry nameFormRegistry;
    protected DefaultNormalizerRegistry normalizerRegistry;
    protected OidRegistry<SchemaObject> globalOidRegistry = new OidRegistry();
    protected DefaultSyntaxCheckerRegistry syntaxCheckerRegistry;
    protected DefaultLdapSyntaxRegistry ldapSyntaxRegistry;
    private Map<String, Set<SchemaObjectWrapper>> schemaObjects;
    private boolean isRelaxed = false;
    private boolean disabledAccepted = false;
    private SchemaErrorHandler errorHandler;
    public static final boolean STRICT = false;
    public static final boolean RELAXED = true;
    protected Map<SchemaObjectWrapper, Set<SchemaObjectWrapper>> usedBy;
    protected Map<SchemaObjectWrapper, Set<SchemaObjectWrapper>> using;

    public Registries() {
        this.attributeTypeRegistry = new DefaultAttributeTypeRegistry();
        this.comparatorRegistry = new DefaultComparatorRegistry();
        this.ditContentRuleRegistry = new DefaultDitContentRuleRegistry();
        this.ditStructureRuleRegistry = new DefaultDitStructureRuleRegistry();
        this.ldapSyntaxRegistry = new DefaultLdapSyntaxRegistry();
        this.matchingRuleRegistry = new DefaultMatchingRuleRegistry();
        this.matchingRuleUseRegistry = new DefaultMatchingRuleUseRegistry();
        this.nameFormRegistry = new DefaultNameFormRegistry();
        this.normalizerRegistry = new DefaultNormalizerRegistry();
        this.objectClassRegistry = new DefaultObjectClassRegistry();
        this.syntaxCheckerRegistry = new DefaultSyntaxCheckerRegistry();
        this.schemaObjects = new HashMap<String, Set<SchemaObjectWrapper>>();
        this.usedBy = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
        this.using = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
    }

    public AttributeTypeRegistry getAttributeTypeRegistry() {
        return this.attributeTypeRegistry;
    }

    public ComparatorRegistry getComparatorRegistry() {
        return this.comparatorRegistry;
    }

    public DitContentRuleRegistry getDitContentRuleRegistry() {
        return this.ditContentRuleRegistry;
    }

    public DitStructureRuleRegistry getDitStructureRuleRegistry() {
        return this.ditStructureRuleRegistry;
    }

    public MatchingRuleRegistry getMatchingRuleRegistry() {
        return this.matchingRuleRegistry;
    }

    public MatchingRuleUseRegistry getMatchingRuleUseRegistry() {
        return this.matchingRuleUseRegistry;
    }

    public NameFormRegistry getNameFormRegistry() {
        return this.nameFormRegistry;
    }

    public NormalizerRegistry getNormalizerRegistry() {
        return this.normalizerRegistry;
    }

    public ObjectClassRegistry getObjectClassRegistry() {
        return this.objectClassRegistry;
    }

    public OidRegistry<SchemaObject> getGlobalOidRegistry() {
        return this.globalOidRegistry;
    }

    public SyntaxCheckerRegistry getSyntaxCheckerRegistry() {
        return this.syntaxCheckerRegistry;
    }

    public LdapSyntaxRegistry getLdapSyntaxRegistry() {
        return this.ldapSyntaxRegistry;
    }

    public String getOid(String name) {
        try {
            AttributeType attributeType = this.attributeTypeRegistry.lookup(name);
            if (attributeType != null) {
                return attributeType.getOid();
            }
        }
        catch (LdapException attributeType) {
            // empty catch block
        }
        try {
            ObjectClass objectClass = (ObjectClass)this.objectClassRegistry.lookup(name);
            if (objectClass != null) {
                return objectClass.getOid();
            }
        }
        catch (LdapException objectClass) {
            // empty catch block
        }
        try {
            LdapSyntax ldapSyntax = (LdapSyntax)this.ldapSyntaxRegistry.lookup(name);
            if (ldapSyntax != null) {
                return ldapSyntax.getOid();
            }
        }
        catch (LdapException ldapSyntax) {
            // empty catch block
        }
        try {
            MatchingRule matchingRule = (MatchingRule)this.matchingRuleRegistry.lookup(name);
            if (matchingRule != null) {
                return matchingRule.getOid();
            }
        }
        catch (LdapException matchingRule) {
            // empty catch block
        }
        try {
            MatchingRuleUse matchingRuleUse = (MatchingRuleUse)this.matchingRuleUseRegistry.lookup(name);
            if (matchingRuleUse != null) {
                return matchingRuleUse.getOid();
            }
        }
        catch (LdapException matchingRuleUse) {
            // empty catch block
        }
        try {
            NameForm nameForm = (NameForm)this.nameFormRegistry.lookup(name);
            if (nameForm != null) {
                return nameForm.getOid();
            }
        }
        catch (LdapException nameForm) {
            // empty catch block
        }
        try {
            DitContentRule ditContentRule = (DitContentRule)this.ditContentRuleRegistry.lookup(name);
            if (ditContentRule != null) {
                return ditContentRule.getOid();
            }
        }
        catch (LdapException ditContentRule) {
            // empty catch block
        }
        try {
            DitStructureRule ditStructureRule = (DitStructureRule)this.ditStructureRuleRegistry.lookup(name);
            if (ditStructureRule != null) {
                return ditStructureRule.getOid();
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        return null;
    }

    public Schema getLoadedSchema(String schemaName) {
        return this.loadedSchemas.get(Strings.toLowerCaseAscii(schemaName));
    }

    public boolean isSchemaLoaded(String schemaName) {
        return this.loadedSchemas.containsKey(Strings.toLowerCaseAscii(schemaName));
    }

    public void checkRefInteg() {
        for (Normalizer normalizer : this.normalizerRegistry) {
            this.resolve(normalizer);
        }
        for (LdapComparator comparator : this.comparatorRegistry) {
            this.resolve(comparator);
        }
        for (SyntaxChecker syntaxChecker : this.syntaxCheckerRegistry) {
            this.resolve(syntaxChecker);
        }
        for (LdapSyntax ldapSyntax : this.ldapSyntaxRegistry) {
            this.resolve(ldapSyntax);
        }
        for (MatchingRule matchingRule : this.matchingRuleRegistry) {
            this.resolve(matchingRule);
        }
        for (AttributeType attributeType : this.attributeTypeRegistry) {
            this.resolve(attributeType);
        }
        for (ObjectClass objectClass : this.objectClassRegistry) {
            this.resolve(objectClass);
        }
    }

    public void delCrossReferences(AttributeType attributeType) {
        if (attributeType.getEquality() != null) {
            this.delReference(attributeType, attributeType.getEquality());
        }
        if (attributeType.getOrdering() != null) {
            this.delReference(attributeType, attributeType.getOrdering());
        }
        if (attributeType.getSubstring() != null) {
            this.delReference(attributeType, attributeType.getSubstring());
        }
        if (attributeType.getSyntax() != null) {
            this.delReference(attributeType, attributeType.getSyntax());
        }
        if (attributeType.getSuperior() != null) {
            this.delReference(attributeType, attributeType.getSuperior());
        }
    }

    private void buildAttributeTypeReferences() {
        for (AttributeType attributeType : this.attributeTypeRegistry) {
            if (this.getUsing(attributeType) != null && !this.getUsing(attributeType).isEmpty()) continue;
            this.buildReference(attributeType);
        }
    }

    private void buildComparatorReferences() {
        for (LdapComparator comparator : this.comparatorRegistry) {
            this.buildReference(comparator);
        }
    }

    private void buildDitContentRuleReferences() {
    }

    private void buildDitStructureRuleReferences() {
    }

    public void delCrossReferences(MatchingRule matchingRule) {
        if (matchingRule.getLdapComparator() != null) {
            this.delReference(matchingRule, matchingRule.getLdapComparator());
        }
        if (matchingRule.getNormalizer() != null) {
            this.delReference(matchingRule, matchingRule.getNormalizer());
        }
        if (matchingRule.getSyntax() != null) {
            this.delReference(matchingRule, matchingRule.getSyntax());
        }
    }

    public void buildReference(SchemaObject schemaObject) {
        try {
            switch (schemaObject.getObjectType()) {
                case ATTRIBUTE_TYPE: {
                    AttributeTypeHelper.addToRegistries((AttributeType)schemaObject, this.errorHandler, this);
                    break;
                }
                case DIT_CONTENT_RULE: {
                    DitContentRuleHelper.addToRegistries((DitContentRule)schemaObject, this.errorHandler, this);
                    break;
                }
                case DIT_STRUCTURE_RULE: {
                    DitStructureRuleHelper.addToRegistries((DitStructureRule)schemaObject, this.errorHandler, this);
                    break;
                }
                case LDAP_SYNTAX: {
                    LdapSyntaxHelper.addToRegistries((LdapSyntax)schemaObject, this.errorHandler, this);
                    break;
                }
                case MATCHING_RULE: {
                    MatchingRuleHelper.addToRegistries((MatchingRule)schemaObject, this.errorHandler, this);
                    break;
                }
                case MATCHING_RULE_USE: {
                    MatchingRuleUseHelper.addToRegistries((MatchingRuleUse)schemaObject, this.errorHandler, this);
                    break;
                }
                case NAME_FORM: {
                    NameFormHelper.addToRegistries((NameForm)schemaObject, this.errorHandler, this);
                    break;
                }
                case OBJECT_CLASS: {
                    ObjectClassHelper.addToRegistries((ObjectClass)schemaObject, this.errorHandler, this);
                    break;
                }
                case SYNTAX_CHECKER: 
                case NORMALIZER: 
                case COMPARATOR: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_13718_UNEXPECTED_SCHEMA_OBJECT_TYPE, new Object[]{schemaObject.getObjectType()}));
                }
            }
        }
        catch (LdapException ne) {
            String msg = I18n.err(I18n.ERR_13746_CANNOT_BUILD_REFERENCES, schemaObject.getName(), ne.getLocalizedMessage());
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg, ne);
            this.errorHandler.handle(LOG, msg, error);
        }
    }

    public void removeReference(SchemaObject schemaObject) {
        try {
            switch (schemaObject.getObjectType()) {
                case ATTRIBUTE_TYPE: {
                    AttributeTypeHelper.removeFromRegistries((AttributeType)schemaObject, this.errorHandler, this);
                    break;
                }
                case LDAP_SYNTAX: {
                    LdapSyntaxHelper.removeFromRegistries((LdapSyntax)schemaObject, this.errorHandler, this);
                    break;
                }
                case MATCHING_RULE: {
                    MatchingRuleHelper.removeFromRegistries((MatchingRule)schemaObject, this.errorHandler, this);
                    break;
                }
                case OBJECT_CLASS: {
                    ObjectClassHelper.removeFromRegistries((ObjectClass)schemaObject, this.errorHandler, this);
                    break;
                }
                case DIT_CONTENT_RULE: {
                    break;
                }
                case DIT_STRUCTURE_RULE: {
                    break;
                }
                case NAME_FORM: {
                    break;
                }
                case MATCHING_RULE_USE: {
                    break;
                }
                case SYNTAX_CHECKER: 
                case NORMALIZER: 
                case COMPARATOR: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_13718_UNEXPECTED_SCHEMA_OBJECT_TYPE, new Object[]{schemaObject.getObjectType()}));
                }
            }
        }
        catch (LdapException ne) {
            String msg = I18n.err(I18n.ERR_13747_CANNOT_REMOVE_REFERENCES, schemaObject.getName(), ne.getLocalizedMessage());
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, msg, ne);
            this.errorHandler.handle(LOG, msg, error);
        }
    }

    private void buildMatchingRuleReferences() {
        for (MatchingRule matchingRule : this.matchingRuleRegistry) {
            this.buildReference(matchingRule);
        }
    }

    private void buildMatchingRuleUseReferences() {
        for (MatchingRuleUse matchingRuleUse : this.matchingRuleUseRegistry) {
            this.buildReference(matchingRuleUse);
        }
    }

    private void buildNameFormReferences() {
    }

    private void buildNormalizerReferences() {
        for (Normalizer normalizer : this.normalizerRegistry) {
            this.buildReference(normalizer);
        }
    }

    private void buildObjectClassReferences() {
        HashSet<String> done = new HashSet<String>();
        for (ObjectClass objectClass : this.objectClassRegistry) {
            if (done.contains(objectClass.getOid())) continue;
            done.add(objectClass.getOid());
            this.buildReference(objectClass);
        }
    }

    private void buildLdapSyntaxReferences() {
        for (LdapSyntax syntax : this.ldapSyntaxRegistry) {
            this.buildReference(syntax);
        }
    }

    private void buildSyntaxCheckerReferences() {
        for (SyntaxChecker syntaxChecker : this.syntaxCheckerRegistry) {
            this.buildReference(syntaxChecker);
        }
    }

    public void buildReferences() {
        this.buildComparatorReferences();
        this.buildNormalizerReferences();
        this.buildSyntaxCheckerReferences();
        this.buildLdapSyntaxReferences();
        this.buildMatchingRuleReferences();
        this.buildAttributeTypeReferences();
        this.buildMatchingRuleUseReferences();
        this.buildObjectClassReferences();
        this.buildDitContentRuleReferences();
        this.buildNameFormReferences();
        this.buildDitStructureRuleReferences();
    }

    private void resolve(LdapSyntax syntax) {
        try {
            LdapSyntaxHelper.addToRegistries(syntax, this.errorHandler, this);
        }
        catch (LdapException e) {
            this.errorHandler.handle(LOG, e.getMessage(), e);
        }
    }

    private void resolve(Normalizer normalizer) {
    }

    private void resolve(LdapComparator<?> comparator) {
    }

    private void resolve(SyntaxChecker syntaxChecker) {
    }

    private void resolve(MatchingRule matchingRule) {
        LdapComparator<? super Object> comparator;
        String syntaxOid = matchingRule.getSyntaxOid();
        if (syntaxOid != null) {
            try {
                this.ldapSyntaxRegistry.lookup(syntaxOid);
            }
            catch (LdapException ne) {
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OID_ALREADY_REGISTERED, I18n.err(I18n.ERR_13748_MATCHING_RULE_NO_SYNTAX, matchingRule.getOid()), ne);
                ldapSchemaException.setSourceObject(matchingRule);
                this.errorHandler.handle(LOG, ldapSchemaException.getMessage(), ldapSchemaException);
            }
        } else {
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OID_ALREADY_REGISTERED, I18n.err(I18n.ERR_13748_MATCHING_RULE_NO_SYNTAX, matchingRule.getOid()));
            ldapSchemaException.setSourceObject(matchingRule);
            this.errorHandler.handle(LOG, ldapSchemaException.getMessage(), ldapSchemaException);
        }
        Normalizer normalizer = matchingRule.getNormalizer();
        if (normalizer == null) {
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13220_NO_NORMALIZER, matchingRule.getOid()));
            this.errorHandler.handle(LOG, error.getMessage(), error);
        }
        if ((comparator = matchingRule.getLdapComparator()) == null) {
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13863_MR_DOES_NOT_HAVE_A_COMP, matchingRule.getOid()));
            this.errorHandler.handle(LOG, error.getMessage(), error);
        }
    }

    private void resolveRecursive(AttributeType attributeType, Set<String> processed) {
        String substringOid;
        String orderingOid;
        String equalityOid;
        String syntaxOid;
        String superiorOid = attributeType.getSuperiorOid();
        AttributeType superior = null;
        if (superiorOid != null) {
            block20: {
                try {
                    superior = this.attributeTypeRegistry.lookup(superiorOid);
                }
                catch (LdapException ne) {
                    if (processed.contains(superiorOid)) break block20;
                    this.errorHandler.handle(LOG, ne.getMessage(), ne);
                }
            }
            if (superior != null) {
                if (!processed.contains(superiorOid)) {
                    this.resolveRecursive(superior, processed);
                    processed.add(attributeType.getOid());
                } else {
                    LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err(I18n.ERR_13749_AT_WITH_CYCLE, attributeType.getOid()));
                    this.errorHandler.handle(LOG, error.getMessage(), error);
                    return;
                }
            }
        }
        if ((syntaxOid = attributeType.getSyntaxOid()) != null) {
            try {
                this.ldapSyntaxRegistry.lookup(syntaxOid);
            }
            catch (LdapException ne) {
                this.errorHandler.handle(LOG, ne.getMessage(), ne);
            }
        } else if (superior == null) {
            LdapSchemaViolationException error = new LdapSchemaViolationException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13864_AT_DOES_NOT_HAVE_A_SUPERIOR_NOR_SYNTAX, attributeType.getOid()));
            this.errorHandler.handle(LOG, error.getMessage(), error);
        }
        if ((equalityOid = attributeType.getEqualityOid()) != null) {
            try {
                this.matchingRuleRegistry.lookup(equalityOid);
            }
            catch (LdapException ne) {
                this.errorHandler.handle(LOG, ne.getMessage(), ne);
            }
        }
        if ((orderingOid = attributeType.getOrderingOid()) != null) {
            try {
                this.matchingRuleRegistry.lookup(orderingOid);
            }
            catch (LdapException ne) {
                this.errorHandler.handle(LOG, ne.getMessage(), ne);
            }
        }
        if ((substringOid = attributeType.getSubstringOid()) != null) {
            try {
                this.matchingRuleRegistry.lookup(substringOid);
            }
            catch (LdapException ne) {
                this.errorHandler.handle(LOG, ne.getMessage(), ne);
            }
        }
    }

    private void resolve(AttributeType attributeType) {
        HashSet<String> processed = new HashSet<String>();
        processed.add(attributeType.getOid());
        this.resolveRecursive(attributeType, processed);
    }

    private List<AttributeType> getMustRecursive(List<AttributeType> musts, Set<ObjectClass> processed, ObjectClass objectClass) {
        if (objectClass != null) {
            if (processed.contains(objectClass)) {
                return null;
            }
            processed.add(objectClass);
            for (AttributeType must : objectClass.getMustAttributeTypes()) {
                musts.add(must);
            }
            for (ObjectClass superior : objectClass.getSuperiors()) {
                this.getMustRecursive(musts, processed, superior);
            }
        }
        return musts;
    }

    private void resolve(ObjectClass objectClass) {
        HashSet<String> processed = new HashSet<String>();
        processed.add(objectClass.getOid());
        this.resolveRecursive(objectClass, processed);
        List<AttributeType> musts = this.getMustRecursive(new ArrayList<AttributeType>(), new HashSet<ObjectClass>(), objectClass);
        if (musts != null) {
            for (AttributeType may : objectClass.getMayAttributeTypes()) {
                if (!musts.contains(may)) continue;
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_DUPLICATE_AT_IN_MAY_AND_MUST);
                ldapSchemaException.setSourceObject(objectClass);
                ldapSchemaException.setOtherObject(may);
                this.errorHandler.handle(LOG, ldapSchemaException.getMessage(), ldapSchemaException);
            }
        }
    }

    private void resolveRecursive(ObjectClass objectClass, Set<String> processed) {
        List<String> superiorOids = objectClass.getSuperiorOids();
        ObjectClass superior = null;
        for (String superiorOid : superiorOids) {
            block10: {
                try {
                    superior = (ObjectClass)this.objectClassRegistry.lookup(superiorOid);
                }
                catch (LdapException ne) {
                    if (processed.contains(superiorOid)) break block10;
                    LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_NONEXISTENT_SUPERIOR, (Throwable)ne);
                    ldapSchemaException.setSourceObject(objectClass);
                    ldapSchemaException.setRelatedId(superiorOid);
                    this.errorHandler.handle(LOG, ldapSchemaException.getMessage(), ldapSchemaException);
                }
            }
            if (superior == null) continue;
            if (!processed.contains(superior.getOid())) {
                this.resolveRecursive(superior, processed);
                processed.add(objectClass.getOid());
                continue;
            }
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OC_CYCLE_CLASS_HIERARCHY);
            ldapSchemaException.setSourceObject(objectClass);
            ldapSchemaException.setOtherObject(superior);
            this.errorHandler.handle(LOG, ldapSchemaException.getMessage(), ldapSchemaException);
            return;
        }
        for (String mayOid : objectClass.getMayAttributeTypeOids()) {
            try {
                this.attributeTypeRegistry.lookup(mayOid);
            }
            catch (LdapException ne) {
                this.errorHandler.handle(LOG, ne.getMessage(), ne);
            }
        }
        for (String mustOid : objectClass.getMustAttributeTypeOids()) {
            try {
                this.attributeTypeRegistry.lookup(mustOid);
            }
            catch (LdapException ne) {
                this.errorHandler.handle(LOG, ne.getMessage(), ne);
            }
        }
        ObjectClassHelper.addToRegistries(objectClass, this.errorHandler, this);
    }

    public void add(SchemaObject schemaObject, boolean check) throws LdapException {
        boolean wasRelaxed = this.isRelaxed;
        this.setRelaxed();
        this.register(schemaObject);
        this.associateWithSchema(schemaObject);
        if (check) {
            this.buildReference(schemaObject);
        }
        schemaObject.lock();
        if (check && !this.errorHandler.wasError()) {
            this.checkRefInteg();
        }
        if (!wasRelaxed) {
            this.setStrict();
        }
    }

    public void delete(SchemaObject schemaObject) throws LdapException {
        boolean wasRelaxed = this.isRelaxed;
        this.setRelaxed();
        SchemaObject removed = this.unregister(schemaObject);
        this.dissociateFromSchema(removed);
        this.removeReference(removed);
        if (!this.errorHandler.wasError()) {
            this.checkRefInteg();
        }
        if (!wasRelaxed) {
            this.setStrict();
        }
    }

    @Override
    public void schemaLoaded(Schema schema) {
        this.loadedSchemas.put(Strings.toLowerCaseAscii(schema.getSchemaName()), schema);
    }

    @Override
    public void schemaUnloaded(Schema schema) {
        this.loadedSchemas.remove(Strings.toLowerCaseAscii(schema.getSchemaName()));
    }

    public Map<String, Schema> getLoadedSchemas() {
        return Collections.unmodifiableMap(this.loadedSchemas);
    }

    public Map<String, Set<SchemaObjectWrapper>> getObjectBySchemaName() {
        return this.schemaObjects;
    }

    private String getSchemaName(SchemaObject schemaObject) {
        String schemaName = Strings.toLowerCaseAscii(schemaObject.getSchemaName());
        if (this.loadedSchemas.containsKey(schemaName)) {
            return schemaName;
        }
        return "other";
    }

    public boolean contains(SchemaObject schemaObject) {
        String schemaName = schemaObject.getSchemaName();
        Set<SchemaObjectWrapper> setSchemaObjects = this.schemaObjects.get(schemaName);
        if (setSchemaObjects == null || setSchemaObjects.isEmpty()) {
            return false;
        }
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        return setSchemaObjects.contains(wrapper);
    }

    public Set<SchemaObjectWrapper> addSchema(String schemaName) {
        HashSet<SchemaObjectWrapper> content = new HashSet<SchemaObjectWrapper>();
        this.schemaObjects.put(schemaName, content);
        return content;
    }

    private void register(SchemaObject schemaObject) throws LdapException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13720_REGISTRING, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}));
        }
        if (!(schemaObject instanceof LoadableSchemaObject) && this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_13750_REGISTERING_FAILED_ALREADY_PRESENT, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            this.errorHandler.handle(LOG, msg, error);
            return;
        }
        try {
            switch (schemaObject.getObjectType()) {
                case ATTRIBUTE_TYPE: {
                    this.attributeTypeRegistry.register((AttributeType)schemaObject);
                    break;
                }
                case COMPARATOR: {
                    this.comparatorRegistry.register((LdapComparator)schemaObject);
                    break;
                }
                case DIT_CONTENT_RULE: {
                    this.ditContentRuleRegistry.register((DitContentRule)schemaObject);
                    break;
                }
                case DIT_STRUCTURE_RULE: {
                    this.ditStructureRuleRegistry.register((DitStructureRule)schemaObject);
                    break;
                }
                case LDAP_SYNTAX: {
                    this.ldapSyntaxRegistry.register((LdapSyntax)schemaObject);
                    break;
                }
                case MATCHING_RULE: {
                    this.matchingRuleRegistry.register((MatchingRule)schemaObject);
                    break;
                }
                case MATCHING_RULE_USE: {
                    this.matchingRuleUseRegistry.register((MatchingRuleUse)schemaObject);
                    break;
                }
                case NAME_FORM: {
                    this.nameFormRegistry.register((NameForm)schemaObject);
                    break;
                }
                case NORMALIZER: {
                    this.normalizerRegistry.register((Normalizer)schemaObject);
                    break;
                }
                case OBJECT_CLASS: {
                    this.objectClassRegistry.register((ObjectClass)schemaObject);
                    break;
                }
                case SYNTAX_CHECKER: {
                    this.syntaxCheckerRegistry.register((SyntaxChecker)schemaObject);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(I18n.err(I18n.ERR_13718_UNEXPECTED_SCHEMA_OBJECT_TYPE, new Object[]{schemaObject.getObjectType()}));
                }
            }
        }
        catch (Exception e) {
            this.errorHandler.handle(LOG, e.getMessage(), e);
        }
    }

    public void associateWithSchema(SchemaObject schemaObject) {
        SchemaObjectWrapper schemaObjectWrapper;
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13720_REGISTRING, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}));
        }
        if (!(schemaObject instanceof LoadableSchemaObject) && this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_13750_REGISTERING_FAILED_ALREADY_PRESENT, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            this.errorHandler.handle(LOG, msg, error);
            return;
        }
        String schemaName = this.getSchemaName(schemaObject);
        Set<SchemaObjectWrapper> content = this.schemaObjects.get(schemaName);
        if (content == null) {
            content = new HashSet<SchemaObjectWrapper>();
            this.schemaObjects.put(Strings.toLowerCaseAscii(schemaName), content);
        }
        if (content.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
            this.errorHandler.handle(LOG, I18n.msg(I18n.MSG_13719_REGISTRING_FAILED_ALREADY_PRESENT, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}), null);
        } else {
            content.add(schemaObjectWrapper);
            if (!(schemaObject instanceof LoadableSchemaObject)) {
                try {
                    this.globalOidRegistry.register(schemaObject);
                }
                catch (LdapException ne) {
                    this.errorHandler.handle(LOG, ne.getMessage(), ne);
                    return;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13731_REGISTRED_FOR_OID, schemaObject.getName(), schemaObject.getOid()));
            }
        }
    }

    public void dissociateFromSchema(SchemaObject schemaObject) throws LdapException {
        SchemaObjectWrapper schemaObjectWrapper;
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13741_UNREGISTRING, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}));
        }
        if (!(schemaObject instanceof LoadableSchemaObject) && !this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_13751_UNREGISTERING_FAILED_NOT_PRESENT, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
            this.errorHandler.handle(LOG, msg, error);
            return;
        }
        String schemaName = this.getSchemaName(schemaObject);
        String oid = schemaObject.getOid();
        Set<SchemaObjectWrapper> content = this.schemaObjects.get(schemaName);
        if (!content.contains(schemaObjectWrapper = new SchemaObjectWrapper(schemaObject))) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg(I18n.MSG_13739_UNREGISTERED_FAILED_NOT_PRESENT, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}));
            }
        } else {
            content.remove(schemaObjectWrapper);
            if (!(schemaObject instanceof LoadableSchemaObject)) {
                try {
                    this.globalOidRegistry.unregister(oid);
                }
                catch (LdapException ne) {
                    this.errorHandler.handle(LOG, ne.getMessage(), ne);
                    return;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13737_UNREGISTERED_FOR_OID, schemaObject.getName(), schemaObject.getOid()));
            }
        }
    }

    private SchemaObject unregister(SchemaObject schemaObject) throws LdapException {
        AbstractSchemaObject unregistered;
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13741_UNREGISTRING, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}));
        }
        if (!(schemaObject instanceof LoadableSchemaObject) && !this.globalOidRegistry.contains(schemaObject.getOid())) {
            String msg = I18n.err(I18n.ERR_13751_UNREGISTERING_FAILED_NOT_PRESENT, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()});
            LOG.error(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        switch (schemaObject.getObjectType()) {
            case ATTRIBUTE_TYPE: {
                unregistered = this.attributeTypeRegistry.unregister((AttributeType)schemaObject);
                break;
            }
            case COMPARATOR: {
                unregistered = this.comparatorRegistry.unregister((LdapComparator)schemaObject);
                break;
            }
            case DIT_CONTENT_RULE: {
                unregistered = this.ditContentRuleRegistry.unregister((DitContentRule)schemaObject);
                break;
            }
            case DIT_STRUCTURE_RULE: {
                unregistered = this.ditStructureRuleRegistry.unregister((DitStructureRule)schemaObject);
                break;
            }
            case LDAP_SYNTAX: {
                unregistered = this.ldapSyntaxRegistry.unregister((LdapSyntax)schemaObject);
                break;
            }
            case MATCHING_RULE: {
                unregistered = this.matchingRuleRegistry.unregister((MatchingRule)schemaObject);
                break;
            }
            case MATCHING_RULE_USE: {
                unregistered = this.matchingRuleUseRegistry.unregister((MatchingRuleUse)schemaObject);
                break;
            }
            case NAME_FORM: {
                unregistered = this.nameFormRegistry.unregister((NameForm)schemaObject);
                break;
            }
            case NORMALIZER: {
                unregistered = this.normalizerRegistry.unregister((Normalizer)schemaObject);
                break;
            }
            case OBJECT_CLASS: {
                unregistered = this.objectClassRegistry.unregister((ObjectClass)schemaObject);
                break;
            }
            case SYNTAX_CHECKER: {
                unregistered = this.syntaxCheckerRegistry.unregister((SyntaxChecker)schemaObject);
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13718_UNEXPECTED_SCHEMA_OBJECT_TYPE, new Object[]{schemaObject.getObjectType()}));
            }
        }
        return unregistered;
    }

    public boolean isReferenced(SchemaObject schemaObject) {
        boolean referenced;
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        Set<SchemaObjectWrapper> set = this.usedBy.get(wrapper);
        boolean bl = referenced = set != null && !set.isEmpty();
        if (LOG.isDebugEnabled()) {
            if (referenced) {
                LOG.debug(I18n.msg(I18n.MSG_13735_REFERENCED, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}));
            } else {
                LOG.debug(I18n.msg(I18n.MSG_13734_NOT_REFERENCED, new Object[]{schemaObject.getObjectType(), schemaObject.getOid()}));
            }
        }
        return referenced;
    }

    public Set<SchemaObjectWrapper> getUsedBy(SchemaObject schemaObject) {
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        return this.usedBy.get(wrapper);
    }

    public String dumpUsedBy() {
        StringBuilder sb = new StringBuilder();
        sb.append("USED BY :\n");
        try {
            for (Map.Entry<SchemaObjectWrapper, Set<SchemaObjectWrapper>> entry : this.usedBy.entrySet()) {
                SchemaObjectWrapper wrapper = entry.getKey();
                sb.append((Object)wrapper.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("] : {");
                boolean isFirst = true;
                for (SchemaObjectWrapper uses : entry.getValue()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append((Object)uses.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("]");
                }
                sb.append("}\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String dumpUsing() {
        StringBuilder sb = new StringBuilder();
        sb.append("USING :\n");
        try {
            for (Map.Entry<SchemaObjectWrapper, Set<SchemaObjectWrapper>> entry : this.using.entrySet()) {
                SchemaObjectWrapper wrapper = entry.getKey();
                sb.append((Object)wrapper.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("] : {");
                boolean isFirst = true;
                for (SchemaObjectWrapper uses : entry.getValue()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append((Object)uses.get().getObjectType()).append('[').append(wrapper.get().getOid()).append("]");
                }
                sb.append("}\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public Set<SchemaObjectWrapper> getUsing(SchemaObject schemaObject) {
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(schemaObject);
        return this.using.get(wrapper);
    }

    private void addUsing(SchemaObject reference, SchemaObject referee) {
        if (reference == null || referee == null) {
            return;
        }
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(reference);
        Set<SchemaObjectWrapper> uses = this.getUsing(reference);
        if (uses == null) {
            uses = new HashSet<SchemaObjectWrapper>();
        }
        uses.add(new SchemaObjectWrapper(referee));
        this.using.put(wrapper, uses);
    }

    public void addReference(SchemaObject base, SchemaObject referenced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.dump("add", base, referenced));
        }
        this.addUsing(base, referenced);
        this.addUsedBy(referenced, base);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.dumpUsedBy());
            LOG.trace(this.dumpUsing());
        }
    }

    private void addUsedBy(SchemaObject referee, SchemaObject reference) {
        if (reference == null || referee == null) {
            return;
        }
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(referee);
        Set<SchemaObjectWrapper> uses = this.getUsedBy(referee);
        if (uses == null) {
            uses = new HashSet<SchemaObjectWrapper>();
        }
        uses.add(new SchemaObjectWrapper(reference));
        this.usedBy.put(wrapper, uses);
    }

    private void delUsing(SchemaObject reference, SchemaObject referee) {
        if (reference == null || referee == null) {
            return;
        }
        Set<SchemaObjectWrapper> uses = this.getUsing(reference);
        if (uses == null) {
            return;
        }
        uses.remove(new SchemaObjectWrapper(referee));
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(reference);
        if (uses.isEmpty()) {
            this.using.remove(wrapper);
        } else {
            this.using.put(wrapper, uses);
        }
    }

    private void delUsedBy(SchemaObject referee, SchemaObject reference) {
        if (reference == null || referee == null) {
            return;
        }
        Set<SchemaObjectWrapper> uses = this.getUsedBy(referee);
        if (uses == null) {
            return;
        }
        uses.remove(new SchemaObjectWrapper(reference));
        SchemaObjectWrapper wrapper = new SchemaObjectWrapper(referee);
        if (uses.isEmpty()) {
            this.usedBy.remove(wrapper);
        } else {
            this.usedBy.put(wrapper, uses);
        }
    }

    public void delReference(SchemaObject base, SchemaObject referenced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.dump("del", base, referenced));
        }
        this.delUsing(base, referenced);
        this.delUsedBy(referenced, base);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.dumpUsedBy());
            LOG.debug(this.dumpUsing());
        }
    }

    private String dump(String op, SchemaObject reference, SchemaObject referee) {
        return op + " : " + (Object)((Object)reference.getObjectType()) + "[" + reference.getOid() + "]/[" + (Object)((Object)referee.getObjectType()) + "[" + referee.getOid() + "]";
    }

    private boolean checkReferences(SchemaObject reference, SchemaObject referee, String message) {
        SchemaObjectWrapper referenceWrapper = new SchemaObjectWrapper(reference);
        SchemaObjectWrapper refereeWrapper = new SchemaObjectWrapper(referee);
        if (!this.using.containsKey(referenceWrapper)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13730_SYN_DOES_NOT_REFERENCE, new Object[]{reference.getObjectType(), reference.getOid(), message}));
            }
            return false;
        }
        Set<SchemaObjectWrapper> usings = this.using.get(referenceWrapper);
        if (!usings.contains(refereeWrapper)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13732_NOT_REFERENCE_ANY, new Object[]{reference.getObjectType(), reference.getOid(), message}));
            }
            return false;
        }
        if (!this.usedBy.containsKey(refereeWrapper)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13733_NOT_REFERENCED_BY_ANY, new Object[]{referee.getObjectType(), referee.getOid(), message}));
            }
            return false;
        }
        Set<SchemaObjectWrapper> used = this.usedBy.get(refereeWrapper);
        if (!used.contains(referenceWrapper)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13733_NOT_REFERENCED_BY_ANY, new Object[]{referee.getObjectType(), referee.getOid(), message}));
            }
            return false;
        }
        return true;
    }

    public boolean check() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13717_CHECKING_SYNTAXES, new Object[0]));
        }
        for (LdapSyntax syntax : this.ldapSyntaxRegistry) {
            if (syntax.getSyntaxChecker() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13729_SYN_WITH_NO_SYNTAX_CHECKER, syntax));
                }
                return false;
            }
            if (!this.syntaxCheckerRegistry.contains(syntax.getSyntaxChecker().getOid())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13713_CANT_FIND_SC_FOR_SYN, syntax.getSyntaxChecker().getOid(), syntax));
                }
                return false;
            }
            if (this.checkReferences(syntax, syntax.getSyntaxChecker(), "SyntaxChecker")) continue;
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13715_CHECKING_MATCHING_RULES, new Object[0]));
        }
        for (MatchingRule matchingRule : this.matchingRuleRegistry) {
            if (matchingRule.getNormalizer() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13727_MR_WITH_NO_NORMALIZER, matchingRule));
                }
                return false;
            }
            if (!this.normalizerRegistry.contains(matchingRule.getNormalizer().getOid())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13709_CANT_FIND_NORM_FOR_MR, matchingRule.getNormalizer().getOid(), matchingRule));
                }
                return false;
            }
            if (matchingRule.getLdapComparator() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13726_MR_WITH_NO_COMPARATOR, matchingRule));
                }
                return false;
            }
            if (!this.comparatorRegistry.contains(matchingRule.getLdapComparator().getOid())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13707_CANT_FIND_AT_FOR_MR, matchingRule.getLdapComparator().getOid(), matchingRule));
                }
                return false;
            }
            if (matchingRule.getSyntax() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13728_MR_WITH_NO_SYNTAX, matchingRule));
                }
                return false;
            }
            if (!this.ldapSyntaxRegistry.contains(matchingRule.getSyntax().getOid())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13712_CANT_FIND_SYN_FOR_MR, matchingRule.getSyntax().getOid(), matchingRule));
                }
                return false;
            }
            if (!this.checkReferences(matchingRule, matchingRule.getSyntax(), "Syntax")) {
                return false;
            }
            if (!this.checkReferences(matchingRule, matchingRule.getNormalizer(), "Normalizer")) {
                return false;
            }
            if (this.checkReferences(matchingRule, matchingRule.getLdapComparator(), "Comparator")) continue;
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13716_CHECKING_OBJECT_CLASSES, new Object[0]));
        }
        for (ObjectClass objectClass : this.objectClassRegistry) {
            if (objectClass.getMayAttributeTypes() != null) {
                for (AttributeType may : objectClass.getMayAttributeTypes()) {
                    if (!this.attributeTypeRegistry.contains(may.getOid())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(I18n.msg(I18n.MSG_13705_CANT_FIND_AT_IN_MAY, may, objectClass));
                        }
                        return false;
                    }
                    if (this.checkReferences(objectClass, may, "AttributeType")) continue;
                    return false;
                }
            }
            if (objectClass.getMustAttributeTypes() != null) {
                for (AttributeType must : objectClass.getMustAttributeTypes()) {
                    if (!this.attributeTypeRegistry.contains(must.getOid())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(I18n.msg(I18n.MSG_13706_CANT_FIND_AT_IN_MUST, must, objectClass));
                        }
                        return false;
                    }
                    if (this.checkReferences(objectClass, must, "AttributeType")) continue;
                    return false;
                }
            }
            if (objectClass.getSuperiors() == null) continue;
            for (ObjectClass superior : objectClass.getSuperiors()) {
                if (!this.objectClassRegistry.contains(objectClass.getOid())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_13710_CANT_FIND_OC_WITH_SUPERIOR, superior, objectClass));
                    }
                    return false;
                }
                if (this.checkReferences(objectClass, superior, "ObjectClass")) continue;
                return false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_13714_CHECKING_ATTRIBUTE_TYPES, new Object[0]));
        }
        for (AttributeType attributeType : this.attributeTypeRegistry) {
            if (attributeType.getSyntax() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13725_AT_WITH_NO_SYNTAX, attributeType));
                }
                return false;
            }
            if (!this.ldapSyntaxRegistry.contains(attributeType.getSyntax().getOid())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13711_CANT_FIND_SYN_FOR_AT, attributeType.getSyntax().getOid(), attributeType));
                }
                return false;
            }
            if (!this.checkReferences(attributeType, attributeType.getSyntax(), "AttributeType")) {
                return false;
            }
            if (attributeType.getEquality() != null) {
                if (!this.matchingRuleRegistry.contains(attributeType.getEquality().getOid())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_13708_CANT_FIND_MR_FOR_AT, attributeType.getEquality().getOid(), attributeType));
                    }
                    return false;
                }
                if (!this.checkReferences(attributeType, attributeType.getEquality(), "AttributeType")) {
                    return false;
                }
            }
            if (attributeType.getOrdering() != null) {
                if (!this.matchingRuleRegistry.contains(attributeType.getOrdering().getOid())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_13708_CANT_FIND_MR_FOR_AT, attributeType.getOrdering().getOid(), attributeType));
                    }
                    return false;
                }
                if (!this.checkReferences(attributeType, attributeType.getOrdering(), "AttributeType")) {
                    return false;
                }
            }
            if (attributeType.getSubstring() != null) {
                if (!this.matchingRuleRegistry.contains(attributeType.getSubstring().getOid())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_13708_CANT_FIND_MR_FOR_AT, attributeType.getSubstring().getOid(), attributeType));
                    }
                    return false;
                }
                if (!this.checkReferences(attributeType, attributeType.getSubstring(), "AttributeType")) {
                    return false;
                }
            }
            if (attributeType.getSuperior() == null) continue;
            AttributeType superior = attributeType.getSuperior();
            if (!this.attributeTypeRegistry.contains(superior.getOid())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_13704_CANT_FIND_AT_WITH_SUPERIOR, superior, attributeType));
                }
                return false;
            }
            if (this.checkReferences(attributeType, superior, "AttributeType")) continue;
            return false;
        }
        return true;
    }

    public Registries clone() throws CloneNotSupportedException {
        Registries clone = (Registries)super.clone();
        clone.globalOidRegistry = this.globalOidRegistry.copy();
        clone.attributeTypeRegistry = this.attributeTypeRegistry.copy();
        clone.comparatorRegistry = this.comparatorRegistry.copy();
        clone.ditContentRuleRegistry = this.ditContentRuleRegistry.copy();
        clone.ditStructureRuleRegistry = this.ditStructureRuleRegistry.copy();
        clone.ldapSyntaxRegistry = this.ldapSyntaxRegistry.copy();
        clone.matchingRuleRegistry = this.matchingRuleRegistry.copy();
        clone.matchingRuleUseRegistry = this.matchingRuleUseRegistry.copy();
        clone.nameFormRegistry = this.nameFormRegistry.copy();
        clone.normalizerRegistry = this.normalizerRegistry.copy();
        clone.objectClassRegistry = this.objectClassRegistry.copy();
        clone.syntaxCheckerRegistry = this.syntaxCheckerRegistry.copy();
        clone.errorHandler = this.errorHandler;
        for (AttributeType attributeType : clone.attributeTypeRegistry) {
            clone.globalOidRegistry.put(attributeType);
        }
        for (DitContentRule ditContentRule : clone.ditContentRuleRegistry) {
            clone.globalOidRegistry.put(ditContentRule);
        }
        for (DitStructureRule ditStructureRule : clone.ditStructureRuleRegistry) {
            clone.globalOidRegistry.put(ditStructureRule);
        }
        for (MatchingRule matchingRule : clone.matchingRuleRegistry) {
            clone.globalOidRegistry.put(matchingRule);
        }
        for (MatchingRuleUse matchingRuleUse : clone.matchingRuleUseRegistry) {
            clone.globalOidRegistry.put(matchingRuleUse);
        }
        for (NameForm nameForm : clone.nameFormRegistry) {
            clone.globalOidRegistry.put(nameForm);
        }
        for (ObjectClass objectClass : clone.objectClassRegistry) {
            clone.globalOidRegistry.put(objectClass);
        }
        for (LdapSyntax ldapSyntax : clone.ldapSyntaxRegistry) {
            clone.globalOidRegistry.put(ldapSyntax);
        }
        clone.loadedSchemas = new HashMap<String, Schema>();
        for (Map.Entry entry : this.schemaObjects.entrySet()) {
            clone.loadedSchemas.put((String)entry.getKey(), this.loadedSchemas.get(entry.getKey()));
        }
        clone.using = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
        clone.usedBy = new HashMap<SchemaObjectWrapper, Set<SchemaObjectWrapper>>();
        clone.buildReferences();
        clone.checkRefInteg();
        clone.schemaObjects = new HashMap<String, Set<SchemaObjectWrapper>>();
        for (Map.Entry entry : this.schemaObjects.entrySet()) {
            HashSet<SchemaObjectWrapper> objects = new HashSet<SchemaObjectWrapper>();
            for (SchemaObjectWrapper schemaObjectWrapper : (Set)entry.getValue()) {
                SchemaObject original = schemaObjectWrapper.get();
                try {
                    if (!(original instanceof LoadableSchemaObject)) {
                        SchemaObject copy = clone.globalOidRegistry.getSchemaObject(original.getOid());
                        SchemaObjectWrapper newWrapper = new SchemaObjectWrapper(copy);
                        objects.add(newWrapper);
                        continue;
                    }
                    SchemaObjectWrapper newWrapper = new SchemaObjectWrapper(original);
                    objects.add(newWrapper);
                }
                catch (LdapException ldapException) {}
            }
            clone.schemaObjects.put((String)entry.getKey(), (Set<SchemaObjectWrapper>)objects);
        }
        return clone;
    }

    public boolean isRelaxed() {
        return this.isRelaxed;
    }

    public boolean isStrict() {
        return !this.isRelaxed;
    }

    public void setRelaxed() {
        this.isRelaxed = true;
        this.globalOidRegistry.setRelaxed();
        this.attributeTypeRegistry.setRelaxed();
        this.comparatorRegistry.setRelaxed();
        this.ditContentRuleRegistry.setRelaxed();
        this.ditStructureRuleRegistry.setRelaxed();
        this.ldapSyntaxRegistry.setRelaxed();
        this.matchingRuleRegistry.setRelaxed();
        this.matchingRuleUseRegistry.setRelaxed();
        this.nameFormRegistry.setRelaxed();
        this.normalizerRegistry.setRelaxed();
        this.objectClassRegistry.setRelaxed();
        this.syntaxCheckerRegistry.setRelaxed();
    }

    public void setStrict() {
        this.isRelaxed = false;
        this.globalOidRegistry.setStrict();
        this.attributeTypeRegistry.setStrict();
        this.comparatorRegistry.setStrict();
        this.ditContentRuleRegistry.setStrict();
        this.ditStructureRuleRegistry.setStrict();
        this.ldapSyntaxRegistry.setStrict();
        this.matchingRuleRegistry.setStrict();
        this.matchingRuleUseRegistry.setStrict();
        this.nameFormRegistry.setStrict();
        this.normalizerRegistry.setStrict();
        this.objectClassRegistry.setStrict();
        this.syntaxCheckerRegistry.setStrict();
    }

    public SchemaErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SchemaErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.globalOidRegistry.setErrorHandler(errorHandler);
        this.attributeTypeRegistry.setErrorHandler(errorHandler);
        this.comparatorRegistry.setErrorHandler(errorHandler);
        this.ditContentRuleRegistry.setErrorHandler(errorHandler);
        this.ditStructureRuleRegistry.setErrorHandler(errorHandler);
        this.ldapSyntaxRegistry.setErrorHandler(errorHandler);
        this.matchingRuleRegistry.setErrorHandler(errorHandler);
        this.matchingRuleUseRegistry.setErrorHandler(errorHandler);
        this.nameFormRegistry.setErrorHandler(errorHandler);
        this.normalizerRegistry.setErrorHandler(errorHandler);
        this.objectClassRegistry.setErrorHandler(errorHandler);
        this.syntaxCheckerRegistry.setErrorHandler(errorHandler);
    }

    public boolean isDisabledAccepted() {
        return this.disabledAccepted;
    }

    public Set<SchemaObjectWrapper> getReferencing(SchemaObject schemaObject) {
        SchemaObjectWrapper schemaObjectWrapper = new SchemaObjectWrapper(schemaObject);
        return this.usedBy.get(schemaObjectWrapper);
    }

    public void setDisabledAccepted(boolean disabledAccepted) {
        this.disabledAccepted = disabledAccepted;
    }

    public void clear() throws LdapException {
        if (this.attributeTypeRegistry != null) {
            this.attributeTypeRegistry.clear();
        }
        if (this.comparatorRegistry != null) {
            this.comparatorRegistry.clear();
        }
        if (this.ditContentRuleRegistry != null) {
            this.ditContentRuleRegistry.clear();
        }
        if (this.ditStructureRuleRegistry != null) {
            this.ditStructureRuleRegistry.clear();
        }
        if (this.matchingRuleRegistry != null) {
            this.matchingRuleRegistry.clear();
        }
        if (this.matchingRuleUseRegistry != null) {
            this.matchingRuleUseRegistry.clear();
        }
        if (this.nameFormRegistry != null) {
            this.nameFormRegistry.clear();
        }
        if (this.normalizerRegistry != null) {
            this.normalizerRegistry.clear();
        }
        if (this.objectClassRegistry != null) {
            this.objectClassRegistry.clear();
        }
        if (this.ldapSyntaxRegistry != null) {
            this.ldapSyntaxRegistry.clear();
        }
        if (this.syntaxCheckerRegistry != null) {
            this.syntaxCheckerRegistry.clear();
        }
        for (Map.Entry<String, Set<SchemaObjectWrapper>> entry : this.schemaObjects.entrySet()) {
            entry.getValue().clear();
        }
        this.schemaObjects.clear();
        for (Map.Entry<Object, Set<SchemaObjectWrapper>> entry : this.usedBy.entrySet()) {
            entry.getValue().clear();
        }
        this.usedBy.clear();
        for (Map.Entry<Object, Set<SchemaObjectWrapper>> entry : this.using.entrySet()) {
            entry.getValue().clear();
        }
        this.using.clear();
        this.globalOidRegistry.clear();
        this.loadedSchemas.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Registries [");
        if (this.isRelaxed) {
            sb.append("RELAXED,");
        } else {
            sb.append("STRICT,");
        }
        if (this.disabledAccepted) {
            sb.append(" Disabled accepted] :\n");
        } else {
            sb.append(" Disabled forbidden] :\n");
        }
        sb.append("loaded schemas [");
        boolean isFirst = true;
        for (String schema : this.loadedSchemas.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(schema);
        }
        sb.append("]\n");
        sb.append("AttributeTypes : ").append(this.attributeTypeRegistry.size()).append("\n");
        sb.append("Comparators : ").append(this.comparatorRegistry.size()).append("\n");
        sb.append("DitContentRules : ").append(this.ditContentRuleRegistry.size()).append("\n");
        sb.append("DitStructureRules : ").append(this.ditStructureRuleRegistry.size()).append("\n");
        sb.append("MatchingRules : ").append(this.matchingRuleRegistry.size()).append("\n");
        sb.append("MatchingRuleUses : ").append(this.matchingRuleUseRegistry.size()).append("\n");
        sb.append("NameForms : ").append(this.nameFormRegistry.size()).append("\n");
        sb.append("Normalizers : ").append(this.normalizerRegistry.size()).append("\n");
        sb.append("ObjectClasses : ").append(this.objectClassRegistry.size()).append("\n");
        sb.append("Syntaxes : ").append(this.ldapSyntaxRegistry.size()).append("\n");
        sb.append("SyntaxCheckers : ").append(this.syntaxCheckerRegistry.size()).append("\n");
        sb.append("GlobalOidRegistry : ").append(this.globalOidRegistry.size()).append('\n');
        return sb.toString();
    }
}

