/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.normalizers;

import java.text.ParseException;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.PrepareString;
import org.apache.hadoop.shaded.org.apache.directory.api.util.GeneralizedTime;

public class GeneralizedTimeNormalizer
extends Normalizer {
    public GeneralizedTimeNormalizer() {
        super("2.5.13.27");
    }

    @Override
    public String normalize(String value) throws LdapException {
        return this.normalize(value, PrepareString.AssertionType.ATTRIBUTE_VALUE);
    }

    @Override
    public String normalize(String value, PrepareString.AssertionType assertionType) throws LdapException {
        if (value == null) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13724_INVALID_VALUE, value));
        }
        if ("000001010000Z".equals(value)) {
            return value;
        }
        try {
            GeneralizedTime time = new GeneralizedTime(value);
            return time.toGeneralizedTime(GeneralizedTime.Format.YEAR_MONTH_DAY_HOUR_MIN_SEC_FRACTION, GeneralizedTime.FractionDelimiter.DOT, 3, GeneralizedTime.TimeZoneFormat.Z);
        }
        catch (ParseException pe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13724_INVALID_VALUE, value), pe);
        }
    }
}

