/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.controls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.controls.SortRequest;

public class SortRequestImpl
extends AbstractControl
implements SortRequest {
    private List<SortKey> sortKeys;

    public SortRequestImpl() {
        super("1.2.840.113556.1.4.473");
    }

    @Override
    public List<SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public void setSortKeys(List<SortKey> sortKeys) {
        this.sortKeys = sortKeys;
    }

    @Override
    public void addSortKey(SortKey skey) {
        if (this.sortKeys == null) {
            this.sortKeys = new ArrayList<SortKey>();
        }
        this.sortKeys.add(skey);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.sortKeys != null) {
            for (SortKey sortKey : this.sortKeys) {
                hash = hash * 17 + sortKey.hashCode();
            }
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortRequest)) {
            return false;
        }
        SortRequest that = (SortRequest)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.sortKeys == null) {
            return that.getSortKeys() == null;
        }
        if (that.getSortKeys() == null || this.sortKeys.size() != that.getSortKeys().size()) {
            return false;
        }
        for (SortKey sortKey : that.getSortKeys()) {
            if (this.sortKeys.contains(sortKey)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Sort Request Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        if (this.sortKeys != null) {
            sb.append("        sortKeys : [");
            boolean isFirst = true;
            for (SortKey sortKey : this.sortKeys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(sortKey.getAttributeTypeDesc());
            }
            sb.append("]\n");
        } else {
            sb.append("        sortKeys : null\n");
        }
        return sb.toString();
    }
}

