/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;

public enum SearchScope {
    OBJECT(0, "base"),
    ONELEVEL(1, "one"),
    SUBTREE(2, "sub");

    private final int scope;
    private final String ldapUrlValue;

    private SearchScope(int scope, String ldapUrlValue) {
        this.scope = scope;
        this.ldapUrlValue = ldapUrlValue;
    }

    public String getLdapUrlValue() {
        return this.ldapUrlValue;
    }

    public int getScope() {
        return this.scope;
    }

    public static SearchScope getSearchScope(int scope) {
        switch (scope) {
            case 0: {
                return OBJECT;
            }
            case 1: {
                return ONELEVEL;
            }
            case 2: {
                return SUBTREE;
            }
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_13501_UNKNOWN_JNDI_SCOPE, scope));
    }

    public SearchScope getScope(String scope) {
        if ("base".equalsIgnoreCase(scope)) {
            return OBJECT;
        }
        if ("one".equalsIgnoreCase(scope)) {
            return ONELEVEL;
        }
        if ("sub".equalsIgnoreCase(scope)) {
            return SUBTREE;
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_13502_UNKNOWN_LDAP_URL_SCOPE, scope));
    }

    public static int getSearchScope(String scope) {
        if ("base".equalsIgnoreCase(scope)) {
            return OBJECT.getScope();
        }
        if ("one".equalsIgnoreCase(scope)) {
            return ONELEVEL.getScope();
        }
        if ("sub".equalsIgnoreCase(scope)) {
            return SUBTREE.getScope();
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_13502_UNKNOWN_LDAP_URL_SCOPE, scope));
    }

    public String toString() {
        return this.ldapUrlValue;
    }
}

