/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.ldif;

import java.io.IOException;
import javax.naming.directory.Attributes;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.AttributeUtils;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Value;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.ldif.LdifAttributesReader;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.ldif.LdifControl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.name.Dn;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Base64;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class LdifUtils {
    private static final boolean[] LDIF_SAFE_STARTING_CHAR_ALPHABET;
    private static final boolean[] LDIF_SAFE_OTHER_CHARS_ALPHABET;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static final String LINE_SEPARATOR;

    private LdifUtils() {
    }

    public static boolean isLDIFSafe(String str) {
        if (Strings.isEmpty(str)) {
            return true;
        }
        char currentChar = str.charAt(0);
        if (currentChar > '\u007f' || !LDIF_SAFE_STARTING_CHAR_ALPHABET[currentChar]) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            currentChar = str.charAt(i);
            if (currentChar <= '\u007f' && LDIF_SAFE_OTHER_CHARS_ALPHABET[currentChar]) continue;
            return false;
        }
        return currentChar != ' ';
    }

    public static String convertToLdif(Attributes attrs) throws LdapException {
        return LdifUtils.convertAttributesToLdif(AttributeUtils.toEntry(attrs, null), 80);
    }

    public static String convertToLdif(Attributes attrs, int length) throws LdapException {
        return LdifUtils.convertAttributesToLdif(AttributeUtils.toEntry(attrs, null), length);
    }

    public static String convertToLdif(Attributes attrs, Dn dn, int length) throws LdapException {
        return LdifUtils.convertToLdif(AttributeUtils.toEntry(attrs, dn), length);
    }

    public static String convertToLdif(Attributes attrs, Dn dn) throws LdapException {
        return LdifUtils.convertToLdif(AttributeUtils.toEntry(attrs, dn), 80);
    }

    public static String convertToLdif(Entry entry) {
        return LdifUtils.convertToLdif(entry, 80);
    }

    public static String convertToLdif(Entry entry, boolean includeVersionInfo) {
        String ldif = LdifUtils.convertToLdif(entry, 80);
        if (includeVersionInfo) {
            ldif = "version: 1" + LINE_SEPARATOR + ldif;
        }
        return ldif;
    }

    public static String convertAttributesToLdif(Entry entry) {
        return LdifUtils.convertAttributesToLdif(entry, 80);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Attributes getJndiAttributesFromLdif(String ldif) throws LdapLdifException {
        try (LdifAttributesReader reader = new LdifAttributesReader();){
            Attributes attributes = AttributeUtils.toAttributes(reader.parseEntry(ldif));
            return attributes;
        }
        catch (IOException ioe) {
            throw new LdapLdifException(ioe.getMessage(), ioe);
        }
    }

    public static String convertToLdif(Entry entry, int length) {
        StringBuilder sb = new StringBuilder();
        if (entry.getDn() != null) {
            if (LdifUtils.isLDIFSafe(entry.getDn().getName())) {
                sb.append(LdifUtils.stripLineToNChars("dn: " + entry.getDn().getName(), length));
            } else {
                sb.append(LdifUtils.stripLineToNChars("dn:: " + LdifUtils.encodeBase64(entry.getDn().getName()), length));
            }
            sb.append('\n');
        }
        for (Attribute attribute : entry) {
            sb.append(LdifUtils.convertToLdif(attribute, length));
        }
        return sb.toString();
    }

    public static String convertAttributesToLdif(Entry entry, int length) {
        StringBuilder sb = new StringBuilder();
        for (Attribute attribute : entry) {
            sb.append(LdifUtils.convertToLdif(attribute, length));
        }
        return sb.toString();
    }

    public static String convertToLdif(LdifEntry entry) throws LdapException {
        return LdifUtils.convertToLdif(entry, 80);
    }

    public static String convertToLdif(LdifEntry entry, int length) throws LdapException {
        StringBuilder sb = new StringBuilder();
        if (LdifUtils.isLDIFSafe(entry.getDn().getName())) {
            sb.append(LdifUtils.stripLineToNChars("dn: " + entry.getDn(), length));
        } else {
            sb.append(LdifUtils.stripLineToNChars("dn:: " + LdifUtils.encodeBase64(entry.getDn().getName()), length));
        }
        sb.append('\n');
        String changeType = Strings.toLowerCaseAscii(entry.getChangeType().toString());
        if (entry.getChangeType() != ChangeType.None) {
            if (entry.hasControls()) {
                for (LdifControl control : entry.getControls().values()) {
                    StringBuilder controlStr = new StringBuilder();
                    controlStr.append("control: ").append(control.getOid());
                    controlStr.append(" ").append(control.isCritical());
                    if (control.hasValue()) {
                        controlStr.append("::").append(Base64.encode(control.getValue()));
                    }
                    sb.append(LdifUtils.stripLineToNChars(controlStr.toString(), length));
                    sb.append('\n');
                }
            }
            sb.append(LdifUtils.stripLineToNChars("changetype: " + changeType, length));
            sb.append('\n');
        }
        switch (entry.getChangeType()) {
            case None: {
                if (entry.hasControls()) {
                    sb.append(LdifUtils.stripLineToNChars("changetype: " + (Object)((Object)ChangeType.Add), length));
                }
            }
            case Add: {
                if (entry.getEntry() == null) {
                    throw new LdapException(I18n.err(I18n.ERR_13472_ENTRY_WITH_NO_ATTRIBUTE, new Object[0]));
                }
                for (Attribute attribute : entry.getEntry()) {
                    sb.append(LdifUtils.convertToLdif(attribute, length));
                }
                break;
            }
            case Delete: {
                if (entry.getEntry() == null) break;
                throw new LdapException(I18n.err(I18n.ERR_13471_DELETED_ENTRY_WITH_ATTRIBUTES, new Object[0]));
            }
            case ModDn: 
            case ModRdn: {
                if (entry.getEntry() != null) {
                    throw new LdapException(I18n.err(I18n.ERR_13473_MODDN_WITH_ATTRIBUTES, new Object[0]));
                }
                DefaultAttribute newRdn = new DefaultAttribute("newrdn", entry.getNewRdn());
                sb.append(LdifUtils.convertToLdif(newRdn, length));
                sb.append("deleteoldrdn: ");
                if (entry.isDeleteOldRdn()) {
                    sb.append("1");
                } else {
                    sb.append("0");
                }
                sb.append('\n');
                if (Strings.isEmpty(entry.getNewSuperior())) break;
                DefaultAttribute newSuperior = new DefaultAttribute("newsuperior", entry.getNewSuperior());
                sb.append(LdifUtils.convertToLdif(newSuperior, length));
                break;
            }
            case Modify: {
                boolean isFirst = true;
                for (Modification modification : entry.getModifications()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append("-\n");
                    }
                    switch (modification.getOperation()) {
                        case ADD_ATTRIBUTE: {
                            sb.append("add: ");
                            break;
                        }
                        case REMOVE_ATTRIBUTE: {
                            sb.append("delete: ");
                            break;
                        }
                        case REPLACE_ATTRIBUTE: {
                            sb.append("replace: ");
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(I18n.err(I18n.ERR_13434_UNEXPECTED_MOD_OPERATION, new Object[]{modification.getOperation()}));
                        }
                    }
                    sb.append(modification.getAttribute().getUpId());
                    sb.append('\n');
                    sb.append(LdifUtils.convertToLdif(modification.getAttribute(), length));
                }
                sb.append('-');
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_13431_UNEXPECTED_CHANGETYPE, new Object[]{entry.getChangeType()}));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private static String encodeBase64(String str) {
        return new String(Base64.encode(Strings.getBytesUtf8(str)));
    }

    public static String convertToLdif(Attribute attr) {
        return LdifUtils.convertToLdif(attr, 80);
    }

    public static String convertToLdif(Attribute attr, int length) {
        StringBuilder sb = new StringBuilder();
        if (attr.size() == 0) {
            return "";
        }
        for (Value value : attr) {
            StringBuilder lineBuffer = new StringBuilder();
            lineBuffer.append(attr.getUpId());
            if (value.isNull()) {
                lineBuffer.append(':');
            } else if (value.isHumanReadable()) {
                String str = value.getString();
                if (!LdifUtils.isLDIFSafe(str)) {
                    lineBuffer.append(":: ").append(LdifUtils.encodeBase64(str));
                } else {
                    lineBuffer.append(':');
                    if (str != null) {
                        lineBuffer.append(' ').append(str);
                    }
                }
            } else {
                char[] encoded = Base64.encode(value.getBytes());
                lineBuffer.append(":: " + new String(encoded));
            }
            lineBuffer.append('\n');
            sb.append(LdifUtils.stripLineToNChars(lineBuffer.toString(), length));
        }
        return sb.toString();
    }

    public static String stripLineToNChars(String str, int nbChars) {
        int strLength = str.length();
        if (strLength <= nbChars) {
            return str;
        }
        if (nbChars < 2) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13474_LINE_LENGTH_TOO_SHORT, new Object[0]));
        }
        int charsPerLine = nbChars - 1;
        int remaining = (strLength - nbChars) % charsPerLine;
        int nbLines = 1 + (strLength - nbChars) / charsPerLine + (remaining == 0 ? 0 : 1);
        int nbCharsTotal = strLength + nbLines + nbLines - 2;
        char[] buffer = new char[nbCharsTotal];
        char[] orig = str.toCharArray();
        int posSrc = 0;
        int posDst = 0;
        System.arraycopy(orig, posSrc, buffer, posDst, nbChars);
        posSrc += nbChars;
        posDst += nbChars;
        for (int i = 0; i < nbLines - 2; ++i) {
            buffer[posDst++] = 10;
            buffer[posDst++] = 32;
            System.arraycopy(orig, posSrc, buffer, posDst, charsPerLine);
            posSrc += charsPerLine;
            posDst += charsPerLine;
        }
        buffer[posDst++] = 10;
        buffer[posDst++] = 32;
        System.arraycopy(orig, posSrc, buffer, posDst, remaining == 0 ? charsPerLine : remaining);
        return new String(buffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Attributes createJndiAttributes(Object ... avas) throws LdapException {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        boolean valueExpected = false;
        for (Object ava : avas) {
            if (!valueExpected) {
                if (!(ava instanceof String)) {
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13233_ATTRIBUTE_ID_MUST_BE_A_STRING, pos + 1));
                }
                String attribute = (String)ava;
                sb.append(attribute);
                if (attribute.indexOf(58) != -1) {
                    sb.append('\n');
                    continue;
                }
                valueExpected = true;
                continue;
            }
            if (ava instanceof String) {
                sb.append(": ").append((String)ava).append('\n');
            } else {
                if (!(ava instanceof byte[])) {
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13234_ATTRIBUTE_VAL_STRING_OR_BYTE, pos + 1));
                }
                sb.append(":: ");
                sb.append(new String(Base64.encode((byte[])ava)));
                sb.append('\n');
            }
            valueExpected = false;
        }
        if (valueExpected) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_13234_ATTRIBUTE_VAL_STRING_OR_BYTE, new Object[0]));
        }
        try (LdifAttributesReader reader = new LdifAttributesReader();){
            Attributes attributes = AttributeUtils.toAttributes(reader.parseEntry(sb.toString()));
            return attributes;
        }
        catch (IOException ioe) {
            throw new LdapLdifException(ioe.getMessage(), ioe);
        }
    }

    static {
        int i;
        LDIF_SAFE_STARTING_CHAR_ALPHABET = new boolean[128];
        LDIF_SAFE_OTHER_CHARS_ALPHABET = new boolean[128];
        LINE_SEPARATOR = System.getProperty("line.separator");
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[13] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[32] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[58] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[60] = false;
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[13] = false;
    }
}

