/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.cursor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.cursor.ClosureMonitor;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.cursor.CursorClosedException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.cursor.CursorIterator;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.cursor.DefaultClosureMonitor;

public abstract class AbstractCursor<E>
implements Cursor<E> {
    private ClosureMonitor monitor = new DefaultClosureMonitor();

    @Override
    public void setClosureMonitor(ClosureMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_13101_MONITOR, new Object[0]));
        }
        this.monitor = monitor;
    }

    public final void checkNotClosed() throws CursorClosedException {
        this.monitor.checkNotClosed();
    }

    @Override
    public boolean isClosed() {
        return this.monitor.isClosed();
    }

    @Override
    public void close(Exception cause) throws IOException {
        this.monitor.close(cause);
    }

    @Override
    public void close() throws IOException {
        this.monitor.close();
    }

    @Override
    public Iterator<E> iterator() {
        return new CursorIterator(this);
    }

    @Override
    public boolean isAfterLast() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isAfterLast()")));
    }

    @Override
    public boolean isBeforeFirst() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isBeforeFirst()")));
    }

    @Override
    public boolean isFirst() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isFirst()")));
    }

    @Override
    public boolean isLast() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13102_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isLast()")));
    }

    @Override
    public String toString(String tabs) {
        return tabs;
    }
}

