/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.csn;

import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.csn.Csn;

public class CsnFactory {
    private static volatile long lastTimestamp;
    private int changeCount = 0;
    private int replicaId;
    private static final int PURGE_INSTANCEID = 4095;
    private Object lock = new Object();

    public CsnFactory(int replicaId) {
        this.replicaId = replicaId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Csn newInstance() {
        int tmpChangeCount;
        Object object = this.lock;
        synchronized (object) {
            long newTimestamp = System.currentTimeMillis();
            if (lastTimestamp == newTimestamp) {
                ++this.changeCount;
            } else {
                lastTimestamp = newTimestamp;
                this.changeCount = 0;
            }
            tmpChangeCount = this.changeCount;
        }
        return new Csn(lastTimestamp, tmpChangeCount, this.replicaId, 0);
    }

    public Csn newInstance(long timestamp, int changeCount) {
        return new Csn(timestamp, changeCount, this.replicaId, 0);
    }

    public Csn newPurgeCsn(long expirationDate) {
        return new Csn(expirationDate, Integer.MAX_VALUE, 4095, Integer.MAX_VALUE);
    }

    public void setReplicaId(int replicaId) {
        this.replicaId = replicaId;
    }
}

