/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.AbstractExtendedOperationFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureRequestContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureParameter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureRequestImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureResponseImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ExtendedRequest;

public class StoredProcedureFactory
extends AbstractExtendedOperationFactory {
    public StoredProcedureFactory(LdapApiService codec) {
        super(codec, "1.3.6.1.4.1.18060.0.1.6");
    }

    @Override
    public StoredProcedureRequest newRequest() {
        return new StoredProcedureRequestImpl();
    }

    @Override
    public StoredProcedureRequest newRequest(byte[] value) throws DecoderException {
        StoredProcedureRequestImpl storedProcedureRequest = new StoredProcedureRequestImpl();
        this.decodeValue(storedProcedureRequest, value);
        return storedProcedureRequest;
    }

    @Override
    public StoredProcedureResponse newResponse() {
        return new StoredProcedureResponseImpl();
    }

    @Override
    public void decodeValue(ExtendedRequest extendedRequest, byte[] requestValue) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(requestValue);
        StoredProcedureRequestContainer container = new StoredProcedureRequestContainer();
        container.setStoredProcedureRequest((StoredProcedureRequest)extendedRequest);
        Asn1Decoder.decode(bb, container);
    }

    private void encodeParameters(Asn1Buffer buffer, Iterator<StoredProcedureParameter> parameters) {
        if (parameters.hasNext()) {
            StoredProcedureParameter parameter = parameters.next();
            this.encodeParameters(buffer, parameters);
            int start = buffer.getPos();
            BerValue.encodeOctetString(buffer, parameter.getValue());
            BerValue.encodeOctetString(buffer, parameter.getType());
            BerValue.encodeSequence(buffer, start);
        }
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, ExtendedRequest extendedRequest) {
        int start = buffer.getPos();
        StoredProcedureRequest storedProcedureRequest = (StoredProcedureRequest)extendedRequest;
        this.encodeParameters(buffer, storedProcedureRequest.getParameters().iterator());
        BerValue.encodeSequence(buffer, start);
        BerValue.encodeOctetString(buffer, storedProcedureRequest.getProcedure());
        BerValue.encodeOctetString(buffer, storedProcedureRequest.getLanguage());
        BerValue.encodeSequence(buffer, start);
    }
}

