/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownRequestContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownStatesEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GracefulShutdownRequestGrammar
extends AbstractGrammar<GracefulShutdownRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownRequestGrammar.class);
    private static GracefulShutdownRequestGrammar instance = new GracefulShutdownRequestGrammar();

    private GracefulShutdownRequestGrammar() {
        this.setName(GracefulShutdownRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[GracefulShutdownStatesEnum.LAST_GRACEFUL_SHUTDOWN_STATE.ordinal()][256];
        this.transitions[GracefulShutdownStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<GracefulShutdownRequestContainer>(GracefulShutdownStatesEnum.START_STATE, GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<GracefulShutdownRequestContainer>("Init Graceful Shutdown"){

            @Override
            public void action(GracefulShutdownRequestContainer container) throws DecoderException {
                if (container.getCurrentTLV().getLength() == 0) {
                    container.setGrammarEndAllowed(true);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<GracefulShutdownRequestContainer>(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<GracefulShutdownRequestContainer>("Set Graceful Shutdown time offline"){

            @Override
            public void action(GracefulShutdownRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse(value, 0, 720);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08216_TIME_OFFLINE, timeOffline));
                    }
                    container.getGracefulShutdownRequest().setTimeOffline(timeOffline);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_08206_TIME_OFFLINE_DECODING_FAILED, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_STATE.ordinal()][128] = new GrammarTransition<GracefulShutdownRequestContainer>(GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, GracefulShutdownStatesEnum.DELAY_STATE, 128, new GrammarAction<GracefulShutdownRequestContainer>("Set Graceful Shutdown Delay"){

            @Override
            public void action(GracefulShutdownRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse(value, 0, 86400);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08204_DELAY, delay));
                    }
                    container.getGracefulShutdownRequest().setDelay(delay);
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_08205_CANNOT_DECODE_DELAY, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg, ide);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition<GracefulShutdownRequestContainer>(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, GracefulShutdownStatesEnum.DELAY_STATE, 128, new GrammarAction<GracefulShutdownRequestContainer>("Set Graceful Shutdown Delay"){

            @Override
            public void action(GracefulShutdownRequestContainer container) throws DecoderException {
                GracefulShutdownRequestContainer gracefulShutdownContainer = container;
                BerValue value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse(value, 0, 86400);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08204_DELAY, delay));
                    }
                    gracefulShutdownContainer.getGracefulShutdownRequest().setDelay(delay);
                    gracefulShutdownContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_08205_CANNOT_DECODE_DELAY, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg, ide);
                }
            }
        });
    }

    public static GracefulShutdownRequestGrammar getInstance() {
        return instance;
    }
}

