/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseStates;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.endTransaction.UpdateControls;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionResponseGrammar
extends AbstractGrammar<EndTransactionResponseContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(EndTransactionResponseGrammar.class);
    private static Grammar<EndTransactionResponseContainer> instance = new EndTransactionResponseGrammar();

    public EndTransactionResponseGrammar() {
        this.setName(EndTransactionResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[EndTransactionResponseStates.LAST_STATE.ordinal()][256];
        this.transitions[EndTransactionResponseStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<EndTransactionResponseContainer>(EndTransactionResponseStates.START_STATE, EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE, UniversalTag.SEQUENCE, new GrammarAction<EndTransactionResponseContainer>("Init EndTransactionResponse"){

            @Override
            public void action(EndTransactionResponseContainer container) {
                if (container.getCurrentTLV().getLength() == 0) {
                    container.setGrammarEndAllowed(true);
                }
            }
        });
        this.transitions[EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<EndTransactionResponseContainer>(EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE, EndTransactionResponseStates.FAILED_MESSAGE_ID_STATE, UniversalTag.INTEGER, new GrammarAction<EndTransactionResponseContainer>("Set EndTransactionResponse failed MessageID"){

            @Override
            public void action(EndTransactionResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int failedMessageId = IntegerDecoder.parse(value);
                    if (failedMessageId > 0) {
                        container.getEndTransactionResponse().setFailedMessageId(failedMessageId);
                    }
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    LOG.error(I18n.err(I18n.ERR_08221_BAD_END_TRANSACTION_COMMIT, Strings.dumpBytes(value.getData()), ide.getMessage()));
                    throw new DecoderException(ide.getMessage(), ide);
                }
            }
        });
        this.transitions[EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE, EndTransactionResponseStates.UPDATE_CONTROLS_SEQ_STATE, UniversalTag.SEQUENCE);
        this.transitions[EndTransactionResponseStates.UPDATE_CONTROLS_SEQ_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<EndTransactionResponseContainer>(EndTransactionResponseStates.UPDATE_CONTROLS_SEQ_STATE, EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE, UniversalTag.SEQUENCE, new GrammarAction<EndTransactionResponseContainer>("Create an updateControl"){

            @Override
            public void action(EndTransactionResponseContainer container) {
                UpdateControls currentUpdateControls = new UpdateControls();
                container.setCurrentControls(currentUpdateControls);
            }
        });
        this.transitions[EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<EndTransactionResponseContainer>(EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE, EndTransactionResponseStates.CONTROL_MESSAGE_ID_STATE, UniversalTag.INTEGER, new GrammarAction<EndTransactionResponseContainer>("Get the updateControl messageId"){

            @Override
            public void action(EndTransactionResponseContainer container) throws DecoderException {
                UpdateControls currentUpdateControls = container.getCurrentUpdateControls();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int messageId = IntegerDecoder.parse(value);
                    currentUpdateControls.setMessageId(messageId);
                    container.setGathering(true);
                }
                catch (IntegerDecoderException ide) {
                    LOG.error(I18n.err(I18n.ERR_08222_BAD_END_TRANSACTION_MESSAGE_ID, Strings.dumpBytes(value.getData()), ide.getMessage()));
                    throw new DecoderException(ide.getMessage(), ide);
                }
            }
        });
        this.transitions[EndTransactionResponseStates.CONTROL_MESSAGE_ID_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<EndTransactionResponseContainer>(EndTransactionResponseStates.CONTROL_MESSAGE_ID_STATE, EndTransactionResponseStates.CONTROLS_STATE, UniversalTag.SEQUENCE, new GrammarAction<EndTransactionResponseContainer>("Process the controls"){

            @Override
            public void action(EndTransactionResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                container.setGathering(false);
                try {
                    List<Control> controls = EndTransactionResponseContainer.decode(value.getData());
                    UpdateControls currentUpdateControls = container.getCurrentUpdateControls();
                    currentUpdateControls.setControls(controls);
                    container.getEndTransactionResponse().getUpdateControls().add(currentUpdateControls);
                }
                catch (DecoderException de) {
                    LOG.error(I18n.err(I18n.ERR_08223_INVALID_CONTROL_LIST, Strings.dumpBytes(value.getData()), de.getMessage()));
                    throw new DecoderException(de.getMessage(), de);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[EndTransactionResponseStates.CONTROLS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<EndTransactionResponseContainer>(EndTransactionResponseStates.CONTROLS_STATE, EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE, UniversalTag.SEQUENCE, new GrammarAction<EndTransactionResponseContainer>("Get the updateControl messageId"){

            @Override
            public void action(EndTransactionResponseContainer container) {
                UpdateControls currentUpdateControls = new UpdateControls();
                container.setCurrentControls(currentUpdateControls);
            }
        });
    }

    public static Grammar<EndTransactionResponseContainer> getInstance() {
        return instance;
    }
}

