/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.cancel;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelRequestContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelStatesEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CancelRequestGrammar
extends AbstractGrammar<CancelRequestContainer> {
    static final Logger LOG = LoggerFactory.getLogger(CancelRequestGrammar.class);
    private static Grammar<CancelRequestContainer> instance = new CancelRequestGrammar();

    private CancelRequestGrammar() {
        this.setName(CancelRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[CancelStatesEnum.LAST_CANCEL_STATE.ordinal()][256];
        this.transitions[CancelStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(CancelStatesEnum.START_STATE, CancelStatesEnum.CANCEL_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[CancelStatesEnum.CANCEL_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition<CancelRequestContainer>(CancelStatesEnum.CANCEL_SEQUENCE_STATE, CancelStatesEnum.CANCEL_ID_STATE, UniversalTag.INTEGER.getValue(), new GrammarAction<CancelRequestContainer>("Stores CancelId"){

            @Override
            public void action(CancelRequestContainer cancelContainer) throws DecoderException {
                BerValue value = cancelContainer.getCurrentTLV().getValue();
                try {
                    int cancelId = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08200_CANCEL_ID, cancelId));
                    }
                    cancelContainer.getCancelRequest().setCancelId(cancelId);
                    cancelContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err(I18n.ERR_08200_CANCELID_DECODING_FAILED, Strings.dumpBytes(value.getData()));
                    LOG.error(msg);
                    throw new DecoderException(msg, ide);
                }
            }
        });
    }

    public static Grammar<CancelRequestContainer> getInstance() {
        return instance;
    }
}

