/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory;

import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Message;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Referral;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultResponse;

public abstract class ResponseFactory
implements Messagefactory {
    private static final byte[] DEFAULT_SUCCESS = new byte[]{10, 1, 0, 4, 0, 4, 0};
    private static final byte[] EMPTY_MATCHED_DN = new byte[]{4, 0};

    protected ResponseFactory() {
    }

    protected void encodeReferralUrls(Asn1Buffer buffer, Iterator<String> urls) {
        if (urls.hasNext()) {
            String url = urls.next();
            this.encodeReferralUrls(buffer, urls);
            BerValue.encodeOctetString(buffer, url);
        }
    }

    protected void encodeLdapResultReverse(Asn1Buffer buffer, LdapResult ldapResult) {
        if (ldapResult.isDefaultSuccess()) {
            buffer.put(DEFAULT_SUCCESS);
            return;
        }
        Referral referral = ldapResult.getReferral();
        if (referral != null) {
            int start = buffer.getPos();
            Collection<String> urls = referral.getLdapUrls();
            if (urls != null) {
                this.encodeReferralUrls(buffer, urls.iterator());
            }
            BerValue.encodeSequence(buffer, (byte)-93, start);
        }
        BerValue.encodeOctetString(buffer, ldapResult.getDiagnosticMessage());
        if (ldapResult.getMatchedDn() != null) {
            BerValue.encodeOctetString(buffer, ldapResult.getMatchedDn().getName());
        } else {
            buffer.put(EMPTY_MATCHED_DN);
        }
        BerValue.encodeEnumerated(buffer, ldapResult.getResultCode().getValue());
    }

    protected void encodeReverse(LdapApiService codec, Asn1Buffer buffer, byte tag, Message message) {
        int start = buffer.getPos();
        this.encodeLdapResultReverse(buffer, ((ResultResponse)message).getLdapResult());
        BerValue.encodeSequence(buffer, tag, start);
    }
}

