/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.Messagefactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Message;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.name.Dn;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class BindRequestFactory
implements Messagefactory {
    public static final BindRequestFactory INSTANCE = new BindRequestFactory();

    private BindRequestFactory() {
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        BindRequest bindMessage = (BindRequest)message;
        if (bindMessage.isSimple()) {
            BerValue.encodeOctetString(buffer, (byte)-128, bindMessage.getCredentials());
        } else {
            if (!Strings.isEmpty(bindMessage.getCredentials())) {
                BerValue.encodeOctetString(buffer, bindMessage.getCredentials());
            }
            BerValue.encodeOctetString(buffer, bindMessage.getSaslMechanism());
            BerValue.encodeSequence(buffer, (byte)-93, start);
        }
        Dn dn = bindMessage.getDn();
        if (!Dn.isNullOrEmpty(dn)) {
            BerValue.encodeOctetString(buffer, dn.getName());
        } else {
            BerValue.encodeOctetString(buffer, bindMessage.getName());
        }
        BerValue.encodeInteger(buffer, 3);
        BerValue.encodeSequence(buffer, (byte)96, start);
    }
}

