/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.AbstractContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.LdapMessageGrammar;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.LdapStatesEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.ConnectorFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.Filter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.PresentFilter;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Message;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.ResultResponse;

public class LdapMessageContainer<E extends Message>
extends AbstractContainer {
    private E message;
    private BinaryAttributeDetector binaryAttributeDetector;
    private int messageId;
    private Control currentControl;
    private ControlFactory<?> controlFactory;
    private IntermediateOperationFactory intermediateFactory;
    private ExtendedOperationFactory extendedFactory;
    private final LdapApiService codec;
    private LdapResult ldapResult;
    private Attribute currentAttribute;
    private Modification currentModification;
    private int tlvId;
    private Filter terminalFilter;
    private Filter currentFilter;
    private Filter topFilter;

    public LdapMessageContainer(LdapApiService codec) {
        this(codec, new DefaultConfigurableBinaryAttributeDetector());
    }

    public LdapMessageContainer(LdapApiService codec, BinaryAttributeDetector binaryAttributeDetector) {
        this.codec = codec;
        this.setGrammar(LdapMessageGrammar.getInstance());
        this.binaryAttributeDetector = binaryAttributeDetector;
        this.setTransition(LdapStatesEnum.START_STATE);
    }

    public LdapApiService getLdapCodecService() {
        return this.codec;
    }

    public E getMessage() {
        return this.message;
    }

    public void setMessage(E message) {
        this.message = message;
    }

    @Override
    public void clean() {
        super.clean();
        this.messageId = -1;
        this.tlvId = -1;
        this.message = null;
        this.ldapResult = null;
        this.currentControl = null;
        this.currentAttribute = null;
        this.currentFilter = null;
        this.terminalFilter = null;
        this.topFilter = null;
        this.controlFactory = null;
        this.intermediateFactory = null;
        this.extendedFactory = null;
        this.setDecodedBytes(0);
    }

    public boolean isBinary(String id) {
        return this.binaryAttributeDetector.isBinary(id);
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public Control getCurrentControl() {
        return this.currentControl;
    }

    public void setCurrentControl(Control currentControl) {
        this.currentControl = currentControl;
    }

    public void setBinaryAttributeDetector(BinaryAttributeDetector binaryAttributeDetector) {
        this.binaryAttributeDetector = binaryAttributeDetector;
    }

    public BinaryAttributeDetector getBinaryAttributeDetector() {
        return this.binaryAttributeDetector;
    }

    public LdapResult getLdapResult() {
        return this.ldapResult;
    }

    public void setLdapResult(LdapResult ldapResult) {
        this.ldapResult = ldapResult;
    }

    public ControlFactory<?> getControlFactory() {
        return this.controlFactory;
    }

    public void setControlFactory(ControlFactory<?> controlFactory) {
        this.controlFactory = controlFactory;
    }

    public Attribute getCurrentAttribute() {
        return this.currentAttribute;
    }

    public void setCurrentAttribute(Attribute currentAttribute) {
        this.currentAttribute = currentAttribute;
    }

    public Modification getCurrentModification() {
        return this.currentModification;
    }

    public void setCurrentModification(Modification currentModification) {
        this.currentModification = currentModification;
    }

    public void setTlvId(int tlvId) {
        this.tlvId = tlvId;
    }

    public Filter getTerminalFilter() {
        return this.terminalFilter;
    }

    public void setTerminalFilter(Filter terminalFilter) {
        this.terminalFilter = terminalFilter;
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    public void setCurrentFilter(Filter currentFilter) {
        this.currentFilter = currentFilter;
    }

    public void addCurrentFilter(Filter localFilter) throws DecoderException {
        if (this.currentFilter != null) {
            ((ConnectorFilter)this.currentFilter).addFilter(localFilter);
            localFilter.setParent(this.currentFilter, this.currentFilter.getTlvId());
            if (localFilter instanceof ConnectorFilter) {
                this.currentFilter = localFilter;
            }
        } else {
            this.currentFilter = localFilter;
            this.currentFilter.setParent(null, this.tlvId);
            this.topFilter = localFilter;
        }
    }

    public void unstackFilters() {
        TLV tlv = this.getCurrentTLV();
        TLV localParent = tlv.getParent();
        Filter localFilter = this.terminalFilter;
        while (localParent != null && localParent.getExpectedLength() == 0) {
            int parentTlvId;
            int n = parentTlvId = localFilter.getParent() != null ? localFilter.getParent().getTlvId() : localFilter.getParentTlvId();
            if (localParent.getId() != parentTlvId) {
                localParent = localParent.getParent();
                continue;
            }
            Filter filterParent = localFilter.getParent();
            if (localFilter instanceof PresentFilter) {
                if (filterParent == null) break;
                filterParent = filterParent.getParent();
            } else {
                filterParent = filterParent.getParent();
            }
            if (filterParent == null) break;
            localFilter = this.currentFilter;
            this.currentFilter = filterParent;
            localParent = localParent.getParent();
        }
    }

    public static void copyLdapResult(ResultResponse resultResponse, ExtendedResponse extendedResponse) {
        extendedResponse.getLdapResult().setDiagnosticMessage(resultResponse.getLdapResult().getDiagnosticMessage());
        extendedResponse.getLdapResult().setMatchedDn(resultResponse.getLdapResult().getMatchedDn());
        extendedResponse.getLdapResult().setReferral(resultResponse.getLdapResult().getReferral());
        extendedResponse.getLdapResult().setResultCode(resultResponse.getLdapResult().getResultCode());
    }

    public Filter getTopFilter() {
        return this.topFilter;
    }

    public void setTopFilter(Filter topFilter) {
        this.topFilter = topFilter;
    }

    @Override
    public int getTlvId() {
        return this.tlvId;
    }

    public IntermediateOperationFactory getIntermediateFactory() {
        return this.intermediateFactory;
    }

    public void setIntermediateFactory(IntermediateOperationFactory intermediateFactory) {
        this.intermediateFactory = intermediateFactory;
    }

    public ExtendedOperationFactory getExtendedFactory() {
        return this.extendedFactory;
    }

    public void setExtendedFactory(ExtendedOperationFactory extendedFactory) {
        this.extendedFactory = extendedFactory;
    }
}

