/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.EncoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.AbandonRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.AddRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.AddResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.BindRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.BindResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.CompareRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.CompareResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.DeleteRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.DeleteResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.ExtendedRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.ExtendedResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.IntermediateResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.ModifyDnRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.ModifyDnResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.ModifyRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.ModifyResponseFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.SearchRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.SearchResultDoneFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.SearchResultEntryFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.SearchResultReferenceFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.factory.UnbindRequestFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Message;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Request;

public final class LdapEncoder {
    private LdapEncoder() {
    }

    private static void encodeControls(Asn1Buffer buffer, LdapApiService codec, Map<String, Control> controls, Iterator<String> iterator, boolean isRequest) throws EncoderException {
        if (iterator.hasNext()) {
            Control control = controls.get(iterator.next());
            LdapEncoder.encodeControls(buffer, codec, controls, iterator, isRequest);
            ControlFactory<? extends Control> controlFactory = isRequest ? codec.getRequestControlFactories().get(control.getOid()) : codec.getResponseControlFactories().get(control.getOid());
            if (controlFactory == null) {
                throw new EncoderException(I18n.err(I18n.ERR_08002_CANNOT_FIND_CONTROL_FACTORY, control.getOid()));
            }
            int start = buffer.getPos();
            controlFactory.encodeValue(buffer, control);
            if (buffer.getPos() != start) {
                BerValue.encodeSequence(buffer, UniversalTag.OCTET_STRING.getValue(), start);
            }
            if (control.isCritical()) {
                BerValue.encodeBoolean(buffer, control.isCritical());
            }
            BerValue.encodeOctetString(buffer, control.getOid());
            BerValue.encodeSequence(buffer, start);
        }
    }

    private static void encodeProtocolOp(Asn1Buffer buffer, LdapApiService codec, Message message) {
        switch (message.getType()) {
            case ABANDON_REQUEST: {
                AbandonRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case ADD_REQUEST: {
                AddRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case ADD_RESPONSE: {
                AddResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case BIND_REQUEST: {
                BindRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case BIND_RESPONSE: {
                BindResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case COMPARE_REQUEST: {
                CompareRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case COMPARE_RESPONSE: {
                CompareResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case DEL_REQUEST: {
                DeleteRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case DEL_RESPONSE: {
                DeleteResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case EXTENDED_REQUEST: {
                ExtendedRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case EXTENDED_RESPONSE: {
                ExtendedResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case INTERMEDIATE_RESPONSE: {
                IntermediateResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case MODIFY_REQUEST: {
                ModifyRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case MODIFY_RESPONSE: {
                ModifyResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case MODIFYDN_REQUEST: {
                ModifyDnRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case MODIFYDN_RESPONSE: {
                ModifyDnResponseFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case SEARCH_REQUEST: {
                SearchRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case SEARCH_RESULT_DONE: {
                SearchResultDoneFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case SEARCH_RESULT_ENTRY: {
                SearchResultEntryFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case SEARCH_RESULT_REFERENCE: {
                SearchResultReferenceFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
            case UNBIND_REQUEST: {
                UnbindRequestFactory.INSTANCE.encodeReverse(codec, buffer, message);
                return;
            }
        }
    }

    public static ByteBuffer encodeMessage(Asn1Buffer buffer, LdapApiService codec, Message message) throws EncoderException {
        int start = buffer.getPos();
        Map<String, Control> controls = message.getControls();
        if (controls != null && controls.size() > 0) {
            LdapEncoder.encodeControls(buffer, codec, controls, controls.keySet().iterator(), message instanceof Request);
            BerValue.encodeSequence(buffer, (byte)-96, start);
        }
        LdapEncoder.encodeProtocolOp(buffer, codec, message);
        BerValue.encodeInteger(buffer, message.getMessageId());
        BerValue.encodeSequence(buffer);
        return buffer.getBytes();
    }
}

