/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.actions.response.intermediate;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Oid;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreIntermediateResponseName
extends GrammarAction<LdapMessageContainer<IntermediateResponse>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreIntermediateResponseName.class);

    public StoreIntermediateResponseName() {
        super("Store response name");
    }

    @Override
    public void action(LdapMessageContainer<IntermediateResponse> container) throws DecoderException {
        IntermediateResponse intermediateResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05122_NULL_NAME, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] responseNameBytes = tlv.getValue().getData();
        String oidStr = Strings.utf8ToString(responseNameBytes);
        if (Oid.isOid(oidStr)) {
            IntermediateOperationFactory intermediateFactory = container.getLdapCodecService().getIntermediateResponseFactories().get(oidStr);
            if (intermediateFactory != null) {
                IntermediateResponse newIntermediateResponse = intermediateFactory.newResponse();
                newIntermediateResponse.setMessageId(intermediateResponse.getMessageId());
                LdapResult ldapResult = intermediateResponse.getLdapResult();
                newIntermediateResponse.getLdapResult().setDiagnosticMessage(ldapResult.getDiagnosticMessage());
                newIntermediateResponse.getLdapResult().setMatchedDn(ldapResult.getMatchedDn());
                newIntermediateResponse.getLdapResult().setReferral(ldapResult.getReferral());
                newIntermediateResponse.getLdapResult().setResultCode(ldapResult.getResultCode());
                for (Control control : intermediateResponse.getControls().values()) {
                    newIntermediateResponse.addControl(control);
                }
                container.setMessage(newIntermediateResponse);
                container.setIntermediateFactory(intermediateFactory);
            } else {
                intermediateResponse.setResponseName(oidStr);
            }
        } else {
            String msg = I18n.err(I18n.ERR_05133_INTERMEDIATE_RESPONSE_INVALID_OID, Strings.utf8ToString(responseNameBytes), Strings.dumpBytes(responseNameBytes));
            LOG.error(I18n.err(I18n.ERR_05114_ERROR_MESSAGE, msg, oidStr));
            throw new DecoderException(msg);
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05172_OID_READ, intermediateResponse.getResponseName()));
        }
    }
}

