/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.Decoder;
import org.apache.spark.sql.execution.columnar.Encoder;
import org.apache.spark.sql.execution.columnar.NativeRssColumnType;
import org.apache.spark.sql.execution.columnar.RssColumnDictionary;
import org.apache.spark.sql.execution.columnar.RssColumnType;
import org.apache.spark.sql.execution.columnar.RssDictionaryEncoding$;
import org.apache.spark.sql.execution.vectorized.Dictionary;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015w!B A\u0011\u0003ke!B(A\u0011\u0003\u0003\u0006\"\u00021\u0002\t\u0003\t\u0007b\u00022\u0002\u0005\u0004%\te\u0019\u0005\u0007O\u0006\u0001\u000b\u0011\u00023\t\u000f!\f\u0001\u0019!C\u0001S\"9Q.\u0001a\u0001\n\u0003q\u0007B\u0002;\u0002A\u0003&!\u000eC\u0003v\u0003\u0011\u0005c\u000fC\u0004\u00022\u0005!\t%a\r\t\u000f\u0005\u0015\u0013\u0001\"\u0011\u0002H\u00191\u0011qM\u0001\u0001\u0003SB!\"!\u000b\f\u0005\u0003\u0005\u000b\u0011BA:\u0011\u0019\u00017\u0002\"\u0001\u0002v!A\u0011QP\u0006A\u0002\u0013%1\rC\u0005\u0002\u0000-\u0001\r\u0011\"\u0003\u0002\u0002\"9\u0011QQ\u0006!B\u0013!\u0007\"CAD\u0017\u0001\u0007I\u0011AAE\u0011%\tYi\u0003a\u0001\n\u0003\ti\t\u0003\u0005\u0002\u0012.\u0001\u000b\u0015BA%\u0011!\t\u0019j\u0003a\u0001\n\u0013\u0019\u0007\"CAK\u0017\u0001\u0007I\u0011BAL\u0011\u001d\tYj\u0003Q!\n\u0011Dq!!(\f\t\u0003\ty\nC\u0005\u0002\".\u0011\r\u0011\"\u0003\u0002$\"A\u00111X\u0006!\u0002\u0013\t)\u000bC\u0005\u0002>.\u0011\r\u0011\"\u0003\u0002@\"A\u0011QZ\u0006!\u0002\u0013\t\t\r\u0003\u0005\u0002P.\u0001\r\u0011\"\u0003d\u0011%\t\tn\u0003a\u0001\n\u0013\t\u0019\u000eC\u0004\u0002X.\u0001\u000b\u0015\u00023\t\u000f\u0005e7\u0002\"\u0011\u0002\\\"9\u0011\u0011_\u0006\u0005B\u0005M\bBBA\u007f\u0017\u0011\u00053\r\u0003\u0004\u0002\u0000.!\te\u0019\u0004\u0007\u0005\u0003\t\u0001Aa\u0001\t\u0015\u0005U1E!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002*\r\u0012\t\u0011)A\u0005\u0005\u001bAa\u0001Y\u0012\u0005\u0002\t=\u0001\u0002\u0003B\fG\t\u0007I\u0011A2\t\u000f\te1\u0005)A\u0005I\"I\u0011QX\u0012C\u0002\u0013%!1\u0004\u0005\t\u0003\u001b\u001c\u0003\u0015!\u0003\u0003\u001e!I!1E\u0012A\u0002\u0013%!Q\u0005\u0005\n\u0005S\u0019\u0003\u0019!C\u0005\u0005WA\u0001Ba\f$A\u0003&!q\u0005\u0005\n\u0005c\u0019\u0003\u0019!C\u0005\u0005gA\u0011B!\u0010$\u0001\u0004%IAa\u0010\t\u0011\t\r3\u0005)Q\u0005\u0005kA\u0011B!\u0012$\u0001\u0004%IAa\u0012\t\u0013\t\u00054\u00051A\u0005\n\t\r\u0004\u0002\u0003B4G\u0001\u0006KA!\u0013\t\u000f\t%4\u0005\"\u0011\u0003l!9!\u0011O\u0012\u0005B\u0005%\u0005b\u0002B:G\u0011\u0005#Q\u000f\u0005\n\u0005\u0017\u000b\u0011\u0011!C!\u0005\u001bC\u0001B!'\u0002\u0003\u0003%\ta\u0019\u0005\n\u00057\u000b\u0011\u0011!C\u0001\u0005;C\u0011B!)\u0002\u0003\u0003%\tEa)\t\u0013\t5\u0016!!A\u0005\u0002\t=\u0006\"\u0003BZ\u0003\u0005\u0005I\u0011\tB[\u0011%\u00119,AA\u0001\n\u0003\u0012I\fC\u0005\u0003<\u0006\t\t\u0011\"\u0003\u0003>\u0006)\"k]:ES\u000e$\u0018n\u001c8bef,enY8eS:<'BA!C\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\"E\u0003%)\u00070Z2vi&|gN\u0003\u0002F\r\u0006\u00191/\u001d7\u000b\u0005\u001dC\u0015!B:qCJ\\'BA%K\u0003\u0019\t\u0007/Y2iK*\t1*A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002O\u00035\t\u0001IA\u000bSgN$\u0015n\u0019;j_:\f'/_#oG>$\u0017N\\4\u0014\u000b\u0005\tvKW/\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\r\u0005s\u0017PU3g!\tq\u0005,\u0003\u0002Z\u0001\n!\"k]:D_6\u0004(/Z:tS>t7k\u00195f[\u0016\u0004\"AU.\n\u0005q\u001b&a\u0002)s_\u0012,8\r\u001e\t\u0003%zK!aX*\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005i\u0015A\u0002;za\u0016LE-F\u0001e!\t\u0011V-\u0003\u0002g'\n\u0019\u0011J\u001c;\u0002\u000fQL\b/Z%eA\u0005iQ*\u0011-`\t&\u001bEkX*J5\u0016+\u0012A\u001b\t\u0003%.L!\u0001\\*\u0003\u000bMCwN\u001d;\u0002#5\u000b\u0005l\u0018#J\u0007R{6+\u0013.F?\u0012*\u0017\u000f\u0006\u0002peB\u0011!\u000b]\u0005\u0003cN\u0013A!\u00168ji\"91OBA\u0001\u0002\u0004Q\u0017a\u0001=%c\u0005qQ*\u0011-`\t&\u001bEkX*J5\u0016\u0003\u0013a\u00023fG>$WM]\u000b\u0003ov$R\u0001_A\n\u0003O\u00012AT=|\u0013\tQ\bIA\u0004EK\u000e|G-\u001a:\u0011\u0005qlH\u0002\u0001\u0003\u0006}\"\u0011\ra \u0002\u0002)F!\u0011\u0011AA\u0004!\r\u0011\u00161A\u0005\u0004\u0003\u000b\u0019&a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002#\u0002\u000bQL\b/Z:\n\t\u0005E\u00111\u0002\u0002\u000b\u0003R|W.[2UsB,\u0007bBA\u000b\u0011\u0001\u0007\u0011qC\u0001\u0007EV4g-\u001a:\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005\u0019a.[8\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\u0005%\u0002\u00021\u0001\u0002,\u0005Q1m\u001c7v[:$\u0016\u0010]3\u0011\t9\u000bic_\u0005\u0004\u0003_\u0001%a\u0005(bi&4XMU:t\u0007>dW/\u001c8UsB,\u0017aB3oG>$WM]\u000b\u0005\u0003k\ty\u0004\u0006\u0003\u00028\u0005\u0005\u0003#\u0002(\u0002:\u0005u\u0012bAA\u001e\u0001\n9QI\\2pI\u0016\u0014\bc\u0001?\u0002@\u0011)a0\u0003b\u0001\u007f\"9\u0011\u0011F\u0005A\u0002\u0005\r\u0003#\u0002(\u0002.\u0005u\u0012\u0001C:vaB|'\u000f^:\u0015\t\u0005%\u0013q\n\t\u0004%\u0006-\u0013bAA''\n9!i\\8mK\u0006t\u0007bBA\u0015\u0015\u0001\u0007\u0011\u0011\u000b\u0019\u0005\u0003'\nY\u0006E\u0003O\u0003+\nI&C\u0002\u0002X\u0001\u0013QBU:t\u0007>dW/\u001c8UsB,\u0007c\u0001?\u0002\\\u0011a\u0011QLA(\u0003\u0003\u0005\tQ!\u0001\u0002`\t\u0019q\f\n\u001a\u0012\t\u0005\u0005\u0011\u0011\r\t\u0004%\u0006\r\u0014bAA3'\n\u0019\u0011I\\=\u0003\u0015I\u001b8/\u00128d_\u0012,'/\u0006\u0003\u0002l\u0005E4\u0003B\u0006R\u0003[\u0002RATA\u001d\u0003_\u00022\u0001`A9\t\u0015q8B1\u0001\u0000!\u0015q\u0015QFA8)\u0011\t9(a\u001f\u0011\u000b\u0005e4\"a\u001c\u000e\u0003\u0005Aq!!\u000b\u000e\u0001\u0004\t\u0019(A\t`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\fQcX;oG>l\u0007O]3tg\u0016$7+\u001b>f?\u0012*\u0017\u000fF\u0002p\u0003\u0007Cqa]\b\u0002\u0002\u0003\u0007A-\u0001\n`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\u0004\u0013\u0001C8wKJ4Gn\\<\u0016\u0005\u0005%\u0013\u0001D8wKJ4Gn\\<`I\u0015\fHcA8\u0002\u0010\"A1OEA\u0001\u0002\u0004\tI%A\u0005pm\u0016\u0014h\r\\8xA\u0005)1m\\;oi\u0006I1m\\;oi~#S-\u001d\u000b\u0004_\u0006e\u0005bB:\u0016\u0003\u0003\u0005\r\u0001Z\u0001\u0007G>,h\u000e\u001e\u0011\u0002\u0015\rdW-\u00198CCR\u001c\u0007.F\u0001p\u0003\u00191\u0018\r\\;fgV\u0011\u0011Q\u0015\t\u0007\u0003O\u000b\t,!.\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bq!\\;uC\ndWMC\u0002\u00020N\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019,!+\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0005\u0003_\n9,\u0003\u0003\u0002:\u0006=!\u0001D%oi\u0016\u0014h.\u00197UsB,\u0017a\u0002<bYV,7\u000fI\u0001\u000bI&\u001cG/[8oCJLXCAAa!\u001d\t\u0019-!3\u0002b)l!!!2\u000b\t\u0005\u001d\u0017qD\u0001\u0005kRLG.\u0003\u0003\u0002L\u0006\u0015'a\u0002%bg\"l\u0015\r]\u0001\fI&\u001cG/[8oCJL\b%\u0001\beS\u000e$\u0018n\u001c8bef\u001c\u0016N_3\u0002%\u0011L7\r^5p]\u0006\u0014\u0018pU5{K~#S-\u001d\u000b\u0004_\u0006U\u0007bB:\u001e\u0003\u0003\u0005\r\u0001Z\u0001\u0010I&\u001cG/[8oCJL8+\u001b>fA\u0005Qr-\u0019;iKJ\u001cu.\u001c9sKN\u001c\u0018NY5mSRL8\u000b^1ugR)q.!8\u0002n\"9\u0011q\\\u0010A\u0002\u0005\u0005\u0018a\u0001:poB!\u00111]Au\u001b\t\t)OC\u0002\u0002h\u0012\u000b\u0001bY1uC2L8\u000f^\u0005\u0005\u0003W\f)OA\u0006J]R,'O\\1m%><\bBBAx?\u0001\u0007A-A\u0004pe\u0012Lg.\u00197\u0002\u0011\r|W\u000e\u001d:fgN$b!a\u0006\u0002v\u0006e\bbBA|A\u0001\u0007\u0011qC\u0001\u0005MJ|W\u000eC\u0004\u0002|\u0002\u0002\r!a\u0006\u0002\u0005Q|\u0017\u0001E;oG>l\u0007O]3tg\u0016$7+\u001b>f\u00039\u0019w.\u001c9sKN\u001cX\rZ*ju\u0016\u0014!BU:t\t\u0016\u001cw\u000eZ3s+\u0011\u0011)Aa\u0003\u0014\t\r\n&q\u0001\t\u0005\u001df\u0014I\u0001E\u0002}\u0005\u0017!QA`\u0012C\u0002}\u0004RATA\u0017\u0005\u0013!bA!\u0005\u0003\u0014\tU\u0001#BA=G\t%\u0001bBA\u000bM\u0001\u0007\u0011q\u0003\u0005\b\u0003S1\u0003\u0019\u0001B\u0007\u0003))G.Z7f]RtU/\\\u0001\fK2,W.\u001a8u\u001dVl\u0007%\u0006\u0002\u0003\u001eA)!Ka\b\u0002b%\u0019!\u0011E*\u0003\u000b\u0005\u0013(/Y=\u0002\u001b%tG\u000fR5di&|g.\u0019:z+\t\u00119\u0003\u0005\u0003S\u0005?!\u0017!E5oi\u0012K7\r^5p]\u0006\u0014\u0018p\u0018\u0013fcR\u0019qN!\f\t\u0011Md\u0013\u0011!a\u0001\u0005O\ta\"\u001b8u\t&\u001cG/[8oCJL\b%\u0001\bm_:<G)[2uS>t\u0017M]=\u0016\u0005\tU\u0002#\u0002*\u0003 \t]\u0002c\u0001*\u0003:%\u0019!1H*\u0003\t1{gnZ\u0001\u0013Y>tw\rR5di&|g.\u0019:z?\u0012*\u0017\u000fF\u0002p\u0005\u0003B\u0001b]\u0018\u0002\u0002\u0003\u0007!QG\u0001\u0010Y>tw\rR5di&|g.\u0019:zA\u0005\u00012\u000f\u001e:j]\u001e$\u0015n\u0019;j_:\f'/_\u000b\u0003\u0005\u0013\u0002RA\u0015B\u0010\u0005\u0017\u0002BA!\u0014\u0003\\9!!q\nB,!\r\u0011\tfU\u0007\u0003\u0005'R1A!\u0016M\u0003\u0019a$o\\8u}%\u0019!\u0011L*\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iFa\u0018\u0003\rM#(/\u001b8h\u0015\r\u0011IfU\u0001\u0015gR\u0014\u0018N\\4ES\u000e$\u0018n\u001c8bef|F%Z9\u0015\u0007=\u0014)\u0007\u0003\u0005te\u0005\u0005\t\u0019\u0001B%\u0003E\u0019HO]5oO\u0012K7\r^5p]\u0006\u0014\u0018\u0010I\u0001\u0005]\u0016DH\u000fF\u0003p\u0005[\u0012y\u0007C\u0004\u0002`R\u0002\r!!9\t\r\u0005=H\u00071\u0001e\u0003\u001dA\u0017m\u001d(fqR\f!\u0002Z3d_6\u0004(/Z:t)\u0015y'q\u000fBD\u0011\u001d\u0011IH\u000ea\u0001\u0005w\nAbY8mk6tg+Z2u_J\u0004BA! \u0003\u00046\u0011!q\u0010\u0006\u0004\u0005\u0003\u0013\u0015A\u0003<fGR|'/\u001b>fI&!!Q\u0011B@\u0005Q9&/\u001b;bE2,7i\u001c7v[:4Vm\u0019;pe\"1!\u0011\u0012\u001cA\u0002\u0011\f\u0001bY1qC\u000eLG/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t=\u0005\u0003\u0002BI\u0005/k!Aa%\u000b\t\tU\u0015qD\u0001\u0005Y\u0006tw-\u0003\u0003\u0003^\tM\u0015\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\u0012y\nC\u0004ts\u0005\u0005\t\u0019\u00013\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!*\u0011\r\t\u001d&\u0011VA1\u001b\t\ti+\u0003\u0003\u0003,\u00065&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0013\u00032\"A1oOA\u0001\u0002\u0004\t\t'\u0001\u0005iCND7i\u001c3f)\u0005!\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t=\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa0\u0011\t\tE%\u0011Y\u0005\u0005\u0005\u0007\u0014\u0019J\u0001\u0004PE*,7\r\u001e")
public final class RssDictionaryEncoding {
    public static String toString() {
        return RssDictionaryEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return RssDictionaryEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return RssDictionaryEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return RssDictionaryEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return RssDictionaryEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return RssDictionaryEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return RssDictionaryEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(RssColumnType<?> rssColumnType) {
        return RssDictionaryEncoding$.MODULE$.supports(rssColumnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeRssColumnType<T> nativeRssColumnType) {
        return RssDictionaryEncoding$.MODULE$.encoder(nativeRssColumnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeRssColumnType<T> nativeRssColumnType) {
        return RssDictionaryEncoding$.MODULE$.decoder(byteBuffer, nativeRssColumnType);
    }

    public static void MAX_DICT_SIZE_$eq(short s) {
        RssDictionaryEncoding$.MODULE$.MAX_DICT_SIZE_$eq(s);
    }

    public static short MAX_DICT_SIZE() {
        return RssDictionaryEncoding$.MODULE$.MAX_DICT_SIZE();
    }

    public static int typeId() {
        return RssDictionaryEncoding$.MODULE$.typeId();
    }

    public static class RssDecoder<T extends AtomicType>
    implements Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeRssColumnType<T> columnType;
        private final int elementNum;
        private final Object[] dictionary;
        private int[] intDictionary;
        private long[] longDictionary;
        private String[] stringDictionary;

        public int elementNum() {
            return this.elementNum;
        }

        private Object[] dictionary() {
            return this.dictionary;
        }

        private int[] intDictionary() {
            return this.intDictionary;
        }

        private void intDictionary_$eq(int[] x$1) {
            this.intDictionary = x$1;
        }

        private long[] longDictionary() {
            return this.longDictionary;
        }

        private void longDictionary_$eq(long[] x$1) {
            this.longDictionary = x$1;
        }

        private String[] stringDictionary() {
            return this.stringDictionary;
        }

        private void stringDictionary_$eq(String[] x$1) {
            this.stringDictionary = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.setField(row, ordinal, this.dictionary()[this.buffer.getShort()]);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int pos;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            T t = this.columnType.dataType();
            if (t instanceof IntegerType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary((Dictionary)new RssColumnDictionary(this.intDictionary()));
                for (pos = 0; pos < capacity; ++pos) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, (int)this.buffer.getShort());
                        continue;
                    }
                    if (++seenNulls < nullCount) {
                        nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                    }
                    columnVector.putNull(pos);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary((Dictionary)new RssColumnDictionary(this.longDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, (int)this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof StringType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary((Dictionary)new RssColumnDictionary(this.stringDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, (int)this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in DictionaryEncoding.");
            }
        }

        public RssDecoder(ByteBuffer buffer, NativeRssColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.elementNum = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.dictionary = new Object[this.elementNum()];
            this.intDictionary = null;
            this.longDictionary = null;
            this.stringDictionary = null;
            T t = columnType.dataType();
            if (t instanceof IntegerType) {
                this.intDictionary_$eq(new int[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    int v;
                    $this.intDictionary()[i] = v = BoxesRunTime.unboxToInt($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToInteger((int)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.longDictionary_$eq(new long[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    long v;
                    $this.longDictionary()[i] = v = BoxesRunTime.unboxToLong($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToLong((long)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof StringType) {
                this.stringDictionary_$eq(new String[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    UTF8String v = (UTF8String)$this.columnType.extract($this.buffer);
                    $this.stringDictionary()[i] = v.toString();
                    $this.dictionary()[i] = v;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(t);
            }
        }
    }

    public static class RssEncoder<T extends AtomicType>
    implements Encoder<T> {
        private final NativeRssColumnType<T> columnType;
        private int _uncompressedSize;
        private boolean overflow;
        private int count;
        private final ArrayBuffer<Object> values;
        private final HashMap<Object, Object> dictionary;
        private int dictionarySize;

        @Override
        public double compressionRatio() {
            return Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        public boolean overflow() {
            return this.overflow;
        }

        public void overflow_$eq(boolean x$1) {
            this.overflow = x$1;
        }

        private int count() {
            return this.count;
        }

        private void count_$eq(int x$1) {
            this.count = x$1;
        }

        public void cleanBatch() {
            this.count_$eq(0);
            this._uncompressedSize_$eq(0);
        }

        private ArrayBuffer<Object> values() {
            return this.values;
        }

        private HashMap<Object, Object> dictionary() {
            return this.dictionary;
        }

        private int dictionarySize() {
            return this.dictionarySize;
        }

        private void dictionarySize_$eq(int x$1) {
            this.dictionarySize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            block3: {
                if (this.overflow()) break block3;
                Object value = this.columnType.getField(row, ordinal);
                int actualSize = this.columnType.actualSize(row, ordinal);
                this.count_$eq(this.count() + 1);
                this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
                if (!this.dictionary().containsKey(value)) {
                    if (this.dictionary().size() < RssDictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                        Object clone = this.columnType.clone(value);
                        this.values().$plus$eq(clone);
                        this.dictionarySize_$eq(this.dictionarySize() + actualSize);
                        this.dictionary().put(clone, BoxesRunTime.boxToShort((short)((short)this.dictionary().size())));
                    } else {
                        this.overflow_$eq(true);
                        this.values().clear();
                        this.dictionary().clear();
                    }
                }
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(RssDictionaryEncoding$.MODULE$.typeId()).putInt(this.dictionary().size());
            for (int i = 0; i < this.values().length(); ++i) {
                this.columnType.append(this.values().apply(i), to);
            }
            while (from.hasRemaining()) {
                to.putShort(BoxesRunTime.unboxToShort((Object)this.dictionary().get(this.columnType.extract(from))));
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this.overflow() ? Integer.MAX_VALUE : this.dictionarySize() + this.count() * 2;
        }

        public RssEncoder(NativeRssColumnType<T> columnType) {
            this.columnType = columnType;
            Encoder.$init$(this);
            this._uncompressedSize = 0;
            this.overflow = false;
            this.count = 0;
            this.values = new ArrayBuffer(1024);
            this.dictionary = new HashMap(1024);
            this.dictionarySize = 4;
        }
    }
}

