/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.RssColumnStats;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114QAD\b\u0003\u001fmA\u0001B\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!)A\u0006\u0001C\u0001[!)A\u0006\u0001C\u0001c!9!\b\u0001a\u0001\n#Y\u0004bB \u0001\u0001\u0004%\t\u0002\u0011\u0005\u0007\r\u0002\u0001\u000b\u0015\u0002\u001f\t\u000f\u001d\u0003\u0001\u0019!C\tw!9\u0001\n\u0001a\u0001\n#I\u0005BB&\u0001A\u0003&A\bC\u0003M\u0001\u0011\u0005S\nC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003]\u0001\u0011\u0005SLA\u000bSgN$UmY5nC2\u001cu\u000e\\;n]N#\u0018\r^:\u000b\u0005A\t\u0012\u0001C2pYVlg.\u0019:\u000b\u0005I\u0019\u0012!C3yK\u000e,H/[8o\u0015\t!R#A\u0002tc2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\n\u0004\u0001q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$I5\tq\"\u0003\u0002&\u001f\tq!k]:D_2,XN\\*uCR\u001c\u0018!\u00039sK\u000eL7/[8o\u0007\u0001\u0001\"!H\u0015\n\u0005)r\"aA%oi\u0006)1oY1mK\u00061A(\u001b8jiz\"2AL\u00181!\t\u0019\u0003\u0001C\u0003'\u0007\u0001\u0007\u0001\u0006C\u0003,\u0007\u0001\u0007\u0001\u0006\u0006\u0002/e!)1\u0007\u0002a\u0001i\u0005\u0011A\r\u001e\t\u0003kaj\u0011A\u000e\u0006\u0003oM\tQ\u0001^=qKNL!!\u000f\u001c\u0003\u0017\u0011+7-[7bYRK\b/Z\u0001\u0006kB\u0004XM]\u000b\u0002yA\u0011Q'P\u0005\u0003}Y\u0012q\u0001R3dS6\fG.A\u0005vaB,'o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003;\tK!a\u0011\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u000b\u001a\t\t\u00111\u0001=\u0003\rAH%M\u0001\u0007kB\u0004XM\u001d\u0011\u0002\u000b1|w/\u001a:\u0002\u00131|w/\u001a:`I\u0015\fHCA!K\u0011\u001d)\u0015\"!AA\u0002q\na\u0001\\8xKJ\u0004\u0013aC4bi\",'o\u0015;biN$2!\u0011(W\u0011\u0015y5\u00021\u0001Q\u0003\r\u0011xn\u001e\t\u0003#Rk\u0011A\u0015\u0006\u0003'N\t\u0001bY1uC2L8\u000f^\u0005\u0003+J\u00131\"\u00138uKJt\u0017\r\u001c*po\")qk\u0003a\u0001Q\u00059qN\u001d3j]\u0006d\u0017\u0001E4bi\",'OV1mk\u0016\u001cF/\u0019;t)\t\t%\fC\u0003\\\u0019\u0001\u0007A(A\u0003wC2,X-A\nd_2dWm\u0019;fIN#\u0018\r^5ti&\u001c7/F\u0001_!\rir,Y\u0005\u0003Az\u0011Q!\u0011:sCf\u0004\"!\b2\n\u0005\rt\"aA!os\u0002")
public final class RssDecimalColumnStats
implements RssColumnStats {
    private final int precision;
    private final int scale;
    private Decimal upper;
    private Decimal lower;
    private int count;
    private int nullCount;
    private long sizeInBytes;

    @Override
    public void gatherNullStats() {
        RssColumnStats.gatherNullStats$(this);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public int nullCount() {
        return this.nullCount;
    }

    @Override
    public void nullCount_$eq(int x$1) {
        this.nullCount = x$1;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void sizeInBytes_$eq(long x$1) {
        this.sizeInBytes = x$1;
    }

    public Decimal upper() {
        return this.upper;
    }

    public void upper_$eq(Decimal x$1) {
        this.upper = x$1;
    }

    public Decimal lower() {
        return this.lower;
    }

    public void lower_$eq(Decimal x$1) {
        this.lower = x$1;
    }

    @Override
    public void gatherStats(InternalRow row, int ordinal) {
        if (!row.isNullAt(ordinal)) {
            Decimal value = row.getDecimal(ordinal, this.precision, this.scale);
            this.gatherValueStats(value);
        } else {
            this.gatherNullStats();
        }
    }

    public void gatherValueStats(Decimal value) {
        if (this.upper() == null || value.compareTo((Object)this.upper()) > 0) {
            this.upper_$eq(value);
        }
        if (this.lower() == null || value.compareTo((Object)this.lower()) < 0) {
            this.lower_$eq(value);
        }
        if (this.precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
            this.sizeInBytes_$eq(this.sizeInBytes() + 4L);
        } else if (this.precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            this.sizeInBytes_$eq(this.sizeInBytes() + 8L);
        } else {
            this.sizeInBytes_$eq(this.sizeInBytes() + (long)(4 + value.toJavaBigDecimal().unscaledValue().bitLength() / 8 + 1));
        }
        this.count_$eq(this.count() + 1);
    }

    @Override
    public Object[] collectedStatistics() {
        return new Object[]{this.lower(), this.upper(), BoxesRunTime.boxToInteger((int)this.nullCount()), BoxesRunTime.boxToInteger((int)this.count()), BoxesRunTime.boxToLong((long)this.sizeInBytes())};
    }

    public RssDecimalColumnStats(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
        RssColumnStats.$init$(this);
        this.upper = null;
        this.lower = null;
    }

    public RssDecimalColumnStats(DecimalType dt) {
        this(dt.precision(), dt.scale());
    }
}

