/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.Encoder;
import org.apache.spark.sql.execution.columnar.NativeRssColumnType;
import org.apache.spark.sql.execution.columnar.RSS_BOOLEAN$;
import org.apache.spark.sql.execution.columnar.RSS_BYTE$;
import org.apache.spark.sql.execution.columnar.RSS_COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.RSS_COMPACT_DECIMAL$;
import org.apache.spark.sql.execution.columnar.RSS_COMPACT_MINI_DECIMAL;
import org.apache.spark.sql.execution.columnar.RSS_COMPACT_MINI_DECIMAL$;
import org.apache.spark.sql.execution.columnar.RSS_DOUBLE$;
import org.apache.spark.sql.execution.columnar.RSS_FLOAT$;
import org.apache.spark.sql.execution.columnar.RSS_INT$;
import org.apache.spark.sql.execution.columnar.RSS_LONG$;
import org.apache.spark.sql.execution.columnar.RSS_SHORT$;
import org.apache.spark.sql.execution.columnar.RSS_STRING$;
import org.apache.spark.sql.execution.columnar.RssBatchBuilder;
import org.apache.spark.sql.execution.columnar.RssColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssColumnBuilder$;
import org.apache.spark.sql.execution.columnar.RssColumnarBatchBuilder$;
import org.apache.spark.sql.execution.columnar.RssCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssDictionaryEncoding;
import org.apache.spark.sql.execution.columnar.RssDictionaryEncoding$;
import org.apache.spark.sql.execution.columnar.RssNullableColumnBuilder;
import org.apache.spark.sql.execution.columnar.RssPassThrough$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u000f\u001f\u0001-B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001di\u0005\u00011A\u0005\u00029Cqa\u0014\u0001A\u0002\u0013\u0005\u0001\u000b\u0003\u0004W\u0001\u0001\u0006K\u0001\u000f\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0011\u00199\u0007\u0001)A\u00053\"9q\u000e\u0001b\u0001\n\u0003\u0001\bBB>\u0001A\u0003%\u0011\u000fC\u0005}\u0001\u0001\u0007\t\u0019!C\u0001{\"Y\u0011Q\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0004\u0011)\tY\u0001\u0001a\u0001\u0002\u0003\u0006KA \u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'A\u0001\"!\b\u0001\u0001\u0004%\tA\u0014\u0005\n\u0003?\u0001\u0001\u0019!C\u0001\u0003CAq!!\n\u0001A\u0003&\u0001\bC\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011q\b\u0001\u0005\u0002\u0005ur!CA!=\u0005\u0005\t\u0012AA\"\r!ib$!A\t\u0002\u0005\u0015\u0003B\u0002$\u001a\t\u0003\ti\u0005C\u0005\u0002Pe\t\n\u0011\"\u0001\u0002R!I\u0011qM\r\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0002\u0018%N\u001c8i\u001c7v[:\f'OQ1uG\"\u0014U/\u001b7eKJT!a\b\u0011\u0002\u0011\r|G.^7oCJT!!\t\u0012\u0002\u0013\u0015DXmY;uS>t'BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011C\u0001\u0001-!\tic&D\u0001\u001f\u0013\tycDA\bSgN\u0014\u0015\r^2i\u0005VLG\u000eZ3s\u0003\u0019\u00198\r[3nCB\u0011!'N\u0007\u0002g)\u0011AGI\u0001\u0006if\u0004Xm]\u0005\u0003mM\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003%\u0011\u0017\r^2i'&TX\r\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0002J]R\fQ\"\\1y\t&\u001cGOR1di>\u0014\bCA\u001dA\u0013\t\t%H\u0001\u0004E_V\u0014G.Z\u0001\u0010K:\u001cw\u000eZ5oO\u0016s\u0017M\u00197fIB\u0011\u0011\bR\u0005\u0003\u000bj\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0006\u0011&S5\n\u0014\t\u0003[\u0001AQ\u0001M\u0003A\u0002EBqaN\u0003\u0011\u0002\u0003\u0007\u0001\bC\u0003?\u000b\u0001\u0007q\bC\u0004C\u000bA\u0005\t\u0019A\"\u0002\rI|wo\u00118u+\u0005A\u0014A\u0003:po\u000esGo\u0018\u0013fcR\u0011\u0011\u000b\u0016\t\u0003sIK!a\u0015\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b+\u001e\t\t\u00111\u00019\u0003\rAH%M\u0001\be><8I\u001c;!\u00039!\u0018\u0010]3D_:4XM]:j_:,\u0012!\u0017\t\u0005sicv,\u0003\u0002\\u\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e\u0005\u00023;&\u0011al\r\u0002\t\t\u0006$\u0018\rV=qKB\u0012\u0001-\u001a\t\u0004[\u0005\u001c\u0017B\u00012\u001f\u0005Mq\u0015\r^5wKJ\u001b8oQ8mk6tG+\u001f9f!\t!W\r\u0004\u0001\u0005\u0013\u0019T\u0011\u0011!A\u0001\u0006\u0003A'aA0%c\u0005yA/\u001f9f\u0007>tg/\u001a:tS>t\u0007%\u0005\u0002jYB\u0011\u0011H[\u0005\u0003Wj\u0012qAT8uQ&tw\r\u0005\u00023[&\u0011an\r\u0002\u000b\u0003R|W.[2UsB,\u0017aC3oG>$WM]:BeJ,\u0012!\u001d\t\u0004sI$\u0018BA:;\u0005\u0015\t%O]1za\t)\u0018\u0010E\u0002.mbL!a\u001e\u0010\u0003\u000f\u0015s7m\u001c3feB\u0011A-\u001f\u0003\nu2\t\t\u0011!A\u0003\u0002!\u00141a\u0018\u00133\u00031)gnY8eKJ\u001c\u0018I\u001d:!\u00039\u0019w\u000e\\;n]\n+\u0018\u000e\u001c3feN,\u0012A \t\u0004sI|\bcA\u0017\u0002\u0002%\u0019\u00111\u0001\u0010\u0003!I\u001b8oQ8mk6t')^5mI\u0016\u0014\u0018AE2pYVlgNQ;jY\u0012,'o]0%KF$2!UA\u0005\u0011\u001d)f\"!AA\u0002y\fqbY8mk6t')^5mI\u0016\u00148\u000fI\u0001\f]\u0016<()^5mI\u0016\u00148\u000fF\u0001R\u0003A\u0011W/\u001b7e\u0007>dW/\u001c8CsR,7\u000f\u0006\u0002\u0002\u0016A!\u0011H]A\f!\rI\u0014\u0011D\u0005\u0004\u00037Q$\u0001\u0002\"zi\u0016\f\u0011\u0002^8uC2\u001c\u0016N_3\u0002\u001bQ|G/\u00197TSj,w\fJ3r)\r\t\u00161\u0005\u0005\b+N\t\t\u00111\u00019\u0003)!x\u000e^1m'&TX\rI\u0001\toJLG/\u001a*poR\u0019\u0011+a\u000b\t\u000f\u00055R\u00031\u0001\u00020\u0005\u0019!o\\<\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e#\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u001d\u0003g\u00111\"\u00138uKJt\u0017\r\u001c*po\u0006aq-\u001a;U_R\fGnU5{KR\t\u0001(A\u0005hKR\u0014vn^\"oi\u00069\"k]:D_2,XN\\1s\u0005\u0006$8\r\u001b\"vS2$WM\u001d\t\u0003[e\u00192!GA$!\rI\u0014\u0011J\u0005\u0004\u0003\u0017R$AB!osJ+g\r\u0006\u0002\u0002D\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u0015+\u0007a\n)f\u000b\u0002\u0002XA!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013!C;oG\",7m[3e\u0015\r\t\tGO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA3\u00037\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u000e\u0016\u0004\u0007\u0006U\u0003")
public class RssColumnarBatchBuilder
extends RssBatchBuilder {
    private final StructType schema;
    private final int batchSize;
    private final double maxDictFactor;
    private final boolean encodingEnabled;
    private int rowCnt;
    private final PartialFunction<DataType, NativeRssColumnType<? extends AtomicType>> typeConversion;
    private final Encoder<? extends AtomicType>[] encodersArr;
    private RssColumnBuilder[] columnBuilders;
    private int totalSize;

    public static boolean $lessinit$greater$default$4() {
        return RssColumnarBatchBuilder$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$2() {
        return RssColumnarBatchBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public int rowCnt() {
        return this.rowCnt;
    }

    public void rowCnt_$eq(int x$1) {
        this.rowCnt = x$1;
    }

    public PartialFunction<DataType, NativeRssColumnType<? extends AtomicType>> typeConversion() {
        return this.typeConversion;
    }

    public Encoder<? extends AtomicType>[] encodersArr() {
        return this.encodersArr;
    }

    public RssColumnBuilder[] columnBuilders() {
        return this.columnBuilders;
    }

    public void columnBuilders_$eq(RssColumnBuilder[] x$1) {
        this.columnBuilders = x$1;
    }

    @Override
    public void newBuilders() {
        this.totalSize_$eq(0);
        this.rowCnt_$eq(0);
        IntRef i = IntRef.create((int)-1);
        this.columnBuilders_$eq((RssColumnBuilder[])((TraversableOnce)this.schema.map((Function1 & Serializable & scala.Serializable)attribute -> {
            RssDictionaryEncoding.RssEncoder rssEncoder;
            ++i$1.elem;
            Encoder<? extends AtomicType> encoder = this.encodersArr()[i$1.elem];
            if (encoder instanceof RssDictionaryEncoding.RssEncoder && !(rssEncoder = (RssDictionaryEncoding.RssEncoder)encoder).overflow()) {
                rssEncoder.cleanBatch();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return RssColumnBuilder$.MODULE$.apply(attribute.dataType(), $this.batchSize, attribute.name(), $this.encodingEnabled, this.encodersArr()[i$1.elem]);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RssColumnBuilder.class)));
    }

    @Override
    public byte[] buildColumnBytes() {
        ByteArrayOutputStream giantBuffer = new ByteArrayOutputStream();
        byte[] rowCntBytes = this.int2ByteArray(this.rowCnt());
        giantBuffer.write(rowCntBytes);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.columnBuilders())).foreach((Function1 & Serializable & scala.Serializable)builder -> {
            RssColumnarBatchBuilder.$anonfun$buildColumnBytes$1(this, giantBuffer, builder);
            return BoxedUnit.UNIT;
        });
        return giantBuffer.toByteArray();
    }

    public int totalSize() {
        return this.totalSize;
    }

    public void totalSize_$eq(int x$1) {
        this.totalSize = x$1;
    }

    @Override
    public void writeRow(InternalRow row) {
        for (int i = 0; i < row.numFields(); ++i) {
            this.columnBuilders()[i].appendFrom(row, i);
        }
        this.rowCnt_$eq(this.rowCnt() + 1);
    }

    public int getTotalSize() {
        int tempTotalSize = 0;
        for (int i = 0; i < this.schema.length(); ++i) {
            BoxedUnit boxedUnit;
            RssColumnBuilder rssColumnBuilder = this.columnBuilders()[i];
            if (rssColumnBuilder instanceof RssCompressibleColumnBuilder) {
                RssCompressibleColumnBuilder rssCompressibleColumnBuilder = (RssCompressibleColumnBuilder)rssColumnBuilder;
                tempTotalSize += (int)rssCompressibleColumnBuilder.getTotalSize();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (rssColumnBuilder instanceof RssNullableColumnBuilder) {
                RssNullableColumnBuilder rssNullableColumnBuilder = (RssNullableColumnBuilder)rssColumnBuilder;
                tempTotalSize += (int)rssNullableColumnBuilder.getTotalSize();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        this.totalSize_$eq(tempTotalSize + 4 + 4 * this.schema.length());
        return this.totalSize();
    }

    @Override
    public int getRowCnt() {
        return this.rowCnt();
    }

    public static final /* synthetic */ void $anonfun$buildColumnBytes$1(RssColumnarBatchBuilder $this, ByteArrayOutputStream giantBuffer$1, RssColumnBuilder builder) {
        ByteBuffer buffers = builder.build();
        byte[] bytes = JavaUtils.bufferToArray((ByteBuffer)buffers);
        byte[] columnBuilderBytes = $this.int2ByteArray(bytes.length);
        giantBuffer$1.write(columnBuilderBytes);
        giantBuffer$1.write(bytes);
    }

    public RssColumnarBatchBuilder(StructType schema, int batchSize, double maxDictFactor, boolean encodingEnabled) {
        this.schema = schema;
        this.batchSize = batchSize;
        this.maxDictFactor = maxDictFactor;
        this.encodingEnabled = encodingEnabled;
        this.rowCnt = 0;
        this.typeConversion = new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends DataType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_17;
                boolean bl = false;
                DecimalType decimalType = null;
                A1 A1 = x1;
                if (IntegerType$.MODULE$.equals(A1)) {
                    RSS_INT$ rSS_INT$ = RSS_INT$.MODULE$;
                    return var3_17;
                }
                if (LongType$.MODULE$.equals(A1)) {
                    RSS_LONG$ rSS_LONG$ = RSS_LONG$.MODULE$;
                    return var3_17;
                }
                if (StringType$.MODULE$.equals(A1)) {
                    RSS_STRING$ rSS_STRING$ = RSS_STRING$.MODULE$;
                    return var3_17;
                }
                if (BooleanType$.MODULE$.equals(A1)) {
                    RSS_BOOLEAN$ rSS_BOOLEAN$ = RSS_BOOLEAN$.MODULE$;
                    return var3_17;
                }
                if (ShortType$.MODULE$.equals(A1)) {
                    RSS_SHORT$ rSS_SHORT$ = RSS_SHORT$.MODULE$;
                    return var3_17;
                }
                if (ByteType$.MODULE$.equals(A1)) {
                    RSS_BYTE$ rSS_BYTE$ = RSS_BYTE$.MODULE$;
                    return var3_17;
                }
                if (FloatType$.MODULE$.equals(A1)) {
                    RSS_FLOAT$ rSS_FLOAT$ = RSS_FLOAT$.MODULE$;
                    return var3_17;
                }
                if (DoubleType$.MODULE$.equals(A1)) {
                    RSS_DOUBLE$ rSS_DOUBLE$ = RSS_DOUBLE$.MODULE$;
                    return var3_17;
                }
                if (A1 instanceof DecimalType) {
                    bl = true;
                    decimalType = (DecimalType)A1;
                    if (decimalType.precision() <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                        RSS_COMPACT_MINI_DECIMAL rSS_COMPACT_MINI_DECIMAL = RSS_COMPACT_MINI_DECIMAL$.MODULE$.apply(decimalType);
                        return var3_17;
                    }
                }
                if (bl && decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                    RSS_COMPACT_DECIMAL rSS_COMPACT_DECIMAL = RSS_COMPACT_DECIMAL$.MODULE$.apply(decimalType);
                    return var3_17;
                }
                Object var3_16 = null;
                return var3_17;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(DataType x1) {
                boolean bl = false;
                DecimalType decimalType = null;
                DataType dataType = x1;
                if (IntegerType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (LongType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (StringType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (BooleanType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (ShortType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (ByteType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (FloatType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (DoubleType$.MODULE$.equals(dataType)) {
                    return true;
                }
                if (dataType instanceof DecimalType) {
                    bl = true;
                    decimalType = (DecimalType)dataType;
                    if (decimalType.precision() <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                        return true;
                    }
                }
                if (!bl) return true;
                if (decimalType.precision() > Decimal$.MODULE$.MAX_LONG_DIGITS()) return true;
                return true;
            }
        };
        this.encodersArr = (Encoder[])((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)attribute -> {
            Encoder encoder;
            NativeRssColumnType nativeColumnType = (NativeRssColumnType)this.typeConversion().apply((Object)attribute.dataType());
            if (nativeColumnType == null) {
                encoder = null;
            } else if ($this.encodingEnabled && RssDictionaryEncoding$.MODULE$.supports(nativeColumnType)) {
                RssDictionaryEncoding$.MODULE$.MAX_DICT_SIZE_$eq((short)Math.min(32767.0, (double)$this.batchSize * $this.maxDictFactor));
                encoder = RssDictionaryEncoding$.MODULE$.encoder(nativeColumnType);
            } else {
                encoder = RssPassThrough$.MODULE$.encoder(nativeColumnType);
            }
            return encoder;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Encoder.class));
        this.totalSize = 0;
    }
}

