/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.execution.columnar.RssBooleanColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssByteColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssCompactDecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssDecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssDoubleColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssFloatColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssIntColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssLongColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssNativeColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssNullColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssShortColumnAccessor;
import org.apache.spark.sql.execution.columnar.RssStringColumnAccessor;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class RssColumnAccessor$ {
    public static RssColumnAccessor$ MODULE$;

    static {
        new RssColumnAccessor$();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public RssColumnAccessor apply(DataType dataType, ByteBuffer buffer) {
        void var3_18;
        ByteBuffer buf = buffer.order(ByteOrder.nativeOrder());
        boolean bl = false;
        DecimalType decimalType = null;
        DataType dataType2 = dataType;
        if (NullType$.MODULE$.equals(dataType2)) {
            RssNullColumnAccessor rssNullColumnAccessor = new RssNullColumnAccessor(buf);
            return var3_18;
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            RssBooleanColumnAccessor rssBooleanColumnAccessor = new RssBooleanColumnAccessor(buf);
            return var3_18;
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            RssByteColumnAccessor rssByteColumnAccessor = new RssByteColumnAccessor(buf);
            return var3_18;
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            RssShortColumnAccessor rssShortColumnAccessor = new RssShortColumnAccessor(buf);
            return var3_18;
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            RssIntColumnAccessor rssIntColumnAccessor = new RssIntColumnAccessor(buf);
            return var3_18;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            RssLongColumnAccessor rssLongColumnAccessor = new RssLongColumnAccessor(buf);
            return var3_18;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            RssFloatColumnAccessor rssFloatColumnAccessor = new RssFloatColumnAccessor(buf);
            return var3_18;
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            RssDoubleColumnAccessor rssDoubleColumnAccessor = new RssDoubleColumnAccessor(buf);
            return var3_18;
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            RssStringColumnAccessor rssStringColumnAccessor = new RssStringColumnAccessor(buf);
            return var3_18;
        }
        if (dataType2 instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType2;
            if (decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                RssCompactDecimalColumnAccessor rssCompactDecimalColumnAccessor = new RssCompactDecimalColumnAccessor(buf, decimalType);
                return var3_18;
            }
        }
        if (!bl) throw new Exception(new StringBuilder(18).append("not support type: ").append(dataType2).toString());
        RssDecimalColumnAccessor rssDecimalColumnAccessor = new RssDecimalColumnAccessor(buf, decimalType);
        return var3_18;
    }

    public void decompress(RssColumnAccessor columnAccessor, WritableColumnVector columnVector, int numRows) {
        RssColumnAccessor rssColumnAccessor = columnAccessor;
        if (rssColumnAccessor instanceof RssNativeColumnAccessor) {
            RssNativeColumnAccessor rssNativeColumnAccessor = (RssNativeColumnAccessor)rssColumnAccessor;
            rssNativeColumnAccessor.decompress(columnVector, numRows);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (rssColumnAccessor instanceof RssDecimalColumnAccessor) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> columnAccessor.extractToColumnVector(columnVector, x$1));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new RuntimeException("Not support non-primitive type now");
        }
    }

    public void decompress(byte[] array, WritableColumnVector columnVector, DataType dataType, int numRows) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        RssColumnAccessor columnAccessor = this.apply(dataType, byteBuffer);
        this.decompress(columnAccessor, columnVector, numRows);
    }

    private RssColumnAccessor$() {
        MODULE$ = this;
    }
}

