/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.reflect.DynConstructors;
import org.apache.celeborn.reflect.DynFields;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.sql.execution.UnsafeRowSerializer;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SparkUtils.class);
    private static final DynFields.UnboundField<SQLMetric> DATA_SIZE_METRIC_FIELD = DynFields.builder().hiddenImpl(UnsafeRowSerializer.class, "dataSize").defaultAlwaysNull().build();
    private static final DynMethods.UnboundMethod GET_READER_METHOD = DynMethods.builder("getReader").impl(SortShuffleManager.class, ShuffleHandle.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TaskContext.class, ShuffleReadMetricsReporter.class).orNoop().build();
    private static final DynMethods.UnboundMethod LEGACY_GET_READER_METHOD = DynMethods.builder("getReader").impl(SortShuffleManager.class, ShuffleHandle.class, Integer.TYPE, Integer.TYPE, TaskContext.class, ShuffleReadMetricsReporter.class).orNoop().build();
    private static final DynFields.UnboundField<StructType> SCHEMA_FIELD = DynFields.builder().hiddenImpl(ShuffleDependency.class, "schema").defaultAlwaysNull().build();

    public static MapStatus createMapStatus(BlockManagerId loc, long[] uncompressedSizes, long mapTaskId) {
        return MapStatus$.MODULE$.apply(loc, uncompressedSizes, mapTaskId);
    }

    public static SQLMetric getDataSize(UnsafeRowSerializer serializer) {
        SQLMetric dataSizeMetric = DATA_SIZE_METRIC_FIELD.get(serializer);
        if (dataSizeMetric == null) {
            LOG.warn("Failed to get dataSize metric, AQE won't work properly.");
        }
        return dataSizeMetric;
    }

    public static long[] unwrap(LongAdder[] adders) {
        int adderCounter = adders.length;
        long[] res = new long[adderCounter];
        for (int i = 0; i < adderCounter; ++i) {
            res[i] = adders[i].longValue();
        }
        return res;
    }

    public static CelebornConf fromSparkConf(SparkConf conf) {
        CelebornConf tmpCelebornConf = new CelebornConf();
        for (Tuple2 kv : conf.getAll()) {
            if (!((String)kv._1).startsWith("spark.celeborn.") && !((String)kv._1).startsWith("spark.rss.")) continue;
            tmpCelebornConf.set(((String)kv._1).substring("spark.".length()), (String)kv._2);
        }
        return tmpCelebornConf;
    }

    public static String genNewAppId(SparkContext context) {
        return (String)context.applicationAttemptId().map(id -> context.applicationId() + "_" + id).getOrElse(() -> ((SparkContext)context).applicationId());
    }

    public static <T> T instantiateClass(String className, SparkConf conf, Boolean isDriver) {
        DynConstructors.Ctor dynConstructor = DynConstructors.builder().impl(className, SparkConf.class, Boolean.TYPE).impl(className, SparkConf.class).impl(className, new Class[0]).build();
        return (T)dynConstructor.newInstance(conf, isDriver);
    }

    public static <K, C> ShuffleReader<K, C> getReader(SortShuffleManager sortShuffleManager, ShuffleHandle handle, Integer startMapIndex, Integer endMapIndex, Integer startPartition, Integer endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        ShuffleReader shuffleReader = (ShuffleReader)GET_READER_METHOD.bind(sortShuffleManager).invoke(handle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics);
        if (shuffleReader != null) {
            return shuffleReader;
        }
        shuffleReader = (ShuffleReader)LEGACY_GET_READER_METHOD.bind(sortShuffleManager).invoke(handle, startPartition, endPartition, context, metrics);
        assert (shuffleReader != null);
        return shuffleReader;
    }

    public static StructType getSchema(ShuffleDependency<?, ?, ?> dep) throws IOException {
        StructType schema = SCHEMA_FIELD.bind(dep).get();
        if (schema == null) {
            throw new IOException("Failed to get Schema, columnar shuffle won't work properly.");
        }
        return schema;
    }
}

