/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.write.DataPusher;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.Utils;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TooLargePageException;
import org.apache.spark.shuffle.celeborn.ShuffleInMemorySorter;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UnsafeAlignedOffset;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortBasedPusher
extends MemoryConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SortBasedPusher.class);
    private ShuffleInMemorySorter inMemSorter;
    private final LinkedList<MemoryBlock> allocatedPages = new LinkedList();
    private MemoryBlock currentPage = null;
    private long pageCursor = -1L;
    private final ShuffleClient rssShuffleClient;
    private final DataPusher dataPusher;
    private final int pushBufferMaxSize;
    private final long pushSortMemoryThreshold;
    final int uaoSize = UnsafeAlignedOffset.getUaoSize();
    static final long size8k = Utils.byteStringAsBytes("8k");
    String appId;
    int shuffleId;
    int mapId;
    int attemptNumber;
    long taskAttemptId;
    int numMappers;
    int numPartitions;
    CelebornConf conf;
    Consumer<Integer> afterPush;
    LongAdder[] mapStatusLengths;

    public SortBasedPusher(TaskMemoryManager memoryManager, ShuffleClient rssShuffleClient, String appId, int shuffleId, int mapId, int attemptNumber, long taskAttemptId, int numMappers, int numPartitions, CelebornConf conf, Consumer<Integer> afterPush, LongAdder[] mapStatusLengths) throws IOException {
        super(memoryManager, (long)((int)Math.min(0x8000000L, memoryManager.pageSizeBytes())), memoryManager.getTungstenMemoryMode());
        this.rssShuffleClient = rssShuffleClient;
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.mapId = mapId;
        this.attemptNumber = attemptNumber;
        this.taskAttemptId = taskAttemptId;
        this.numMappers = numMappers;
        this.numPartitions = numPartitions;
        this.conf = conf;
        this.afterPush = afterPush;
        this.mapStatusLengths = mapStatusLengths;
        this.dataPusher = new DataPusher(appId, shuffleId, mapId, attemptNumber, taskAttemptId, numMappers, numPartitions, conf, rssShuffleClient, afterPush, mapStatusLengths);
        this.pushBufferMaxSize = conf.pushBufferMaxSize();
        this.pushSortMemoryThreshold = conf.pushSortMemoryThreshold();
        this.inMemSorter = new ShuffleInMemorySorter(this, 0x400000);
    }

    public long pushData() throws IOException {
        ShuffleInMemorySorter.ShuffleSorterIterator sortedRecords = this.inMemSorter.getSortedIterator();
        byte[] dataBuf = new byte[this.pushBufferMaxSize];
        int offSet = 0;
        int currentPartition = -1;
        while (sortedRecords.hasNext()) {
            long recordOffsetInPage;
            long recordPointer;
            Object recordPage;
            int recordSize;
            sortedRecords.loadNext();
            int partition = sortedRecords.packedRecordPointer.getPartitionId();
            assert (partition >= currentPartition);
            if (partition != currentPartition) {
                if (currentPartition == -1) {
                    currentPartition = partition;
                } else {
                    int bytesWritten = this.rssShuffleClient.mergeData(this.appId, this.shuffleId, this.mapId, this.attemptNumber, currentPartition, dataBuf, 0, offSet, this.numMappers, this.numPartitions);
                    this.mapStatusLengths[currentPartition].add(bytesWritten);
                    this.afterPush.accept(bytesWritten);
                    currentPartition = partition;
                    offSet = 0;
                }
            }
            if (offSet + (recordSize = UnsafeAlignedOffset.getSize((Object)(recordPage = this.taskMemoryManager.getPage(recordPointer = sortedRecords.packedRecordPointer.getRecordPointer())), (long)(recordOffsetInPage = this.taskMemoryManager.getOffsetInPage(recordPointer)))) > dataBuf.length) {
                this.dataPusher.addTask(partition, dataBuf, offSet);
                offSet = 0;
            }
            long recordReadPosition = recordOffsetInPage + (long)this.uaoSize;
            Platform.copyMemory((Object)recordPage, (long)recordReadPosition, (Object)dataBuf, (long)(Platform.BYTE_ARRAY_OFFSET + offSet), (long)recordSize);
            offSet += recordSize;
        }
        if (offSet > 0) {
            this.dataPusher.addTask(currentPartition, dataBuf, offSet);
        }
        long freedBytes = this.freeMemory();
        this.inMemSorter.freeMemory();
        return freedBytes;
    }

    public void insertRecord(Object recordBase, long recordOffset, int recordSize, int partitionId, boolean copySize) throws IOException {
        if (this.getUsed() > this.pushSortMemoryThreshold && this.pageCursor + size8k > this.currentPage.getBaseOffset() + this.currentPage.size()) {
            logger.info("Memory Used across threshold, trigger push. Memory: " + this.getUsed() + ", currentPage size: " + this.currentPage.size());
            this.pushData();
        }
        int uaoSize = UnsafeAlignedOffset.getUaoSize();
        int required = copySize ? recordSize + 4 + uaoSize : recordSize + uaoSize;
        this.allocateMemoryForRecordIfNecessary(required);
        assert (this.currentPage != null);
        Object base = this.currentPage.getBaseObject();
        long recordAddress = this.taskMemoryManager.encodePageNumberAndOffset(this.currentPage, this.pageCursor);
        if (copySize) {
            UnsafeAlignedOffset.putSize((Object)base, (long)this.pageCursor, (int)(recordSize + 4));
            this.pageCursor += (long)uaoSize;
            Platform.putInt((Object)base, (long)this.pageCursor, (int)Integer.reverseBytes(recordSize));
            this.pageCursor += 4L;
            Platform.copyMemory((Object)recordBase, (long)recordOffset, (Object)base, (long)this.pageCursor, (long)recordSize);
            this.pageCursor += (long)recordSize;
        } else {
            UnsafeAlignedOffset.putSize((Object)base, (long)this.pageCursor, (int)recordSize);
            this.pageCursor += (long)uaoSize;
            Platform.copyMemory((Object)recordBase, (long)recordOffset, (Object)base, (long)this.pageCursor, (long)recordSize);
            this.pageCursor += (long)recordSize;
        }
        this.inMemSorter.insertRecord(recordAddress, partitionId);
    }

    private void growPointerArrayIfNecessary() throws IOException {
        assert (this.inMemSorter != null);
        if (!this.inMemSorter.hasSpaceForAnotherRecord()) {
            LongArray array;
            block8: {
                if (this.inMemSorter.numRecords() <= 0) {
                    LongArray array2 = this.allocateArray(this.inMemSorter.getInitialSize());
                    this.inMemSorter.expandPointerArray(array2);
                    return;
                }
                long used = this.inMemSorter.getMemoryUsage();
                array = null;
                try {
                    array = this.allocateArray(used / 8L * 2L);
                }
                catch (TooLargePageException e) {
                    logger.info("Pushdata in growPointerArrayIfNecessary, memory used " + this.getUsed());
                    this.pushData();
                }
                catch (SparkOutOfMemoryError e) {
                    if (this.inMemSorter.numRecords() <= 0) break block8;
                    logger.error("Unable to grow the pointer array");
                    throw e;
                }
            }
            if (this.inMemSorter.numRecords() <= 0) {
                if (array != null) {
                    this.freeArray(array);
                }
                array = this.allocateArray(this.inMemSorter.getInitialSize());
            }
            this.inMemSorter.expandPointerArray(array);
        }
    }

    private void acquireNewPageIfNecessary(int required) {
        if (this.currentPage == null || this.pageCursor + (long)required > this.currentPage.getBaseOffset() + this.currentPage.size()) {
            this.currentPage = this.allocatePage(required);
            this.pageCursor = this.currentPage.getBaseOffset();
            this.allocatedPages.add(this.currentPage);
        }
    }

    private void allocateMemoryForRecordIfNecessary(int required) throws IOException {
        this.growPointerArrayIfNecessary();
        this.acquireNewPageIfNecessary(required);
        this.growPointerArrayIfNecessary();
    }

    public long spill(long l, MemoryConsumer memoryConsumer) throws IOException {
        logger.info("Pushdata in spill, memory used " + this.getUsed());
        if (this.getUsed() != 0L) {
            logger.info("Pushdata is not empty , do push.");
            return this.pushData();
        }
        return 0L;
    }

    private long freeMemory() {
        long memoryFreed = 0L;
        for (MemoryBlock block : this.allocatedPages) {
            memoryFreed += block.size();
            this.freePage(block);
        }
        this.allocatedPages.clear();
        this.currentPage = null;
        this.pageCursor = 0L;
        return memoryFreed;
    }

    public void cleanupResources() {
        this.freeMemory();
        if (this.inMemSorter != null) {
            this.inMemSorter.freeMemory();
            this.inMemSorter = null;
        }
    }

    public void close() throws IOException {
        this.cleanupResources();
        this.dataPusher.waitOnTermination();
    }

    public long getUsed() {
        return super.getUsed();
    }
}

