/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.util.LinkedList;

public class SendBufferPool {
    private static volatile SendBufferPool _instance;
    private final int capacity;
    private LinkedList<byte[][]> buffers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SendBufferPool get(int capacity) {
        if (_instance != null) return _instance;
        Class<SendBufferPool> clazz = SendBufferPool.class;
        synchronized (SendBufferPool.class) {
            if (_instance != null) return _instance;
            _instance = new SendBufferPool(capacity);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    public SendBufferPool(int capacity) {
        this.capacity = capacity;
        this.buffers = new LinkedList();
    }

    public synchronized byte[][] acquireBuffer(int numPartitions) {
        for (int i = 0; i < this.buffers.size(); ++i) {
            if (this.buffers.get(i).length != numPartitions) continue;
            return this.buffers.remove(i);
        }
        if (this.buffers.size() == this.capacity) {
            this.buffers.removeFirst();
        }
        return null;
    }

    public synchronized void returnBuffer(byte[][] buffer) {
        if (this.buffers.size() == this.capacity) {
            this.buffers.removeFirst();
        }
        this.buffers.addLast(buffer);
    }
}

