/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import java.util.concurrent.ThreadFactory;
import org.apache.celeborn.common.network.util.IOMode;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.network.util.TransportFrameDecoder;
import org.apache.celeborn.common.network.util.TransportFrameDecoderWithBufferSupplier;
import org.apache.celeborn.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.celeborn.shaded.io.netty.channel.EventLoopGroup;
import org.apache.celeborn.shaded.io.netty.channel.ServerChannel;
import org.apache.celeborn.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.celeborn.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.celeborn.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.celeborn.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.celeborn.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.celeborn.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.celeborn.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.celeborn.shaded.io.netty.util.internal.PlatformDependent;

public class NettyUtils {
    public static ThreadFactory createThreadFactory(String threadPoolPrefix) {
        return new DefaultThreadFactory(threadPoolPrefix, true);
    }

    public static EventLoopGroup createEventLoop(IOMode mode, int numThreads, String threadPrefix) {
        ThreadFactory threadFactory = NettyUtils.createThreadFactory(threadPrefix);
        switch (mode) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends Channel> getClientChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends ServerChannel> getServerChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioServerSocketChannel.class;
            }
            case EPOLL: {
                return EpollServerSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static ChannelInboundHandlerAdapter createFrameDecoder(TransportConf conf) {
        if (conf.decoderMode().equals("default")) {
            return new TransportFrameDecoder();
        }
        if (conf.decoderMode().equals("supplier")) {
            return new TransportFrameDecoderWithBufferSupplier();
        }
        return new TransportFrameDecoder();
    }

    public static String getRemoteAddress(Channel channel) {
        if (channel != null && channel.remoteAddress() != null) {
            return channel.remoteAddress().toString();
        }
        return "<unknown remote>";
    }

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        if (numCores == 0) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        return new PooledByteBufAllocator(allowDirectBufs && PlatformDependent.directBufferPreferred(), Math.min(PooledByteBufAllocator.defaultNumHeapArena(), numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), allowDirectBufs ? numCores : 0), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), allowCache ? PooledByteBufAllocator.defaultSmallCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultNormalCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultUseCacheForAllThreads() : false);
    }
}

