/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.client.compress.Decompressor;
import org.apache.celeborn.client.read.DfsPartitionReader;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.client.read.WorkerPartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RssInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(RssInputStream.class);
    private static final RssInputStream emptyInputStream = new RssInputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return -1;
        }

        @Override
        public void setCallback(MetricsCallback callback) {
        }
    };

    public static RssInputStream create(CelebornConf conf, TransportClientFactory clientFactory, String shuffleKey, PartitionLocation[] locations, int[] attempts, int attemptNumber, int startMapIndex, int endMapIndex) throws IOException {
        if (locations == null || locations.length == 0) {
            return emptyInputStream;
        }
        return new RssInputStreamImpl(conf, clientFactory, shuffleKey, Arrays.copyOf(locations, locations.length), attempts, attemptNumber, startMapIndex, endMapIndex);
    }

    public static RssInputStream empty() {
        return emptyInputStream;
    }

    public abstract void setCallback(MetricsCallback var1);

    private static final class RssInputStreamImpl
    extends RssInputStream {
        private static final Random RAND = new Random();
        private final CelebornConf conf;
        private final TransportClientFactory clientFactory;
        private final String shuffleKey;
        private final PartitionLocation[] locations;
        private final int[] attempts;
        private final int attemptNumber;
        private final int startMapIndex;
        private final int endMapIndex;
        private final Map<Integer, Set<Integer>> batchesRead = new HashMap<Integer, Set<Integer>>();
        private byte[] compressedBuf;
        private byte[] decompressedBuf;
        private final Decompressor decompressor;
        private ByteBuf currentChunk;
        private PartitionReader currentReader;
        private final int fetchChunkMaxRetry;
        private int fetchChunkRetryCnt = 0;
        int retryWaitMs;
        private int fileIndex;
        private int position;
        private int limit;
        private MetricsCallback callback;
        private final int BATCH_HEADER_SIZE = 16;
        private final byte[] sizeBuf = new byte[16];
        private LongAdder skipCount = new LongAdder();
        private final boolean rangeReadFilter;

        RssInputStreamImpl(CelebornConf conf, TransportClientFactory clientFactory, String shuffleKey, PartitionLocation[] locations, int[] attempts, int attemptNumber, int startMapIndex, int endMapIndex) throws IOException {
            this.conf = conf;
            this.clientFactory = clientFactory;
            this.shuffleKey = shuffleKey;
            this.locations = (PartitionLocation[])Utils.randomizeInPlace(locations, RAND);
            this.attempts = attempts;
            this.attemptNumber = attemptNumber;
            this.startMapIndex = startMapIndex;
            this.endMapIndex = endMapIndex;
            this.rangeReadFilter = conf.shuffleRangeReadFilterEnabled();
            int headerLen = Decompressor.getCompressionHeaderLength(conf);
            int blockSize = conf.pushBufferMaxSize() + headerLen;
            this.compressedBuf = new byte[blockSize];
            this.decompressedBuf = new byte[blockSize];
            this.decompressor = Decompressor.getDecompressor(conf);
            this.fetchChunkMaxRetry = conf.fetchMaxRetries();
            TransportConf transportConf = Utils.fromCelebornConf(conf, "data", 0);
            this.retryWaitMs = transportConf.ioRetryWaitTimeMs();
            this.moveToNextReader();
        }

        private boolean skipLocation(int startMapIndex, int endMapIndex, PartitionLocation location) {
            if (!this.rangeReadFilter) {
                return false;
            }
            if (endMapIndex == Integer.MAX_VALUE) {
                return false;
            }
            RoaringBitmap bitmap = location.getMapIdBitMap();
            if (bitmap == null && location.getPeer() != null) {
                bitmap = location.getPeer().getMapIdBitMap();
            }
            for (int i = startMapIndex; i < endMapIndex; ++i) {
                if (!bitmap.contains(i)) continue;
                return false;
            }
            return true;
        }

        private PartitionLocation nextReadableLocation() {
            int locationCount = this.locations.length;
            if (this.fileIndex >= locationCount) {
                return null;
            }
            PartitionLocation currentLocation = this.locations[this.fileIndex];
            while (this.skipLocation(this.startMapIndex, this.endMapIndex, currentLocation)) {
                this.skipCount.increment();
                ++this.fileIndex;
                if (this.fileIndex == locationCount) {
                    return null;
                }
                currentLocation = this.locations[this.fileIndex];
            }
            this.fetchChunkRetryCnt = 0;
            return currentLocation;
        }

        private void moveToNextReader() throws IOException {
            PartitionLocation currentLocation;
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
            }
            if ((currentLocation = this.nextReadableLocation()) == null) {
                return;
            }
            this.currentReader = this.createReaderWithRetry(currentLocation);
            ++this.fileIndex;
            while (!this.currentReader.hasNext()) {
                this.currentReader.close();
                this.currentReader = null;
                currentLocation = this.nextReadableLocation();
                if (currentLocation == null) {
                    return;
                }
                this.currentReader = this.createReaderWithRetry(currentLocation);
                ++this.fileIndex;
            }
            this.currentChunk = this.getNextChunk();
        }

        private PartitionReader createReaderWithRetry(PartitionLocation location) throws IOException {
            while (this.fetchChunkRetryCnt < this.fetchChunkMaxRetry) {
                try {
                    return this.createReader(location, this.fetchChunkRetryCnt, this.fetchChunkMaxRetry);
                }
                catch (Exception e) {
                    ++this.fetchChunkRetryCnt;
                    if (location.getPeer() != null) {
                        location = location.getPeer();
                        logger.warn("CreatePartitionReader failed {}/{} times, change to peer", (Object)this.fetchChunkRetryCnt, (Object)this.fetchChunkMaxRetry);
                        continue;
                    }
                    logger.warn("CreatePartitionReader failed {}/{} times, retry the same location", (Object)this.fetchChunkRetryCnt, (Object)this.fetchChunkMaxRetry);
                    Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                }
            }
            throw new IOException("createPartitionReader failed!");
        }

        private ByteBuf getNextChunk() throws IOException {
            while (this.fetchChunkRetryCnt < this.fetchChunkMaxRetry) {
                try {
                    return this.currentReader.next();
                }
                catch (Exception e) {
                    ++this.fetchChunkRetryCnt;
                    this.currentReader.close();
                    if (this.fetchChunkRetryCnt == this.fetchChunkMaxRetry) {
                        logger.warn("Fetch chunk fail exceeds max retry {}", (Object)this.fetchChunkRetryCnt);
                        throw new IOException("Fetch chunk failed for " + this.fetchChunkRetryCnt + " times");
                    }
                    if (this.currentReader.getLocation().getPeer() != null) {
                        logger.warn("Fetch chunk failed {}/{} times, change to peer", (Object)this.fetchChunkRetryCnt, (Object)this.fetchChunkMaxRetry);
                        this.currentReader = this.createReaderWithRetry(this.currentReader.getLocation().getPeer());
                        continue;
                    }
                    logger.warn("Fetch chunk failed {}/{} times", (Object)this.fetchChunkRetryCnt, (Object)this.fetchChunkMaxRetry);
                    Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                    this.currentReader = this.createReaderWithRetry(this.currentReader.getLocation());
                }
            }
            throw new IOException("Fetch chunk failed!");
        }

        private PartitionReader createReader(PartitionLocation location, int fetchChunkRetryCnt, int fetchChunkMaxRetry) throws IOException {
            if (location.getPeer() == null) {
                logger.debug("Partition {} has only one partition replica.", (Object)location);
            }
            if (location.getPeer() != null && this.attemptNumber % 2 == 1) {
                location = location.getPeer();
                logger.debug("Read peer {} for attempt {}.", (Object)location, (Object)this.attemptNumber);
            }
            logger.debug("create reader for location {}", (Object)location);
            StorageInfo storageInfo = location.getStorageInfo();
            if (storageInfo.getType() == StorageInfo.Type.HDD || storageInfo.getType() == StorageInfo.Type.SSD) {
                return new WorkerPartitionReader(this.conf, this.shuffleKey, location, this.clientFactory, this.startMapIndex, this.endMapIndex, fetchChunkRetryCnt, fetchChunkMaxRetry);
            }
            if (storageInfo.getType() == StorageInfo.Type.HDFS) {
                return new DfsPartitionReader(this.conf, this.shuffleKey, location, this.clientFactory, this.startMapIndex, this.endMapIndex);
            }
            throw new IOException("Unknown storage info " + storageInfo + " to read location " + location);
        }

        @Override
        public void setCallback(MetricsCallback callback) {
            this.callback = callback;
        }

        @Override
        public int read() throws IOException {
            if (this.position < this.limit) {
                byte b = this.decompressedBuf[this.position];
                ++this.position;
                return b & 0xFF;
            }
            if (!this.fillBuffer()) {
                return -1;
            }
            if (this.position >= this.limit) {
                return this.read();
            }
            byte b = this.decompressedBuf[this.position];
            ++this.position;
            return b & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readBytes;
            int bytesToRead;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            for (readBytes = 0; readBytes < len; readBytes += bytesToRead) {
                while (this.position >= this.limit) {
                    if (this.fillBuffer()) continue;
                    return readBytes > 0 ? readBytes : -1;
                }
                bytesToRead = Math.min(this.limit - this.position, len - readBytes);
                System.arraycopy(this.decompressedBuf, this.position, b, off + readBytes, bytesToRead);
                this.position += bytesToRead;
            }
            return readBytes;
        }

        @Override
        public void close() {
            int locationsCount = this.locations.length;
            logger.debug("total location count {} read {} skip {}", new Object[]{locationsCount, (long)locationsCount - this.skipCount.sum(), this.skipCount.sum()});
            if (this.currentChunk != null) {
                logger.debug("Release chunk {}", (Object)this.currentChunk);
                this.currentChunk.release();
                this.currentChunk = null;
            }
            if (this.currentReader != null) {
                logger.debug("Closing reader");
                this.currentReader.close();
                this.currentReader = null;
            }
        }

        private boolean moveToNextChunk() throws IOException {
            if (this.currentChunk != null) {
                this.currentChunk.release();
            }
            this.currentChunk = null;
            if (this.currentReader.hasNext()) {
                this.currentChunk = this.getNextChunk();
                return true;
            }
            if (this.fileIndex < this.locations.length) {
                this.moveToNextReader();
                return this.currentReader != null;
            }
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
            }
            return false;
        }

        private boolean fillBuffer() throws IOException {
            if (this.currentChunk == null) {
                return false;
            }
            long startTime = System.currentTimeMillis();
            boolean hasData = false;
            while (this.currentChunk.isReadable() || this.moveToNextChunk()) {
                Set<Object> batchSet;
                this.currentChunk.readBytes(this.sizeBuf);
                int mapId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET);
                int attemptId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 4);
                int batchId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 8);
                int size = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 12);
                if (size > this.compressedBuf.length) {
                    this.compressedBuf = new byte[size];
                }
                this.currentChunk.readBytes(this.compressedBuf, 0, size);
                if (attemptId != this.attempts[mapId]) continue;
                if (!this.batchesRead.containsKey(mapId)) {
                    batchSet = new HashSet();
                    this.batchesRead.put(mapId, batchSet);
                }
                if (!(batchSet = this.batchesRead.get(mapId)).contains(batchId)) {
                    int originalLength;
                    batchSet.add(batchId);
                    if (this.callback != null) {
                        this.callback.incBytesRead(16 + size);
                    }
                    if (this.decompressedBuf.length < (originalLength = this.decompressor.getOriginalLen(this.compressedBuf))) {
                        this.decompressedBuf = new byte[originalLength];
                    }
                    this.limit = this.decompressor.decompress(this.compressedBuf, this.decompressedBuf, 0);
                    this.position = 0;
                    hasData = true;
                    break;
                }
                logger.debug("Skip duplicated batch: mapId {}, attemptId {}, batchId {}.", new Object[]{mapId, attemptId, batchId});
            }
            if (this.callback != null) {
                this.callback.incReadTime(System.currentTimeMillis() - startTime);
            }
            return hasData;
        }
    }
}

