/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HAHelper;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HARaftServer;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.MetaHandler;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.RatisSnapshotFileComparator;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.SnapshotRetentionPolicy;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.MD5FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine
extends BaseStateMachine {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachine.class);
    public static final Pattern MD5_REGEX = Pattern.compile("snapshot\\.(\\d+)_(\\d+)\\.md5");
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage(){

        public void cleanupOldSnapshots(SnapshotRetentionPolicy snapshotRetentionPolicy) throws IOException {
            if (snapshotRetentionPolicy != null && snapshotRetentionPolicy.getNumSnapshotsRetained() > 0) {
                ArrayList<SingleFileSnapshotInfo> allSnapshotFiles = new ArrayList<SingleFileSnapshotInfo>();
                ArrayList<SingleFileSnapshotInfo> allMD5Files = new ArrayList<SingleFileSnapshotInfo>();
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getSmDir().toPath());){
                    for (Path path : stream) {
                        if (this.filePatternMatches(SNAPSHOT_REGEX, allSnapshotFiles, path)) continue;
                        this.filePatternMatches(MD5_REGEX, allMD5Files, path);
                    }
                }
                SingleFileSnapshotInfo snapshotInfo = this.cleanupOldFiles(allSnapshotFiles, snapshotRetentionPolicy.getNumSnapshotsRetained(), false, null);
                this.cleanupOldFiles(allMD5Files, snapshotRetentionPolicy.getNumSnapshotsRetained(), true, snapshotInfo);
            }
        }

        private boolean filePatternMatches(Pattern pattern, List<SingleFileSnapshotInfo> result, Path filePath) {
            Matcher md5Matcher = pattern.matcher(filePath.getFileName().toString());
            if (md5Matcher.matches()) {
                long endIndex = Long.parseLong(md5Matcher.group(2));
                long term = Long.parseLong(md5Matcher.group(1));
                FileInfo fileInfo = new FileInfo(filePath, null);
                result.add(new SingleFileSnapshotInfo(fileInfo, term, endIndex));
                return true;
            }
            return false;
        }

        private SingleFileSnapshotInfo cleanupOldFiles(List<SingleFileSnapshotInfo> inputFiles, int retainedNum, boolean onlyCleanupMD5Files, SingleFileSnapshotInfo snapshotInfo) {
            SingleFileSnapshotInfo result = null;
            if (inputFiles.size() > retainedNum) {
                inputFiles.sort(new RatisSnapshotFileComparator());
                List<SingleFileSnapshotInfo> filesToBeCleaned = inputFiles.subList(retainedNum, inputFiles.size());
                result = filesToBeCleaned.get(0);
                for (SingleFileSnapshotInfo fileInfo : filesToBeCleaned) {
                    if (null != snapshotInfo && fileInfo.getIndex() >= snapshotInfo.getIndex() || onlyCleanupMD5Files && null == snapshotInfo) continue;
                    File file = fileInfo.getFile().getPath().toFile();
                    if (onlyCleanupMD5Files) {
                        LOG.info("Deleting old md5 file at {}.", (Object)file.getAbsolutePath());
                        FileUtils.deleteFileQuietly((File)file);
                        continue;
                    }
                    File md5File = new File(file.getAbsolutePath() + ".md5");
                    LOG.info("Deleting old snapshot at {}, md5 file at {}.", (Object)file.getAbsolutePath(), (Object)md5File.getAbsolutePath());
                    FileUtils.deleteFileQuietly((File)file);
                    FileUtils.deleteFileQuietly((File)md5File);
                }
            }
            return result;
        }
    };
    private final HARaftServer masterRatisServer;
    private RaftGroupId raftGroupId;
    private final ExecutorService executorService;
    private RaftServer mServer;
    private final MetaHandler metaHandler;

    public StateMachine(HARaftServer ratisServer) {
        this.masterRatisServer = ratisServer;
        this.metaHandler = ratisServer.getMetaHandler();
        this.executorService = ThreadUtils.newDaemonSingleThreadExecutor((String)"Master-Meta-StateMachine");
    }

    public void initialize(RaftServer server, RaftGroupId id, RaftStorage raftStorage) throws IOException {
        this.getLifeCycle().startAndTransition(() -> {
            super.initialize(server, id, raftStorage);
            this.mServer = server;
            this.raftGroupId = id;
            this.storage.init(raftStorage);
        }, new Class[0]);
        this.loadSnapshot(this.storage.getLatestSnapshot());
        LOG.info("Initialized State Machine.");
    }

    public void reinitialize() throws IOException {
        LOG.info("Reinitializing state machine.");
        this.getLifeCycle().compareAndTransition(LifeCycle.State.PAUSED, LifeCycle.State.STARTING);
        this.storage.loadLatestSnapshot();
        this.loadSnapshot(this.storage.getLatestSnapshot());
        this.getLifeCycle().compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING);
    }

    public void pause() {
        this.getLifeCycle().compareAndTransition(LifeCycle.State.RUNNING, LifeCycle.State.PAUSING);
        this.getLifeCycle().compareAndTransition(LifeCycle.State.PAUSING, LifeCycle.State.PAUSED);
    }

    private synchronized void loadSnapshot(SingleFileSnapshotInfo snapshot) throws IOException {
        if (snapshot == null) {
            return;
        }
        if (snapshot.getTermIndex().compareTo(this.getLastAppliedTermIndex()) <= 0) {
            LOG.info("obsolete snapshot provided: {}", (Object)snapshot.getTermIndex());
            return;
        }
        LOG.info("Loading Snapshot {}.", (Object)snapshot);
        File snapshotFile = snapshot.getFile().getPath().toFile();
        if (!snapshotFile.exists()) {
            throw new FileNotFoundException(String.format("The snapshot file %s does not exist", snapshotFile.getPath()));
        }
        try {
            this.setLastAppliedTermIndex(snapshot.getTermIndex());
            this.install(snapshotFile);
        }
        catch (IOException rethrow) {
            LOG.error("Failed to load snapshot {}", (Object)snapshot);
            throw rethrow;
        }
    }

    private void install(File snapshotFile) throws IOException {
        try {
            this.metaHandler.loadSnapShot(snapshotFile);
        }
        catch (IOException rethrow) {
            LOG.warn("Failed to install snapshot!", (Throwable)rethrow);
            throw rethrow;
        }
        LOG.info("Successfully installed snapshot!");
    }

    public SnapshotInfo getLatestSnapshot() {
        return this.storage.getLatestSnapshot();
    }

    public TransactionContext startTransaction(RaftClientRequest raftClientRequest) throws IOException {
        Preconditions.checkArgument((boolean)raftClientRequest.getRaftGroupId().equals((Object)this.raftGroupId));
        return this.handleStartTransactionRequests(raftClientRequest);
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        try {
            ResourceProtos.ResourceRequest request = HAHelper.convertByteStringToRequest(trx.getStateMachineLogEntry().getLogData());
            long trxLogIndex = trx.getLogEntry().getIndex();
            CompletableFuture<Message> ratisFuture = new CompletableFuture<Message>();
            CompletableFuture<ResourceProtos.ResourceResponse> future = CompletableFuture.supplyAsync(() -> this.runCommand(request, trxLogIndex), this.executorService);
            future.thenApply(response -> {
                if (!response.getSuccess()) {
                    LOG.warn("Failed to apply log {} for this raft group {}!", (Object)request.getCmdType(), (Object)this.raftGroupId);
                }
                byte[] responseBytes = response.toByteArray();
                ratisFuture.complete(Message.valueOf((ByteString)ByteString.copyFrom((byte[])responseBytes)));
                return ratisFuture;
            });
            return ratisFuture;
        }
        catch (Exception e) {
            return StateMachine.completeExceptionally(e);
        }
    }

    @VisibleForTesting
    protected ResourceProtos.ResourceResponse runCommand(ResourceProtos.ResourceRequest request, long trxLogIndex) {
        try {
            return this.metaHandler.handleWriteRequest(request);
        }
        catch (Throwable e) {
            String errorMessage = "Request " + request + "failed with exception";
            ExitUtils.terminate((int)1, (String)errorMessage, (Throwable)e, (Logger)LOG);
            return null;
        }
    }

    public CompletableFuture<Message> query(Message request) {
        try {
            byte[] bytes = request.getContent().toByteArray();
            return CompletableFuture.completedFuture(this.queryCommand(ResourceProtos.ResourceRequest.parseFrom(bytes)));
        }
        catch (IOException e) {
            return StateMachine.completeExceptionally(e);
        }
    }

    private Message queryCommand(ResourceProtos.ResourceRequest request) {
        ResourceProtos.ResourceResponse response = this.metaHandler.handleReadRequest(request);
        return HAHelper.convertResponseToMessage(response);
    }

    public long takeSnapshot() {
        File tempFile;
        if (this.mServer.getLifeCycleState() != LifeCycle.State.RUNNING) {
            LOG.warn("Skip taking snapshot because raft server is not in running state: current state is {}.", (Object)this.mServer.getLifeCycleState());
            return -1L;
        }
        TermIndex lastTermIndex = this.getLastAppliedTermIndex();
        LOG.debug("Current Snapshot Index {}.", (Object)lastTermIndex);
        try {
            tempFile = HAHelper.createTempSnapshotFile(this.storage);
            this.metaHandler.writeToSnapShot(tempFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to create temp snapshot file.", (Throwable)e);
            return -1L;
        }
        LOG.debug("Taking a snapshot to file {}.", (Object)tempFile);
        File snapshotFile = this.storage.getSnapshotFile(lastTermIndex.getTerm(), lastTermIndex.getIndex());
        try {
            MD5Hash digest = MD5FileUtil.computeMd5ForFile((File)tempFile);
            LOG.info("Saving digest {} for snapshot file {}.", (Object)digest, (Object)snapshotFile);
            MD5FileUtil.saveMD5File((File)snapshotFile, (MD5Hash)digest);
            LOG.info("Renaming a snapshot file {} to {}.", (Object)tempFile, (Object)snapshotFile);
            if (!tempFile.renameTo(snapshotFile)) {
                tempFile.delete();
                LOG.warn("Failed to rename snapshot from {} to {}.", (Object)tempFile, (Object)snapshotFile);
                return -1L;
            }
            this.storage.loadLatestSnapshot();
        }
        catch (Exception e) {
            tempFile.delete();
            LOG.warn("Failed to complete snapshot: {}.", (Object)snapshotFile, (Object)e);
            return -1L;
        }
        return lastTermIndex.getIndex();
    }

    public void notifyNotLeader(Collection<TransactionContext> pendingEntries) throws IOException {
        this.masterRatisServer.updateServerRole();
    }

    private TransactionContext handleStartTransactionRequests(RaftClientRequest raftClientRequest) {
        return TransactionContext.newBuilder().setClientRequest(raftClientRequest).setStateMachine((org.apache.ratis.statemachine.StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).setLogData(raftClientRequest.getMessage().getContent()).build();
    }

    @VisibleForTesting
    public void setRaftGroupId(RaftGroupId raftGroupId) {
        this.raftGroupId = raftGroupId;
    }

    private static <T> CompletableFuture<T> completeExceptionally(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }

    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }
}

