/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.AppDiskUsageMetric;
import org.apache.celeborn.common.meta.AppDiskUsageSnapShot;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.PbAppDiskUsageSnapshot;
import org.apache.celeborn.common.protocol.PbSnapshotMetaInfo;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.master.clustermeta.IMetadataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetaManager
implements IMetadataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMetaManager.class);
    public final Set<String> registeredShuffle = ConcurrentHashMap.newKeySet();
    public final Set<String> hostnameSet = ConcurrentHashMap.newKeySet();
    public final ArrayList<WorkerInfo> workers = new ArrayList();
    public final ConcurrentHashMap<String, Long> appHeartbeatTime = new ConcurrentHashMap();
    public final Set<WorkerInfo> blacklist = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> workerLostEvents = ConcurrentHashMap.newKeySet();
    protected RpcEnv rpcEnv;
    protected CelebornConf conf;
    public long initialEstimatedPartitionSize;
    public long estimatedPartitionSize;
    public final LongAdder partitionTotalWritten = new LongAdder();
    public final LongAdder partitionTotalFileCount = new LongAdder();
    public AppDiskUsageMetric appDiskUsageMetric = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRequestSlotsMeta(String shuffleKey, String hostName, Map<String, Map<String, Integer>> workerWithAllocations) {
        this.registeredShuffle.add(shuffleKey);
        String appId = (String)Utils.splitShuffleKey((String)shuffleKey)._1;
        this.appHeartbeatTime.compute(appId, (applicationId, oldTimestamp) -> {
            long oldTime = System.currentTimeMillis();
            if (oldTimestamp != null) {
                oldTime = oldTimestamp;
            }
            return Math.max(System.currentTimeMillis(), oldTime);
        });
        if (hostName != null) {
            this.hostnameSet.add(hostName);
        }
        if (!workerWithAllocations.isEmpty()) {
            ArrayList<WorkerInfo> arrayList = this.workers;
            synchronized (arrayList) {
                for (WorkerInfo workerInfo : this.workers) {
                    String workerUniqueId = workerInfo.toUniqueId();
                    if (!workerWithAllocations.containsKey(workerUniqueId)) continue;
                    workerInfo.allocateSlots(shuffleKey, workerWithAllocations.get(workerUniqueId));
                }
            }
        }
    }

    public void updateReleaseSlotsMeta(String shuffleKey) {
        this.updateReleaseSlotsMeta(shuffleKey, null, null);
    }

    public void updateReleaseSlotsMeta(String shuffleKey, List<String> workerIds, List<Map<String, Integer>> slots) {
        if (workerIds != null && !workerIds.isEmpty()) {
            for (int i = 0; i < workerIds.size(); ++i) {
                String workerId = workerIds.get(i);
                WorkerInfo worker = WorkerInfo.fromUniqueId((String)workerId);
                for (WorkerInfo w : this.workers) {
                    if (!w.equals((Object)worker)) continue;
                    Map<String, Integer> slotToRelease = slots.get(i);
                    LOG.info("release slots for worker {}, to release: {}", (Object)w, slotToRelease);
                    w.releaseSlots(shuffleKey, slotToRelease);
                }
            }
        } else {
            this.workers.forEach(workerInfo -> workerInfo.releaseSlots(shuffleKey));
        }
    }

    public void updateUnregisterShuffleMeta(String shuffleKey) {
        this.registeredShuffle.remove(shuffleKey);
    }

    public void updateAppHeartbeatMeta(String appId, long time, long totalWritten, long fileCount) {
        this.appHeartbeatTime.put(appId, time);
        this.partitionTotalWritten.add(totalWritten);
        this.partitionTotalFileCount.add(fileCount);
    }

    public void updateAppLostMeta(String appId) {
        this.registeredShuffle.stream().filter(shuffle -> shuffle.startsWith(appId)).forEach(this::updateReleaseSlotsMeta);
        this.registeredShuffle.removeIf(shuffleKey -> shuffleKey.startsWith(appId));
        this.appHeartbeatTime.remove(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerLostMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, null);
        this.workerLostEvents.add(worker);
        ArrayList<WorkerInfo> arrayList = this.workers;
        synchronized (arrayList) {
            this.workers.remove(worker);
        }
        this.blacklist.remove(worker);
        this.workerLostEvents.remove(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerRemoveMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, null);
        ArrayList<WorkerInfo> arrayList = this.workers;
        synchronized (arrayList) {
            this.workers.remove(worker);
        }
        this.blacklist.remove(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerHeartbeatMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> disks, Map<UserIdentifier, ResourceConsumption> userResourceConsumption, Map<String, Long> estimatedAppDiskUsage, long time) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, disks, userResourceConsumption, null);
        AtomicLong availableSlots = new AtomicLong();
        LOG.debug("update worker {}:{} heart beat {}", new Object[]{host, rpcPort, disks});
        ArrayList<WorkerInfo> arrayList = this.workers;
        synchronized (arrayList) {
            Optional<WorkerInfo> workerInfo = this.workers.stream().filter(w -> w.equals((Object)worker)).findFirst();
            workerInfo.ifPresent(info -> {
                info.updateThenGetDiskInfos(disks, this.estimatedPartitionSize);
                info.updateThenGetUserResourceConsumption(userResourceConsumption);
                availableSlots.set(info.totalAvailableSlots());
                info.lastHeartbeat_$eq(time);
            });
        }
        this.appDiskUsageMetric.update(estimatedAppDiskUsage);
        if (!this.blacklist.contains(worker) && disks.isEmpty()) {
            LOG.debug("Worker: {} num total slots is 0, add to blacklist", (Object)worker);
            this.blacklist.add(worker);
        } else if (availableSlots.get() > 0L) {
            this.blacklist.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegisterWorkerMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> disks, Map<UserIdentifier, ResourceConsumption> userResourceConsumption) {
        WorkerInfo workerInfo = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, disks, userResourceConsumption, null);
        workerInfo.lastHeartbeat_$eq(System.currentTimeMillis());
        try {
            workerInfo.setupEndpoint(this.rpcEnv.setupEndpointRef(RpcAddress.apply((String)host, (int)rpcPort), RpcNameConstants.WORKER_EP));
        }
        catch (Exception e) {
            LOG.warn("Worker register setupEndpoint failed {}, will retry", (Throwable)e);
            try {
                workerInfo.setupEndpoint(this.rpcEnv.setupEndpointRef(RpcAddress.apply((String)host, (int)rpcPort), RpcNameConstants.WORKER_EP));
            }
            catch (Exception e1) {
                workerInfo.setupEndpoint(null);
            }
        }
        workerInfo.updateDiskMaxSlots(this.estimatedPartitionSize);
        ArrayList<WorkerInfo> arrayList = this.workers;
        synchronized (arrayList) {
            if (!this.workers.contains(workerInfo)) {
                this.workers.add(workerInfo);
            }
        }
    }

    public void writeMetaInfoToFile(File file) throws IOException, RuntimeException {
        byte[] snapshotBytes = PbSerDeUtils.toPbSnapshotMetaInfo((Long)this.estimatedPartitionSize, this.registeredShuffle, this.hostnameSet, this.blacklist, this.workerLostEvents, this.appHeartbeatTime, this.workers, (Long)this.partitionTotalWritten.sum(), (Long)this.partitionTotalFileCount.sum(), (AppDiskUsageSnapShot[])this.appDiskUsageMetric.snapShots(), (AppDiskUsageSnapShot)((AppDiskUsageSnapShot)this.appDiskUsageMetric.currentSnapShot().get())).toByteArray();
        Files.write(file.toPath(), snapshotBytes, new OpenOption[0]);
    }

    public void restoreMetaFromFile(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            PbSnapshotMetaInfo snapshotMetaInfo = PbSnapshotMetaInfo.parseFrom((InputStream)in);
            this.estimatedPartitionSize = snapshotMetaInfo.getEstimatedPartitionSize();
            this.registeredShuffle.addAll((Collection<String>)snapshotMetaInfo.getRegisteredShuffleList());
            this.hostnameSet.addAll((Collection<String>)snapshotMetaInfo.getHostnameSetList());
            this.blacklist.addAll(snapshotMetaInfo.getBlacklistList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.workerLostEvents.addAll(snapshotMetaInfo.getWorkerLostEventsList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.appHeartbeatTime.putAll(snapshotMetaInfo.getAppHeartbeatTimeMap());
            this.registeredShuffle.forEach(shuffleKey -> {
                String appId = shuffleKey.split("-")[0];
                if (!this.appHeartbeatTime.containsKey(appId)) {
                    this.appHeartbeatTime.put(appId, System.currentTimeMillis());
                }
            });
            this.workers.addAll(snapshotMetaInfo.getWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.partitionTotalWritten.reset();
            this.partitionTotalWritten.add(snapshotMetaInfo.getPartitionTotalWritten());
            this.partitionTotalFileCount.reset();
            this.partitionTotalFileCount.add(snapshotMetaInfo.getPartitionTotalFileCount());
            this.appDiskUsageMetric.restoreFromSnapshot((AppDiskUsageSnapShot[])snapshotMetaInfo.getAppDiskUsageMetricSnapshotsList().stream().map(PbSerDeUtils::fromPbAppDiskUsageSnapshot).toArray(AppDiskUsageSnapShot[]::new));
            this.appDiskUsageMetric.currentSnapShot_$eq(new AtomicReference<AppDiskUsageSnapShot>(PbSerDeUtils.fromPbAppDiskUsageSnapshot((PbAppDiskUsageSnapshot)snapshotMetaInfo.getCurrentAppDiskUsageMetricsSnapshot())));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        LOG.info("Successfully restore meta info from snapshot {}", (Object)file.getAbsolutePath());
        LOG.info("Worker size: {}, Registered shuffle size: {}, Worker blacklist size: {}.", new Object[]{this.workers.size(), this.registeredShuffle.size(), this.blacklist.size()});
        this.workers.forEach(workerInfo -> LOG.info(workerInfo.toString()));
        this.registeredShuffle.forEach(shuffle -> LOG.info("RegisteredShuffle {}", shuffle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlacklistByReportWorkerUnavailable(List<WorkerInfo> failedWorkers) {
        ArrayList<WorkerInfo> arrayList = this.workers;
        synchronized (arrayList) {
            failedWorkers.retainAll(this.workers);
            this.blacklist.addAll(failedWorkers);
        }
    }

    public void updatePartitionSize() {
        long oldEstimatedPartitionSize = this.estimatedPartitionSize;
        long tmpTotalWritten = this.partitionTotalWritten.sumThenReset();
        long tmpFileCount = this.partitionTotalFileCount.sumThenReset();
        LOG.debug("update partition size total written {}, file count {}", (Object)Utils.bytesToString((long)tmpTotalWritten), (Object)tmpFileCount);
        this.estimatedPartitionSize = tmpFileCount != 0L ? tmpTotalWritten / tmpFileCount : this.initialEstimatedPartitionSize;
        LOG.warn("Rss cluster estimated partition size changed from {} to {}", (Object)Utils.bytesToString((long)oldEstimatedPartitionSize), (Object)Utils.bytesToString((long)this.estimatedPartitionSize));
        this.workers.stream().filter(worker -> !this.blacklist.contains(worker)).forEach(workerInfo -> workerInfo.updateDiskMaxSlots(this.estimatedPartitionSize));
    }
}

