/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.subtree;

import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.name.Dn;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;

public class BaseSubtreeSpecification
implements SubtreeSpecification {
    private final Dn base;
    private final Set<Dn> chopBefore;
    private final Set<Dn> chopAfter;
    private final int minBaseDistance;
    private final int maxBaseDistance;
    private final ExprNode refinement;

    public BaseSubtreeSpecification() {
        this.base = new Dn();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(ExprNode refinement) {
        this.base = new Dn();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = refinement;
    }

    public BaseSubtreeSpecification(Dn base) {
        this.base = base;
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(Dn base, int minBaseDistance, int maxBaseDistance, Set<Dn> chopAfter, Set<Dn> chopBefore) {
        this(base, minBaseDistance, maxBaseDistance, chopAfter, chopBefore, null);
    }

    public BaseSubtreeSpecification(Dn base, int minBaseDistance, int maxBaseDistance, Set<Dn> chopAfter, Set<Dn> chopBefore, ExprNode refinement) {
        this.base = base;
        this.minBaseDistance = minBaseDistance;
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
        this.chopAfter = chopAfter;
        this.chopBefore = chopBefore;
        this.refinement = refinement;
    }

    @Override
    public Dn getBase() {
        return this.base;
    }

    @Override
    public Set<Dn> getChopBeforeExclusions() {
        return this.chopBefore;
    }

    @Override
    public Set<Dn> getChopAfterExclusions() {
        return this.chopAfter;
    }

    @Override
    public int getMinBaseDistance() {
        return this.minBaseDistance;
    }

    @Override
    public int getMaxBaseDistance() {
        return this.maxBaseDistance;
    }

    @Override
    public ExprNode getRefinement() {
        return this.refinement;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.toString());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        boolean isFirst = true;
        buffer.append('{');
        if (!this.base.isEmpty()) {
            buffer.append(" base \"");
            buffer.append(this.base.getName());
            buffer.append('\"');
            isFirst = false;
        }
        if (this.minBaseDistance > 0) {
            if (isFirst) {
                isFirst = false;
                buffer.append(" ");
            } else {
                buffer.append(", ");
            }
            buffer.append("minimum ");
            buffer.append(this.minBaseDistance);
        }
        if (this.maxBaseDistance > -1) {
            if (isFirst) {
                isFirst = false;
                buffer.append(" ");
            } else {
                buffer.append(", ");
            }
            buffer.append("maximum ");
            buffer.append(this.maxBaseDistance);
        }
        if (this.chopBefore != null && !this.chopBefore.isEmpty() || this.chopAfter != null && !this.chopAfter.isEmpty()) {
            if (isFirst) {
                isFirst = false;
                buffer.append(" ");
            } else {
                buffer.append(", ");
            }
            buffer.append("specificExclusions { ");
            boolean isFirstExclusion = true;
            if (this.chopBefore != null) {
                for (Dn exclusion : this.chopBefore) {
                    if (isFirstExclusion) {
                        isFirstExclusion = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append("chopBefore: \"");
                    buffer.append(exclusion.getName());
                    buffer.append('\"');
                }
            }
            if (this.chopAfter != null) {
                for (Dn exclusion : this.chopAfter) {
                    if (isFirstExclusion) {
                        isFirstExclusion = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append("chopAfter: \"");
                    buffer.append(exclusion.getName());
                    buffer.append('\"');
                }
            }
            buffer.append(" }");
        }
        if (this.refinement != null) {
            if (isFirst) {
                buffer.append(" ");
            } else {
                buffer.append(", ");
            }
            buffer.append("specificationFilter ");
            buffer.append(this.refinement.toString());
        }
        buffer.append(" }");
        return buffer.toString();
    }
}

