/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class OtherMailboxSyntaxChecker
extends SyntaxChecker {
    public static final OtherMailboxSyntaxChecker INSTANCE = new OtherMailboxSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.39");

    private OtherMailboxSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String mailbox;
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        int dollar = strValue.indexOf(36);
        if (dollar == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        String mailboxType = strValue.substring(0, dollar);
        String string = mailbox = dollar < strValue.length() - 1 ? strValue.substring(dollar + 1) : "";
        if (mailbox.indexOf(36) != -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (!Strings.isPrintableString(mailboxType)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        boolean result = Strings.isIA5String(mailbox);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<OtherMailboxSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.39");
        }

        @Override
        public OtherMailboxSyntaxChecker build() {
            return new OtherMailboxSyntaxChecker(this.oid);
        }
    }
}

