/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class NormalizerSyntaxChecker
extends SyntaxChecker {
    public static final NormalizerSyntaxChecker INSTANCE = new NormalizerSyntaxChecker("1.3.6.1.4.1.18060.0.4.1.0.6");

    private NormalizerSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return true;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        boolean result = Strings.isIA5String(strValue);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<NormalizerSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.1.0.6");
        }

        @Override
        public NormalizerSyntaxChecker build() {
            return new NormalizerSyntaxChecker(this.oid);
        }
    }
}

