/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class MailPreferenceSyntaxChecker
extends SyntaxChecker {
    public static final MailPreferenceSyntaxChecker INSTANCE = new MailPreferenceSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.32");

    private MailPreferenceSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        boolean result;
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 8 || strValue.length() > 18) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        boolean bl = result = "NO-LISTS".equals(strValue) || "ANY-LIST".equals(strValue) || "PROFESSIONAL-LISTS".equals(strValue);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<MailPreferenceSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.32");
        }

        @Override
        public MailPreferenceSyntaxChecker build() {
            return new MailPreferenceSyntaxChecker(this.oid);
        }
    }
}

