/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.parsers.DitContentRuleDescriptionSchemaParser;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public final class DitContentRuleDescriptionSyntaxChecker
extends SyntaxChecker {
    private transient DitContentRuleDescriptionSchemaParser schemaParser = new DitContentRuleDescriptionSchemaParser();
    public static final DitContentRuleDescriptionSyntaxChecker INSTANCE = new DitContentRuleDescriptionSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.16");

    private DitContentRuleDescriptionSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        try {
            this.schemaParser.parse(strValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            }
            return true;
        }
        catch (ParseException pe) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DitContentRuleDescriptionSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.16");
        }

        @Override
        public DitContentRuleDescriptionSyntaxChecker build() {
            return new DitContentRuleDescriptionSyntaxChecker(this.oid);
        }
    }
}

