/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.helper;

import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.comparators.ComparableComparator;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MatchingRuleHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MatchingRuleHelper.class);

    private MatchingRuleHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(MatchingRule matchingRule, SchemaErrorHandler errorHandler, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                matchingRule.unlock();
                ComparableComparator ldapComparator = null;
                Normalizer normalizer = null;
                LdapSyntax ldapSyntax = null;
                try {
                    ldapComparator = (ComparableComparator)registries.getComparatorRegistry().lookup(matchingRule.getOid());
                }
                catch (LdapException ne) {
                    ldapComparator = new ComparableComparator(matchingRule.getOid());
                }
                try {
                    normalizer = (Normalizer)registries.getNormalizerRegistry().lookup(matchingRule.getOid());
                }
                catch (LdapException ne) {
                    normalizer = new NoOpNormalizer(matchingRule.getOid());
                }
                try {
                    ldapSyntax = (LdapSyntax)registries.getLdapSyntaxRegistry().lookup(matchingRule.getSyntaxOid());
                }
                catch (LdapException ne) {
                    String msg = I18n.err(I18n.ERR_13765_MR_MUST_REFER_EXISTING_SYNTAX, new Object[0]);
                    LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.MR_NONEXISTENT_SYNTAX, msg, ne);
                    ldapSchemaException.setSourceObject(matchingRule);
                    ldapSchemaException.setRelatedId(matchingRule.getSyntaxOid());
                    errorHandler.handle(LOG, msg, ldapSchemaException);
                }
                if (ldapComparator != null) {
                    registries.addReference(matchingRule, ldapComparator);
                    matchingRule.setLdapComparator(ldapComparator);
                }
                if (normalizer != null) {
                    registries.addReference(matchingRule, normalizer);
                    matchingRule.setNormalizer(normalizer);
                }
                if (ldapSyntax != null) {
                    registries.addReference(matchingRule, ldapSyntax);
                    matchingRule.setSyntax(ldapSyntax);
                }
            }
            finally {
                matchingRule.lock();
            }
        }
    }

    public static void removeFromRegistries(MatchingRule matchingRule, SchemaErrorHandler errorHandler, Registries registries) {
        if (registries != null) {
            if (matchingRule.getLdapComparator() != null) {
                registries.delReference(matchingRule, matchingRule.getLdapComparator());
            }
            if (matchingRule.getSyntax() != null) {
                registries.delReference(matchingRule, matchingRule.getSyntax());
            }
            if (matchingRule.getNormalizer() != null) {
                registries.delReference(matchingRule, matchingRule.getNormalizer());
            }
        }
    }
}

