/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message;

import java.util.Arrays;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.AbstractAbandonableRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.BindResponseImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.name.Dn;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public class BindRequestImpl
extends AbstractAbandonableRequest
implements BindRequest {
    private Dn dn;
    private String name;
    private byte[] credentials;
    private int hCredentials = 0;
    private String mechanism;
    private boolean isSimple = true;
    private boolean isVersion3 = true;
    private BindResponse response;

    public BindRequestImpl() {
        super(-1, MessageTypeEnum.BIND_REQUEST);
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    @Override
    public boolean getSimple() {
        return this.isSimple;
    }

    @Override
    public BindRequest setSimple(boolean simple) {
        this.isSimple = simple;
        return this;
    }

    @Override
    public byte[] getCredentials() {
        return this.credentials;
    }

    @Override
    public BindRequest setCredentials(String credentials) {
        return this.setCredentials(Strings.getBytesUtf8(credentials));
    }

    @Override
    public BindRequest setCredentials(byte[] credentials) {
        if (credentials != null) {
            this.credentials = new byte[credentials.length];
            System.arraycopy(credentials, 0, this.credentials, 0, credentials.length);
        } else {
            this.credentials = null;
        }
        if (credentials != null) {
            this.hCredentials = 0;
            for (byte b : credentials) {
                this.hCredentials = this.hCredentials * 31 + b;
            }
        } else {
            this.hCredentials = 0;
        }
        return this;
    }

    @Override
    public String getSaslMechanism() {
        return this.mechanism;
    }

    @Override
    public BindRequest setSaslMechanism(String saslMechanism) {
        this.isSimple = false;
        this.mechanism = saslMechanism;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BindRequest setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Dn getDn() {
        return this.dn;
    }

    @Override
    public BindRequest setDn(Dn dn) {
        this.dn = dn;
        this.name = dn.getName();
        return this;
    }

    @Override
    public boolean isVersion3() {
        return this.isVersion3;
    }

    @Override
    public boolean getVersion3() {
        return this.isVersion3;
    }

    @Override
    public BindRequest setVersion3(boolean version3) {
        this.isVersion3 = version3;
        return this;
    }

    @Override
    public BindRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public BindRequest addControl(Control control) {
        return (BindRequest)super.addControl(control);
    }

    @Override
    public BindRequest addAllControls(Control[] controls) {
        return (BindRequest)super.addAllControls(controls);
    }

    @Override
    public BindRequest removeControl(Control control) {
        return (BindRequest)super.removeControl(control);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return MessageTypeEnum.BIND_RESPONSE;
    }

    @Override
    public BindResponse getResultResponse() {
        if (this.response == null) {
            this.response = new BindResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public void abandon() {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_13506_CANNOT_ABANDON_OPERATION, new Object[0]));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BindRequest)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BindRequest req = (BindRequest)obj;
        if (req.isSimple() != this.isSimple()) {
            return false;
        }
        if (req.isVersion3() != this.isVersion3()) {
            return false;
        }
        String name1 = req.getName();
        String name2 = this.getName();
        if (Strings.isEmpty(name1)) {
            if (!Strings.isEmpty(name2)) {
                return false;
            }
        } else {
            if (Strings.isEmpty(name2)) {
                return false;
            }
            if (!name2.equals(name1)) {
                return false;
            }
        }
        Dn dn1 = req.getDn();
        Dn dn2 = this.getDn();
        if (Dn.isNullOrEmpty(dn1)) {
            if (!Dn.isNullOrEmpty(dn2)) {
                return false;
            }
        } else {
            if (Dn.isNullOrEmpty(dn2)) {
                return false;
            }
            if (!dn1.equals(dn2)) {
                return false;
            }
        }
        return Arrays.equals(req.getCredentials(), this.getCredentials());
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + (this.credentials == null ? 0 : this.hCredentials);
        hash = hash * 17 + (this.isSimple ? 0 : 1);
        hash = hash * 17 + (this.isVersion3 ? 0 : 1);
        hash = hash * 17 + (this.mechanism == null ? 0 : this.mechanism.hashCode());
        hash = hash * 17 + (this.name == null ? 0 : this.name.hashCode());
        hash = hash * 17 + (this.response == null ? 0 : this.response.hashCode());
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    BindRequest\n");
        sb.append("        Version : '").append(this.isVersion3 ? "3" : "2").append("'\n");
        if (this.isSimple) {
            if (Strings.isEmpty(this.name) && (this.dn == null || this.dn.equals(Dn.EMPTY_DN))) {
                sb.append("        Name : anonymous\n");
            } else {
                sb.append("        Name : '").append(this.name).append("'\n");
                sb.append("        Simple authentication : '").append("(omitted-for-safety)").append("'\n");
            }
        } else {
            sb.append("        Sasl credentials\n");
            sb.append("            Mechanism :'").append(this.mechanism).append("'\n");
            if (this.credentials == null) {
                sb.append("            Credentials : null");
            } else {
                sb.append("            Credentials : (omitted-for-safety)");
            }
        }
        return super.toString(sb.toString());
    }
}

