/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.AbstractContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseGrammar;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseStates;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsStates;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.extended.endTransaction.UpdateControls;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;

public class EndTransactionResponseContainer
extends AbstractContainer {
    private EndTransactionResponse endTransactionResponse;
    private UpdateControls currentUpdateControls;

    public EndTransactionResponseContainer() {
        this.setGrammar(EndTransactionResponseGrammar.getInstance());
        this.setTransition(EndTransactionResponseStates.START_STATE);
    }

    public EndTransactionResponse getEndTransactionResponse() {
        return this.endTransactionResponse;
    }

    public void setEndTransactionResponse(EndTransactionResponse endTransactionResponse) {
        this.endTransactionResponse = endTransactionResponse;
    }

    public UpdateControls getCurrentUpdateControls() {
        return this.currentUpdateControls;
    }

    public void setCurrentControls(UpdateControls currentUpdateControls) {
        this.currentUpdateControls = currentUpdateControls;
    }

    @Override
    public void clean() {
        super.clean();
        this.endTransactionResponse = null;
        this.currentUpdateControls = null;
    }

    public static List<Control> decode(byte[] controlsBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlsBytes);
        ControlsContainer container = new ControlsContainer();
        while (bb.hasRemaining()) {
            Asn1Decoder.decode(bb, container);
            container.setState(TLVStateEnum.TAG_STATE_START);
            container.setTransition(ControlsStates.START_STATE);
        }
        return container.getControls();
    }
}

