/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv_impl;

import org.apache.hadoop.shaded.org.apache.directory.api.asn1.DecoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponse;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponseImpl;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewResponseContainer;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.model.message.Control;

public class VirtualListViewResponseFactory
extends AbstractControlFactory<VirtualListViewResponse> {
    public VirtualListViewResponseFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.10");
    }

    @Override
    public VirtualListViewResponse newControl() {
        return new VirtualListViewResponseImpl();
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        int start = buffer.getPos();
        VirtualListViewResponse vlvResponse = (VirtualListViewResponse)control;
        if (vlvResponse.getContextId() != null) {
            BerValue.encodeOctetString(buffer, vlvResponse.getContextId());
        }
        BerValue.encodeEnumerated(buffer, vlvResponse.getVirtualListViewResult().getValue());
        BerValue.encodeInteger(buffer, vlvResponse.getContentCount());
        BerValue.encodeInteger(buffer, vlvResponse.getTargetPosition());
        BerValue.encodeSequence(buffer, start);
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new VirtualListViewResponseContainer(control), control, controlBytes);
    }
}

