/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.EncoderException;
import org.apache.hadoop.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.shaded.org.apache.directory.api.i18n.I18n;
import org.apache.hadoop.shaded.org.apache.directory.api.ldap.codec.search.Filter;
import org.apache.hadoop.shaded.org.apache.directory.api.util.Strings;

public class PresentFilter
extends Filter {
    private String attributeDescription;
    private byte[] attributeDescriptionBytes;

    public PresentFilter(int tlvId) {
        super(tlvId);
    }

    public PresentFilter() {
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(String attributeDescription) {
        this.attributeDescription = attributeDescription;
    }

    @Override
    public int computeLength() {
        this.attributeDescriptionBytes = Strings.getBytesUtf8(this.attributeDescription);
        return 1 + TLV.getNbBytes(this.attributeDescriptionBytes.length) + this.attributeDescriptionBytes.length;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        try {
            buffer.put((byte)-121);
            buffer.put(TLV.getBytes(this.attributeDescriptionBytes.length));
            buffer.put(this.attributeDescriptionBytes);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, new Object[0]), boe);
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attributeDescription).append("=*");
        return sb.toString();
    }
}

